/******************************** LICENSE ********************************

 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at 

    http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 ******************************** LICENSE ********************************/

/*! \file MonthMethodComposition.h
    \brief Definition of the Template class MonthMethodComposition.
    
    Magics Team - ECMWF 2005
    
    Started: Mon 10-Oct-2005
    
    Changes:
    
*/

#ifndef MonthMethodComposition_H
#define MonthMethodComposition_H

#include "magics.h"
#include "Translator.h"
#include "AxisItem.h"
#include "Factory.h"


namespace magics {

class MonthMethodComposition {

public:
	MonthMethodComposition();
	virtual ~MonthMethodComposition();
    
    virtual void set(const XmlNode&) {  }
    virtual void set(const map<string, string>&) { }
    virtual bool accept(const string&) { return false; }
    virtual MonthMethodComposition* clone() const {
        Log::dev() << "(const map<string, string&)---> to be checked!...\n";
        return new MonthMethodComposition();
    }
     virtual void toxml(ostream&, int)  const {}
     
     virtual void operator()(AxisItem& item) const { item.format("%b"); }
     	
	

    
protected:
     //! Method to print string about this class on to a stream of type ostream (virtual).
	 virtual void print(ostream&) const; 

private:
    //! Copy constructor - No copy allowed
	MonthMethodComposition(const MonthMethodComposition&);
    //! Overloaded << operator to copy - No copy allowed
	MonthMethodComposition& operator=(const MonthMethodComposition&);

// -- Friends
    //! Overloaded << operator to call print().
	friend ostream& operator<<(ostream& s,const MonthMethodComposition& p)
		{ p.print(s); return s; }

};

class OneMonthMethodComposition : public MonthMethodComposition 
{
public:
	OneMonthMethodComposition() {}
	~OneMonthMethodComposition() {}
	MonthMethodComposition* clone() const {      
        return new OneMonthMethodComposition();
    }
    virtual void operator()(AxisItem& item) const { 
    	item.format("%b");   	
    	string label = item.label();   
    	item.id(label);
    	label = label.substr(0,1);
    	item.label(label);
    	
    }
};

class FullMonthMethodComposition : public MonthMethodComposition 
{
public:
	FullMonthMethodComposition() {}
	~FullMonthMethodComposition() {}
	MonthMethodComposition* clone() const {      
        return new FullMonthMethodComposition();
    }
    virtual void operator()(AxisItem& item) const { item.format("%B"); }
};   
	
class MonthYearMethodComposition : public MonthMethodComposition 
{
public:
	MonthYearMethodComposition() {}
	~MonthYearMethodComposition() {}
	MonthMethodComposition* clone() const {      
        return new MonthYearMethodComposition();
    }
    virtual void operator()(AxisItem& item) const { item.format("%B %Y"); }
};   
	

template <>
class Translator<string, MonthMethodComposition> { 
public:
	MonthMethodComposition* operator()(const string& val )
	{
		return SimpleObjectMaker<MonthMethodComposition>::create(val);
	}     

	MonthMethodComposition* magics(const string& param)
	{
		MonthMethodComposition* object;
		ParameterManager::update(param, object);
		return object;
	}
};



} // namespace magics
#endif
