/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file ObsJSonAttributes.cc
    \brief Implemtation of ObsJSon Attributes class.
    \author Graphics Section, ECMWF

    This file is automatically generated.
    Do Not Edit!
   
    Generated: Thu Jun 16 12:02:58 2011
*/    

#include "ObsJSonAttributes.h"
#include "MagicsParameter.h"
#include "Factory.h"
#include "Translator.h"
#include "XmlNode.h"
#include "ParameterSettings.h"


using namespace magics;


ObsJSonAttributes::ObsJSonAttributes():
	path_(ParameterManager::getString("obsjson_input_filename"))
{
} 



ObsJSonAttributes::~ObsJSonAttributes()
{
}

    
void ObsJSonAttributes::set(const std::map<string, string>& params)
{
	vector<string> prefix(1);
	prefix[0] = "obsjson";

	setAttribute(prefix, "obsjson_input_filename", path_, params);
}

void ObsJSonAttributes::copy(const ObsJSonAttributes& other)
{
	path_ = other.path_;
} 


bool ObsJSonAttributes::accept(const string& node)
{	
	if ( magCompare(node, "obsjson")  )
		return true;
	return false;
}

void ObsJSonAttributes::set(const XmlNode& node)
{
	if ( this->accept(node.name()) == false ) 
		return;

	if ( magCompare(node.name(), "obsjson") )
		set(node.attributes());
	else {
	}
	for (XmlNode::ElementIterator elt = node.firstElement(); elt != node.lastElement(); ++elt) {
	}
}

void ObsJSonAttributes::print(ostream& out)  const
{
	out << "ObsJSonAttributes[";
	out << "path = " << path_;
	out << "]" << "\n";
}


void ObsJSonAttributes::toxml(ostream& out, const string& tag, int tabs)  const
{
	string tab;
	for ( int t = 0; t < tabs; t++) tab = tab + "	";
	
	out << tab << "<" << tag << "\n";
	out << tab << "\tobsjson_input_filename = \'" << path_ << "\'\n";
	out << tab << ">";


	out << tab << "</" << tag << ">\n";
}

static MagicsParameter<string> obsjson_input_filename("obsjson_input_filename", "", "");
