/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file WrepJSonAttributes.cc
    \brief Implemtation of WrepJSon Attributes class.
    \author Graphics Section, ECMWF

    This file is automatically generated.
    Do Not Edit!
   
    Generated: Thu Jun 16 12:02:58 2011
*/    

#include "WrepJSonAttributes.h"
#include "MagicsParameter.h"
#include "Factory.h"
#include "Translator.h"
#include "XmlNode.h"
#include "ParameterSettings.h"


using namespace magics;


WrepJSonAttributes::WrepJSonAttributes():
	path_(ParameterManager::getString("wrepjson_input_filename")),
	title_(ParameterManager::getString("wrepjson_title")),
	family_(ParameterManager::getString("wrepjson_family")),
	param_title_(ParameterManager::getString("wrepjson_parameter_title")),
	plumes_(ParameterManager::getDouble("wrepjson_plumes_interval")),
	information_(Translator<string, bool>().magics("wrepjson_information")),
	keyword_(ParameterManager::getString("wrepjson_keyword")),
	station_name_(ParameterManager::getString("wrepjson_station_name")),
	param_(ParameterManager::getString("wrepjson_parameter")),
	param_scaling_factor_(ParameterManager::getDouble("wrepjson_parameter_scaling_factor")),
	param_offset_factor_(ParameterManager::getDouble("wrepjson_parameter_offset_factor")),
	clim_param_(ParameterManager::getString("wrepjson_clim_parameter")),
	clim_step_(ParameterManager::getInt("wrepjson_clim_step")),
	steps_(Translator<intarray, intarray>().magics("wrepjson_steps"))
{
} 



WrepJSonAttributes::~WrepJSonAttributes()
{
}

    
void WrepJSonAttributes::set(const std::map<string, string>& params)
{
	vector<string> prefix(1);
	prefix[0] = "wrepjson";

	setAttribute(prefix, "wrepjson_input_filename", path_, params);
	setAttribute(prefix, "wrepjson_title", title_, params);
	setAttribute(prefix, "wrepjson_family", family_, params);
	setAttribute(prefix, "wrepjson_parameter_title", param_title_, params);
	setAttribute(prefix, "wrepjson_plumes_interval", plumes_, params);
	setAttribute(prefix, "wrepjson_information", information_, params);
	setAttribute(prefix, "wrepjson_keyword", keyword_, params);
	setAttribute(prefix, "wrepjson_station_name", station_name_, params);
	setAttribute(prefix, "wrepjson_parameter", param_, params);
	setAttribute(prefix, "wrepjson_parameter_scaling_factor", param_scaling_factor_, params);
	setAttribute(prefix, "wrepjson_parameter_offset_factor", param_offset_factor_, params);
	setAttribute(prefix, "wrepjson_clim_parameter", clim_param_, params);
	setAttribute(prefix, "wrepjson_clim_step", clim_step_, params);
	setAttribute(prefix, "wrepjson_steps", steps_, params);
}

void WrepJSonAttributes::copy(const WrepJSonAttributes& other)
{
	path_ = other.path_;
	title_ = other.title_;
	family_ = other.family_;
	param_title_ = other.param_title_;
	plumes_ = other.plumes_;
	information_ = other.information_;
	keyword_ = other.keyword_;
	station_name_ = other.station_name_;
	param_ = other.param_;
	param_scaling_factor_ = other.param_scaling_factor_;
	param_offset_factor_ = other.param_offset_factor_;
	clim_param_ = other.clim_param_;
	clim_step_ = other.clim_step_;
	steps_ = other.steps_;
} 


bool WrepJSonAttributes::accept(const string& node)
{	
	if ( magCompare(node, "wrepjson")  )
		return true;
	return false;
}

void WrepJSonAttributes::set(const XmlNode& node)
{
	if ( this->accept(node.name()) == false ) 
		return;

	if ( magCompare(node.name(), "wrepjson") )
		set(node.attributes());
	else {
	}
	for (XmlNode::ElementIterator elt = node.firstElement(); elt != node.lastElement(); ++elt) {
	}
}

void WrepJSonAttributes::print(ostream& out)  const
{
	out << "WrepJSonAttributes[";
	out << "path = " << path_;
	out << ", title = " << title_;
	out << ", family = " << family_;
	out << ", param_title = " << param_title_;
	out << ", plumes = " << plumes_;
	out << ", information = " << information_;
	out << ", keyword = " << keyword_;
	out << ", station_name = " << station_name_;
	out << ", param = " << param_;
	out << ", param_scaling_factor = " << param_scaling_factor_;
	out << ", param_offset_factor = " << param_offset_factor_;
	out << ", clim_param = " << clim_param_;
	out << ", clim_step = " << clim_step_;
	out << ", steps = " << steps_;
	out << "]" << "\n";
}


void WrepJSonAttributes::toxml(ostream& out, const string& tag, int tabs)  const
{
	string tab;
	for ( int t = 0; t < tabs; t++) tab = tab + "	";
	
	out << tab << "<" << tag << "\n";
	out << tab << "\twrepjson_input_filename = \'" << path_ << "\'\n";
	out << tab << "\twrepjson_title = \'" << title_ << "\'\n";
	out << tab << "\twrepjson_family = \'" << family_ << "\'\n";
	out << tab << "\twrepjson_parameter_title = \'" << param_title_ << "\'\n";
	out << tab << "\twrepjson_plumes_interval = \'" << plumes_ << "\'\n";
	out << tab << "\twrepjson_information = \'" << information_ << "\'\n";
	out << tab << "\twrepjson_keyword = \'" << keyword_ << "\'\n";
	out << tab << "\twrepjson_station_name = \'" << station_name_ << "\'\n";
	out << tab << "\twrepjson_parameter = \'" << param_ << "\'\n";
	out << tab << "\twrepjson_parameter_scaling_factor = \'" << param_scaling_factor_ << "\'\n";
	out << tab << "\twrepjson_parameter_offset_factor = \'" << param_offset_factor_ << "\'\n";
	out << tab << "\twrepjson_clim_parameter = \'" << clim_param_ << "\'\n";
	out << tab << "\twrepjson_clim_step = \'" << clim_step_ << "\'\n";
	out << tab << "\twrepjson_steps = \'" << steps_ << "\'\n";
	out << tab << ">";


	out << tab << "</" << tag << ">\n";
}

static MagicsParameter<string> wrepjson_input_filename("wrepjson_input_filename", "", "");
static MagicsParameter<string> wrepjson_title("wrepjson_title", "", "");
static MagicsParameter<string> wrepjson_family("wrepjson_family", "eps", "");
static MagicsParameter<string> wrepjson_parameter_title("wrepjson_parameter_title", "", "");
static MagicsParameter<double> wrepjson_plumes_interval("wrepjson_plumes_interval", 1, "");
static MagicsParameter<string> wrepjson_information("wrepjson_information", "on", "");
static MagicsParameter<string> wrepjson_keyword("wrepjson_keyword", "", "");
static MagicsParameter<string> wrepjson_station_name("wrepjson_station_name", "", "");
static MagicsParameter<string> wrepjson_parameter("wrepjson_parameter", "1", "");
static MagicsParameter<double> wrepjson_parameter_scaling_factor("wrepjson_parameter_scaling_factor", 1, "");
static MagicsParameter<double> wrepjson_parameter_offset_factor("wrepjson_parameter_offset_factor", 0, "");
static MagicsParameter<string> wrepjson_clim_parameter("wrepjson_clim_parameter", "", "");
static MagicsParameter<int> wrepjson_clim_step("wrepjson_clim_step", 36, "");
static MagicsParameter<intarray> wrepjson_steps("wrepjson_steps", intarray(), "");
