/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file AxisTickLabelAttributes.h
    \brief Definition of AxisTickLabel Attributes class.
    \author MeteoroMagLogical Visualisation Section, ECMWF

    This file is automatically generated.
    Do Not Edit!

    Generated: Tue Nov 22 10:53:40 2011
*/
   

#ifndef AxisTickLabelAttributes_H
#define AxisTickLabelAttributes_H

#include "magics.h"
#include "ParameterManager.h"
#include "Factory.h"


#include "Colour.h"
#include "AxisTickLabelType.h"

namespace magics {

class XmlNode;



class AxisTickLabelAttributes 
{
public:
//  --  constructor
    AxisTickLabelAttributes();
    
//  --  destructor
    virtual ~AxisTickLabelAttributes();
    
    virtual void set(const std::map<string, string>&);
    virtual void set(const XmlNode&);
    virtual void copy(const AxisTickLabelAttributes&);
    virtual bool accept(const string&);

    void setTag(const string& tag) { tag_ = tag; }

    void setXmlData(const string&)  {}
/*!
    Magics Information:
    \brief  Colour of tick labels
    \param colour Setting axis_tick_label_colour - default=automatic
*/
	void setColour(Colour* colour) 
		{ auto_ptr<Colour> tmp(colour); colour_ = tmp; } 
	const Colour&  getColour() const 
		{ return *colour_; }
/*!
    Magics Information:
    \brief  Turn off first (left or bottom) tick label (ON/OFF) 
    \param first Setting axis_tick_label_first - default=on
*/
	void setFirst(bool first) 
		{ first_ =  first; } 
	bool getFirst() const 
		{ return first_; } 
        
/*!
    Magics Information:
    \brief  Label every nth tick mark 
    \param frequency Setting axis_tick_label_frequency - default=1
*/
	void setFrequency(int frequency) 
		{ frequency_ =  frequency; } 
	int getFrequency() const 
		{ return frequency_; } 
        
/*!
    Magics Information:
    \brief  Height of tick labels 
    \param height Setting axis_tick_label_height - default=0.3
*/
	void setHeight(double height) 
		{ height_ =  height; } 
	double getHeight() const 
		{ return height_; } 
        
/*!
    Magics Information:
    \brief  Turn off last (right or top) tick label (ON/OFF) 
    \param last Setting axis_tick_label_last - default=on
*/
	void setLast(bool last) 
		{ last_ =  last; } 
	bool getLast() const 
		{ return last_; } 
        
/*!
    Magics Information:
    \brief  Orientation of the tick labels(HORIZONTAL/VERTICAL/PARALLEL) 
    \param orientation Setting axis_tick_label_orientation - default=horizontal
*/
	void setOrientation(const string& orientation) 
		{ orientation_ =  orientation; } 
	const string& getOrientation() const 
		{ return orientation_; } 
        
/*!
    Magics Information:
    \brief  Position labels on or between ticks(ON_TICK/INTER_TICK) 
    \param position Setting axis_tick_label_position - default=on_tick
*/
	void setPosition(const string& position) 
		{ position_ =  position; } 
	const string& getPosition() const 
		{ return position_; } 
        
/*!
    Magics Information:
    \brief Font name - please make sure this font is installed!
    \param font Setting axis_tick_label_font - default=sansserif
*/
	void setFont(const string& font) 
		{ font_ =  font; } 
	const string& getFont() const 
		{ return font_; } 
        
/*!
    Magics Information:
    \brief Font style. Set this to an empty string in order to remove all styling.
    \param font_style Setting axis_tick_label_font_style - default=
*/
	void setFont_style(const string& font_style) 
		{ font_style_ =  font_style; } 
	const string& getFont_style() const 
		{ return font_style_; } 
        
/*!
    Magics Information:
    \brief  Type of tick labels required (LABEL_LIST/NUMBER/LATITUDE/LONGITUDE) 
    \param type Setting axis_tick_label_type - default=number
*/
	void setType(AxisTickLabelType* type) 
		{ auto_ptr<AxisTickLabelType> tmp(type); type_ = tmp; } 
	const AxisTickLabelType&  getType() const 
		{ return *type_; }
	virtual void toxml(ostream& out, int tabs = 0) const { toxml(out, tag_, tabs); }

protected:
	//  --  method
	virtual void print(ostream&) const;
	virtual void toxml(ostream&, const string&, int tabs) const;

	//  --  members:
	string tag_;
	auto_ptr<Colour> colour_;
	bool first_;
	int frequency_;
	double height_;
	bool last_;
	string orientation_;
	string position_;
	string font_;
	string font_style_;
	auto_ptr<AxisTickLabelType> type_;

private:
  
	friend ostream& operator<<(ostream& s,const AxisTickLabelAttributes& p)
	{ p.print(s); return s; }
};

} // namespace magics

#endif
