/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file HiLoSaveAttributes.h
    \brief Definition of HiLoSave Attributes class.
    \author MeteoroMagLogical Visualisation Section, ECMWF

    This file is automatically generated.
    Do Not Edit!

    Generated: Tue Nov 22 10:53:39 2011
*/
   

#ifndef HiLoSaveAttributes_H
#define HiLoSaveAttributes_H

#include "magics.h"
#include "ParameterManager.h"
#include "Factory.h"


#include "Path.h"

namespace magics {

class XmlNode;



class HiLoSaveAttributes 
{
public:
//  --  constructor
    HiLoSaveAttributes();
    
//  --  destructor
    virtual ~HiLoSaveAttributes();
    
    virtual void set(const std::map<string, string>&);
    virtual void set(const XmlNode&);
    virtual void copy(const HiLoSaveAttributes&);
    virtual bool accept(const string&);

    void setTag(const string& tag) { tag_ = tag; }

    void setXmlData(const string&)  {}
/*!
    Magics Information:
    \brief  Path/filename of  HiLo file to write 
    \param file_name Setting contour_hilo_position_file_name - default=
*/
	void setFile_name(Path* file_name) 
		{ auto_ptr<Path> tmp(file_name); file_name_ = tmp; } 
	const Path&  getFile_name() const 
		{ return *file_name_; }
	virtual void toxml(ostream& out, int tabs = 0) const { toxml(out, tag_, tabs); }

protected:
	//  --  method
	virtual void print(ostream&) const;
	virtual void toxml(ostream&, const string&, int tabs) const;

	//  --  members:
	string tag_;
	auto_ptr<Path> file_name_;

private:
  
	friend ostream& operator<<(ostream& s,const HiLoSaveAttributes& p)
	{ p.print(s); return s; }
};

} // namespace magics

#endif
