/******************************** LICENSE ********************************

 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at 

    http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 ******************************** LICENSE ********************************/

/*! \file HiLoSaveBase.h
    \brief Definition of the Template class HiLoSaveBase.
    
    Magics Team - ECMWF 2006
    
    Started: Fri 10-Feb-2006
    
    Changes:
    
*/

#ifndef HiLoSaveBase_H
#define HiLoSaveBase_H

#include "magics.h"
#include "MagTranslator.h"
#include "Factory.h"



namespace magics {

class XmlNode;

template <class P>
class HiLoSaveBase {

public:
	HiLoSaveBase() {}
	virtual ~HiLoSaveBase() {}
    
    virtual void set(const XmlNode&) {
        MagLog::dev() << "HiLoSaveBase::set(const XmlNode&)---> to be checked!...\n";
    }
    virtual void set(const map<string, string>&) {
        MagLog::dev() << "HiLoSaveBase::set(const map<string, string&)---> to be checked!...\n";
    }
    virtual bool accept(const string&) { return false; }
    virtual HiLoSaveBase* clone() const {
        MagLog::dev() << "HiLoSaveBase::set(const map<string, string&)---> to be checked!...\n";
        return new HiLoSaveBase();
    }
    virtual void toxml(ostream&, int = 0) const {
    	 MagLog::dev() << "HiLoSaveBase::virtual void toxml(ostream&, int = 0) const ---> to be checked!...\n";
    } 
    virtual void open() {
    	MagLog::dev() << "HiLoSaveBase::open()---> to be checked!...\n";
    }
    virtual void operator()(const P&) {
    	MagLog::dev() << "HiLoSaveBase::operator()(const P&)---> to be checked!...\n";
    }
protected:
     //! Method to print string about this class on to a stream of type ostream (virtual).
	 virtual void print(ostream& out) const { out << "HiLoSaveBase\n"; } 

private:
    //! Copy constructor - No copy allowed
	HiLoSaveBase(const HiLoSaveBase&);
    //! Overloaded << operator to copy - No copy allowed
	HiLoSaveBase& operator=(const HiLoSaveBase&);

// -- Friends
    //! Overloaded << operator to call print().
	friend ostream& operator<<(ostream& s,const HiLoSaveBase<P>& p)
		{ p.print(s); return s; }

};

template <class P>
class MagTranslator<string, HiLoSaveBase<P> > { 
public:
	HiLoSaveBase<P>* operator()(const string& val )
	{
		return SimpleObjectMaker<HiLoSaveBase<P> >::create(val);
	}     

	HiLoSaveBase<P>* magics(const string& param)
	{
		string val;
		ParameterManager::get(param, val);
		return (*this)(val);
	}
};

} // namespace magics
#endif
