/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file EpsPlumeAttributes.cc
    \brief Implementation of EpsPlume Attributes class.
    \author Meteorological Visualisation Section, ECMWF

    This file is automatically generated.
    Do Not Edit!
   
    Generated: Wed Dec  5 12:07:14 2012
*/    

#include "EpsPlumeAttributes.h"
#include "MagicsParameter.h"
#include "Factory.h"
#include "MagTranslator.h"
#include "XmlNode.h"
#include "ParameterSettings.h"


using namespace magics;


EpsPlumeAttributes::EpsPlumeAttributes():
	method_(ParameterManager::getString("eps_plume_method")),
	line_colour_(MagTranslator<string, Colour>().magics("eps_plume_line_colour")),
	line_style_(MagTranslator<string, LineStyle>().magics("eps_plume_line_style")),
	line_thickness_(ParameterManager::getInt("eps_plume_line_thickness")),
	forecast_line_colour_(MagTranslator<string, Colour>().magics("eps_plume_forecast_line_colour")),
	forecast_line_style_(MagTranslator<string, LineStyle>().magics("eps_plume_forecast_line_style")),
	forecast_line_thickness_(ParameterManager::getInt("eps_plume_forecast_line_thickness")),
	control_line_colour_(MagTranslator<string, Colour>().magics("eps_plume_control_line_colour")),
	control_line_style_(MagTranslator<string, LineStyle>().magics("eps_plume_control_line_style")),
	control_line_thickness_(ParameterManager::getInt("eps_plume_control_line_thickness"))
{
} 



EpsPlumeAttributes::~EpsPlumeAttributes()
{
}

    
void EpsPlumeAttributes::set(const std::map<string, string>& params)
{
	vector<string> prefix(2);
	prefix[0] = "eps_plume";
	prefix[1] = "eps";

	setAttribute(prefix, "eps_plume_method", method_, params);
	setAttribute(prefix, "eps_plume_line_colour", line_colour_, params);
	setAttribute(prefix, "eps_plume_line_style", line_style_, params);
	setAttribute(prefix, "eps_plume_line_thickness", line_thickness_, params);
	setAttribute(prefix, "eps_plume_forecast_line_colour", forecast_line_colour_, params);
	setAttribute(prefix, "eps_plume_forecast_line_style", forecast_line_style_, params);
	setAttribute(prefix, "eps_plume_forecast_line_thickness", forecast_line_thickness_, params);
	setAttribute(prefix, "eps_plume_control_line_colour", control_line_colour_, params);
	setAttribute(prefix, "eps_plume_control_line_style", control_line_style_, params);
	setAttribute(prefix, "eps_plume_control_line_thickness", control_line_thickness_, params);
}

void EpsPlumeAttributes::copy(const EpsPlumeAttributes& other)
{
	method_ = other.method_;
	line_colour_ = auto_ptr<Colour>(other.line_colour_->clone());
	line_style_ = other.line_style_;
	line_thickness_ = other.line_thickness_;
	forecast_line_colour_ = auto_ptr<Colour>(other.forecast_line_colour_->clone());
	forecast_line_style_ = other.forecast_line_style_;
	forecast_line_thickness_ = other.forecast_line_thickness_;
	control_line_colour_ = auto_ptr<Colour>(other.control_line_colour_->clone());
	control_line_style_ = other.control_line_style_;
	control_line_thickness_ = other.control_line_thickness_;
} 


bool EpsPlumeAttributes::accept(const string& node)
{	
	if ( magCompare(node, "epsplume")  )
		return true;
	return false;
}

void EpsPlumeAttributes::set(const XmlNode& node)
{
	if ( this->accept(node.name()) == false ) 
		return;

	if ( magCompare(node.name(), "epsplume") )
		set(node.attributes());
	else {
	}
	for (XmlNode::ElementIterator elt = node.firstElement(); elt != node.lastElement(); ++elt) {
	}
}

void EpsPlumeAttributes::print(ostream& out)  const
{
	out << "EpsPlumeAttributes[";
	out << "method = " << method_;
	out << ", line_colour = " << *line_colour_;
	out << ", line_style = " << line_style_;
	out << ", line_thickness = " << line_thickness_;
	out << ", forecast_line_colour = " << *forecast_line_colour_;
	out << ", forecast_line_style = " << forecast_line_style_;
	out << ", forecast_line_thickness = " << forecast_line_thickness_;
	out << ", control_line_colour = " << *control_line_colour_;
	out << ", control_line_style = " << control_line_style_;
	out << ", control_line_thickness = " << control_line_thickness_;
	out << "]" << "\n";
}


void EpsPlumeAttributes::toxml(ostream& out)  const
{
     out <<  "\"epsplume\"";
	 out << ", \"eps_plume_method\":";
	 niceprint(out,method_);
	 out << ", \"eps_plume_line_colour\":";
	 niceprint(out, *line_colour_);
	 out << ", \"eps_plume_line_style\":";
	 niceprint(out,line_style_);
	 out << ", \"eps_plume_line_thickness\":";
	 niceprint(out,line_thickness_);
	 out << ", \"eps_plume_forecast_line_colour\":";
	 niceprint(out, *forecast_line_colour_);
	 out << ", \"eps_plume_forecast_line_style\":";
	 niceprint(out,forecast_line_style_);
	 out << ", \"eps_plume_forecast_line_thickness\":";
	 niceprint(out,forecast_line_thickness_);
	 out << ", \"eps_plume_control_line_colour\":";
	 niceprint(out, *control_line_colour_);
	 out << ", \"eps_plume_control_line_style\":";
	 niceprint(out,control_line_style_);
	 out << ", \"eps_plume_control_line_thickness\":";
	 niceprint(out,control_line_thickness_);
}
static MagicsParameter<string> eps_plume_method("eps_plume_method", "time_serie", "");
static MagicsParameter<string> eps_plume_line_colour("eps_plume_line_colour", "magenta", "");
static MagicsParameter<string> eps_plume_line_style("eps_plume_line_style", "solid", "");
static MagicsParameter<int> eps_plume_line_thickness("eps_plume_line_thickness", 1, "");
static MagicsParameter<string> eps_plume_forecast_line_colour("eps_plume_forecast_line_colour", "cyan", "");
static MagicsParameter<string> eps_plume_forecast_line_style("eps_plume_forecast_line_style", "dash", "");
static MagicsParameter<int> eps_plume_forecast_line_thickness("eps_plume_forecast_line_thickness", 5, "");
static MagicsParameter<string> eps_plume_control_line_colour("eps_plume_control_line_colour", "cyan", "");
static MagicsParameter<string> eps_plume_control_line_style("eps_plume_control_line_style", "solid", "");
static MagicsParameter<int> eps_plume_control_line_thickness("eps_plume_control_line_thickness", 5, "");
