/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file MetgramGraphAttributes.cc
    \brief Implementation of MetgramGraph Attributes class.
    \author Meteorological Visualisation Section, ECMWF

    This file is automatically generated.
    Do Not Edit!
   
    Generated: Wed Dec  5 12:07:14 2012
*/    

#include "MetgramGraphAttributes.h"
#include "MagicsParameter.h"
#include "Factory.h"
#include "MagTranslator.h"
#include "XmlNode.h"
#include "ParameterSettings.h"


using namespace magics;


MetgramGraphAttributes::MetgramGraphAttributes():
	style_(MagTranslator<string, MetgramStyle>().magics("metgram_plot_style"))
{
} 



MetgramGraphAttributes::~MetgramGraphAttributes()
{
}

    
void MetgramGraphAttributes::set(const std::map<string, string>& params)
{
	vector<string> prefix(1);
	prefix[0] = "metgram";

	setMember(prefix, "metgram_plot_style", style_, params);
}

void MetgramGraphAttributes::copy(const MetgramGraphAttributes& other)
{
	style_ = auto_ptr<MetgramStyle>(other.style_->clone());
} 


bool MetgramGraphAttributes::accept(const string& node)
{	
	if ( magCompare(node, "metgraph")  )
		return true;

	if ( acceptNode(node, style_) )
		return true;
	return false;
}

void MetgramGraphAttributes::set(const XmlNode& node)
{
	if ( this->accept(node.name()) == false ) 
		return;

	if ( magCompare(node.name(), "metgraph") )
		set(node.attributes());
	else {
		setMember(node.name(), style_, node);
	}
	for (XmlNode::ElementIterator elt = node.firstElement(); elt != node.lastElement(); ++elt) {
		setMember((*elt)->name(), style_, *(*elt)); 
	}
}

void MetgramGraphAttributes::print(ostream& out)  const
{
	out << "MetgramGraphAttributes[";
	out << "style = " << *style_;
	out << "]" << "\n";
}


void MetgramGraphAttributes::toxml(ostream& out)  const
{
     out <<  "\"metgraph\"";
	 out << ", \"metgram_plot_style\":";
	 style_->toxml(out);
}
static MagicsParameter<string> metgram_plot_style("metgram_plot_style", "curve", "");
#include "MetgramStyle.h"
static SimpleObjectMaker<MetgramBar, MetgramStyle> bar_MetgramBar("bar");
static SimpleObjectMaker<MetgramFlags, MetgramStyle> flags_MetgramFlags("flags");
static SimpleObjectMaker<MetgramCurve, MetgramStyle> curve_MetgramCurve("curve");
