/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file SymbolIndividualModeAttributes.h
    \brief Definition of SymbolIndividualMode Attributes class.
    \author Meteorological Visualisation Section, ECMWF

    This file is automatically generated.
    Do Not Edit!

    Generated: Wed Dec  5 12:07:14 2012
*/
   

#ifndef SymbolIndividualModeAttributes_H
#define SymbolIndividualModeAttributes_H

#include "magics.h"
#include "ParameterManager.h"
#include "Factory.h"


#include "Colour.h"

namespace magics {

class XmlNode;



class SymbolIndividualModeAttributes 
{
public:
//  --  constructor
    SymbolIndividualModeAttributes();
    
//  --  destructor
    virtual ~SymbolIndividualModeAttributes();
    
    virtual void set(const std::map<string, string>&);
    virtual void set(const XmlNode&);
    virtual void copy(const SymbolIndividualModeAttributes&);
    virtual bool accept(const string&);

    void setTag(const string& tag) { tag_ = tag; }

	

public:
	//  --  method
	virtual void print(ostream&) const;
	virtual void toxml(ostream& out) const;
	//  --  members:
	string tag_;
	string legend_text_;
	string marker_mode_;
	int marker_;
	string symbol_;
	auto_ptr<Colour> colour_;
	double height_;
	string image_path_;
	string image_format_;
	double image_width_;
	double image_height_;
	stringarray text_;
	string text_position_;
	string text_font_name_;
	double text_font_size_;
	string text_font_style_;
	auto_ptr<Colour> text_font_colour_;
	bool text_blanking_;

private:
  
	friend ostream& operator<<(ostream& s,const SymbolIndividualModeAttributes& p)
	{ p.print(s); return s; }
};

} // namespace magics

#endif
