
/******************************  LICENSE  *******************************

 * (C) Copyright 1996-2017 ECMWF.
 * 
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
 * In applying this licence, ECMWF does not waive the privileges and immunities 
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \\file CartesianTransformationAttributes.h
    \\brief Definition of CartesianTransformation Attributes class.

    This file is automatically generated.
    Do Not Edit!

    Generated: 2018-06-14
*/

#include "MagRequest.h" 
#include "CartesianTransformationWrapper.h"
#include "MagicsParameter.h"
#include "Factory.h"
#include "MagTranslator.h"

using namespace magics;


CartesianTransformationWrapper::CartesianTransformationWrapper(): cartesiantransformation_(new CartesianTransformation())

{

	
	TransformationWrapper::object(cartesiantransformation_);
	
	
} 
CartesianTransformationWrapper::CartesianTransformationWrapper(CartesianTransformation* cartesiantransformation): cartesiantransformation_(cartesiantransformation)
{
	
	TransformationWrapper::object(cartesiantransformation_);
	
} 

CartesianTransformationWrapper::~CartesianTransformationWrapper()
{
	
}

void CartesianTransformationWrapper::set(const MagRequest& request)
{
	
	
	
	TransformationWrapper::set(request);
	

	
	
		string x_value = request.countValues("B'X_AXIS_TYPE'") ?  (string) request("B'X_AXIS_TYPE'") : "regular";
	MagLog::debug() << " B'X_AXIS_TYPE' set to " << x_value << endl;
	XCoordinateWrapper* x_wrapper = 0;
#ifdef MAGICS_EXCEPTION
	try
#endif
	{
		x_wrapper = SimpleFactory<XCoordinateWrapper>::create(x_value);
	}
#ifdef MAGICS_EXCEPTION
	 catch (NoFactoryException) {
#else
	 if (!x_wrapper) {
#endif
		MagLog::warning() << "[" << x_value << "] is not a valid value for MAP_BOUNDARIES: reset to default -> [regular]" << endl;
		x_wrapper = SimpleFactory<XCoordinateWrapper>::create("off");
	}
	x_wrapper->set(request);
	cartesiantransformation_->x_ =  unique_ptr<XCoordinate>(x_wrapper->object());
	delete x_wrapper;
	
		string y_value = request.countValues("B'Y_AXIS_TYPE'") ?  (string) request("B'Y_AXIS_TYPE'") : "regular";
	MagLog::debug() << " B'Y_AXIS_TYPE' set to " << y_value << endl;
	YCoordinateWrapper* y_wrapper = 0;
#ifdef MAGICS_EXCEPTION
	try
#endif
	{
		y_wrapper = SimpleFactory<YCoordinateWrapper>::create(y_value);
	}
#ifdef MAGICS_EXCEPTION
	 catch (NoFactoryException) {
#else
	 if (!y_wrapper) {
#endif
		MagLog::warning() << "[" << y_value << "] is not a valid value for MAP_BOUNDARIES: reset to default -> [regular]" << endl;
		y_wrapper = SimpleFactory<YCoordinateWrapper>::create("off");
	}
	y_wrapper->set(request);
	cartesiantransformation_->y_ =  unique_ptr<YCoordinate>(y_wrapper->object());
	delete y_wrapper;
	
}

void CartesianTransformationWrapper::print(ostream& out)  const
{
	out << "CartesianTransformationWrapper[]";
}


    



#include "XRegularCoordinateWrapper.h"
static SimpleObjectMaker<XRegularCoordinate, XCoordinate> CartesianTransformation_b'x_axis_type'_x_regular ("x_regular");
static SimpleObjectMaker<XRegularCoordinateWrapper, XCoordinateWrapper> CartesianTransformation_b'x_axis_type'_x_regular_wrapper ("x_regular");


#include "XRegularCoordinateWrapper.h"
static SimpleObjectMaker<XRegularCoordinate, XCoordinate> CartesianTransformation_b'x_axis_type'_regular ("regular");
static SimpleObjectMaker<XRegularCoordinateWrapper, XCoordinateWrapper> CartesianTransformation_b'x_axis_type'_regular_wrapper ("regular");


#include "XDateCoordinateWrapper.h"
static SimpleObjectMaker<XDateCoordinate, XCoordinate> CartesianTransformation_b'x_axis_type'_x_date ("x_date");
static SimpleObjectMaker<XDateCoordinateWrapper, XCoordinateWrapper> CartesianTransformation_b'x_axis_type'_x_date_wrapper ("x_date");


#include "XDateCoordinateWrapper.h"
static SimpleObjectMaker<XDateCoordinate, XCoordinate> CartesianTransformation_b'x_axis_type'_date ("date");
static SimpleObjectMaker<XDateCoordinateWrapper, XCoordinateWrapper> CartesianTransformation_b'x_axis_type'_date_wrapper ("date");


#include "XHyperCoordinateWrapper.h"
static SimpleObjectMaker<XHyperCoordinate, XCoordinate> CartesianTransformation_b'x_axis_type'_x_hyper ("x_hyper");
static SimpleObjectMaker<XHyperCoordinateWrapper, XCoordinateWrapper> CartesianTransformation_b'x_axis_type'_x_hyper_wrapper ("x_hyper");


#include "XHyperCoordinateWrapper.h"
static SimpleObjectMaker<XHyperCoordinate, XCoordinate> CartesianTransformation_b'x_axis_type'_geoline ("geoline");
static SimpleObjectMaker<XHyperCoordinateWrapper, XCoordinateWrapper> CartesianTransformation_b'x_axis_type'_geoline_wrapper ("geoline");


#include "XLogarithmicCoordinateWrapper.h"
static SimpleObjectMaker<XLogarithmicCoordinate, XCoordinate> CartesianTransformation_b'x_axis_type'_x_logarithmic ("x_logarithmic");
static SimpleObjectMaker<XLogarithmicCoordinateWrapper, XCoordinateWrapper> CartesianTransformation_b'x_axis_type'_x_logarithmic_wrapper ("x_logarithmic");


#include "XLogarithmicCoordinateWrapper.h"
static SimpleObjectMaker<XLogarithmicCoordinate, XCoordinate> CartesianTransformation_b'x_axis_type'_logarithmic ("logarithmic");
static SimpleObjectMaker<XLogarithmicCoordinateWrapper, XCoordinateWrapper> CartesianTransformation_b'x_axis_type'_logarithmic_wrapper ("logarithmic");



#include "YRegularCoordinateWrapper.h"
static SimpleObjectMaker<YRegularCoordinate, YCoordinate> CartesianTransformation_b'y_axis_type'_y_regular ("y_regular");
static SimpleObjectMaker<YRegularCoordinateWrapper, YCoordinateWrapper> CartesianTransformation_b'y_axis_type'_y_regular_wrapper ("y_regular");


#include "YRegularCoordinateWrapper.h"
static SimpleObjectMaker<YRegularCoordinate, YCoordinate> CartesianTransformation_b'y_axis_type'_regular ("regular");
static SimpleObjectMaker<YRegularCoordinateWrapper, YCoordinateWrapper> CartesianTransformation_b'y_axis_type'_regular_wrapper ("regular");


#include "YDateCoordinateWrapper.h"
static SimpleObjectMaker<YDateCoordinate, YCoordinate> CartesianTransformation_b'y_axis_type'_y_date ("y_date");
static SimpleObjectMaker<YDateCoordinateWrapper, YCoordinateWrapper> CartesianTransformation_b'y_axis_type'_y_date_wrapper ("y_date");


#include "YDateCoordinateWrapper.h"
static SimpleObjectMaker<YDateCoordinate, YCoordinate> CartesianTransformation_b'y_axis_type'_date ("date");
static SimpleObjectMaker<YDateCoordinateWrapper, YCoordinateWrapper> CartesianTransformation_b'y_axis_type'_date_wrapper ("date");


#include "YHyperCoordinateWrapper.h"
static SimpleObjectMaker<YHyperCoordinate, YCoordinate> CartesianTransformation_b'y_axis_type'_y_hyper ("y_hyper");
static SimpleObjectMaker<YHyperCoordinateWrapper, YCoordinateWrapper> CartesianTransformation_b'y_axis_type'_y_hyper_wrapper ("y_hyper");


#include "YHyperCoordinateWrapper.h"
static SimpleObjectMaker<YHyperCoordinate, YCoordinate> CartesianTransformation_b'y_axis_type'_geoline ("geoline");
static SimpleObjectMaker<YHyperCoordinateWrapper, YCoordinateWrapper> CartesianTransformation_b'y_axis_type'_geoline_wrapper ("geoline");


#include "YLogarithmicCoordinateWrapper.h"
static SimpleObjectMaker<YLogarithmicCoordinate, YCoordinate> CartesianTransformation_b'y_axis_type'_y_logarithmic ("y_logarithmic");
static SimpleObjectMaker<YLogarithmicCoordinateWrapper, YCoordinateWrapper> CartesianTransformation_b'y_axis_type'_y_logarithmic_wrapper ("y_logarithmic");


#include "YLogarithmicCoordinateWrapper.h"
static SimpleObjectMaker<YLogarithmicCoordinate, YCoordinate> CartesianTransformation_b'y_axis_type'_logarithmic ("logarithmic");
static SimpleObjectMaker<YLogarithmicCoordinateWrapper, YCoordinateWrapper> CartesianTransformation_b'y_axis_type'_logarithmic_wrapper ("logarithmic");



