
%module Magnus

%{
#include "QEqnSolutions.h"
%}

class QEqnSolutionsInFreeGroup
{
public:

  /////////////////////////////////////////////////////////////////////////
  //                                                                     //
  // Constructors:                                                       //
  //                                                                     //
  /////////////////////////////////////////////////////////////////////////

  // no default constructor

  QEqnSolutionsInFreeGroup(const FreeGroup& G, const Word& equation, int numOfVar);
  // Construct quadratic equation with given word in given group G
  // which is a formal group generated by variables and constants:
  // the first numOfVar generators are treated as variables,
  // other generators of the group are constants.

  // copy constructor, operator=, and destructor supplied by compiler

  /////////////////////////////////////////////////////////////////////////
  //                                                                     //
  // Activation members for solving the equation:                        //
  //                                                                     //
  /////////////////////////////////////////////////////////////////////////

  void startComputation();
  void continueComputation();
  // These two methods launch and perform process of solving the equation.
  // After performing one step, some new basic solutions and generators
  // of RegStab are found, and user can require them. 
  // Simultaneously the rank of equation is computed,
  // but it is available only after the computation is completed.

  void disableBuildingRegStab();
  void enableBuildingRegStab();
  // Building of regular stabilizer is enabled by default. User can
  // disable this, accelerating performance and saving memory. After disabling,
  // all the following steps do not return corresponding generators and
  // all related information is lost. So when user disables the RegStab
  // building and then enables it again, one loses some generators.

  void disableBuildingSolutions();
  void enableBuildingSolutions();
  // The same about building partial solutions.

  /////////////////////////////////////////////////////////////////////////
  //                                                                     //
  // Status queries:                                                     //
  //                                                                     //
  /////////////////////////////////////////////////////////////////////////

  bool isComputationDone() const;
  // Returns true iff computation is finished.

  bool isComputationStarted() const;
  // Returns true iff `startComputation' have been invoked.

  bool haveNewSolution() const ;
  // Returns true iff at least one new basic solution is available.

  bool nextSolution() ;
  // Advances pointer to next basic solution, so that getSolution returns it.
  // Returns false iff there is no new solution.

  bool haveNewStabGenerator() const ;
  // Returns true iff at least one new generator of RegStab is available.

  bool nextStabGenerator() ;
  // Advances pointer to next generator, so that getStabGenerator returns it.
  // Returns false iff there is no new generator.
	
  bool isBuildingSolutionsEnabled() const;

  bool isBuildingRegStabEnabled() const ;

  //////////////////////////////////////////////////////////////////////
  //                                                                  //
  // Accessors                                                        //
  //                                                                  //
  //////////////////////////////////////////////////////////////////////

  Endomorphism getSolution();
  // Returns found basic solution.
  // @dp This should be const, but Map::operator| is not const.

  Automorphism getStabGenerator() ;
  // Returns found generator of RegStab.
  // @dp This should be const, but Map::operator| is not const.

  Word surfaceForm();
  // Returns a surface form of the equation.
  // @dp logically must be const.

  Automorphism toSurfaceForm();
  // Returns an (regular) automorphism bringing the equation into a surface
  // form.
  // @dp logically must be const.

  FreeGroup group() const;
  Word equation() const ;
  int numberOfVariables() const;
  int numberOfGenerators() const ;
  int numberOfConstants() const ;

  int rank() const;
  // returns -1 if rank is not computed yet, otherwise non-negative number 
  // which is the computed rank of the equation.

  VectorPtrOf<Endomorphism> basicSolutions() const;
  // Returns all known basic solutions of the equation.
  // NB. This function returns `stripped' basic solutions. To get `true'
  // solutions the user must append (left) the prefixMap() automorphism.

  VectorPtrOf<Automorphism> regStabGenerators() const;
  // Returns all known generators of regular stabilizer of the equation.
  // NB. This function returns `stripped' generators. To get proper
  // generators the user must conjugate each of them by the prefixMap() 
  // automorphism.

  Automorphism prefixMap() const;
  // Returns automorphsim bringing the equation into a minimal form.
  // The minimal form is not necessary to be identical to the surface 
  // (canonic) form.

  struct EquationStatus; // forward declaration.

  EquationStatus getProcessStatus() const;
  // Returns full status of the computation process.


  Endomorphism eliminator() const;

  /////////////////////////////////////////////////////////////////////////
  //                                                                     //
  // I/O:                                                                //
  //                                                                     //
  /////////////////////////////////////////////////////////////////////////

//  friend ostream& operator << ( ostream&, const QEqnSolutionsInFreeGroup& );
  // Outputs all known basic solutions in a form readable by the end user.

  /////////////////////////////////////////////////////////////////////////
  //                                                                     //
  // Type definitions:                                                   //
  //                                                                     //
  /////////////////////////////////////////////////////////////////////////

  // Process status structure.

  struct EquationStatus
  {
    public:
    EquationStatus();

    // copy contsructor, operator=, destructor supplied by compiler.

    // data members:

    bool enableBuildingSolutions;
    bool enableBuildingRegStab;
    int verticesToPass;
    int verticesPassed;
    int loopsToPass;
    int loopsPassed;
    long totalLengthOfLoops;
  };

/*

private:

  class Edge; // forward declaration

  Bool isVariable(const Generator& g) const { 
#if SAFETY > 0
    if( abs(ord(g)) > theNumberOfGenerators )
      error("Generator out of bounds in QEqnSolution::isVariable(Generator&)");
#endif
    return ( abs(ord(g)) <= theNumberOfVariables ? true : false );
  }
  // Returns true iff the given generator is a variable.

  bool isConstant(const Generator& g) const {
#if SAFETY > 0
    if( abs(ord(g)) > theNumberOfGenerators )
      error("Generator out of bounds in QEqnSolution::isConstant(Generator&)");
#endif
    return ( abs(ord(g)) > theNumberOfVariables ? true : false );
  }
  // Returns true iff the given generator is a constant.


  // METHODS OF TREE BUILDER

  void buildNewVerticesAndLoopsFrom(const Word& vertex);
  // Expands tree: builds all `offsprings' the given vertex.

  RegularAuto buildPath(const Word& from, const Word& to);
  // Builds a path from one vertex to another within the built subtree.

  RegularAuto buildPathTo(const Word& to);
  // Builds path from theEquation to the given word.

  void registerEdge(const Word& source, const ElementaryRegularAuto& edge, 
		    const Word& target);
  // Tries to include the given edge to the maximal tree. If the edge
  // forms a loop it certainly should not include; instead, it places the one
  // to the list of loops.


  // METHODS OF BASIC SOLUTIONS BUILDER

  void buildSolutionsOfOneVertex(const Word& w);
  // Builds basic solutions for the given word.

  VectorOf<int> checkProperties(const Word& w);
  // Checks for every variable of the group whether it can/must/cannot
  // be eliminated in given word

  ListOf<SingularEndo> buildSingulars(const Word& w, const VectorOf<int>& varProperties);
  // This procedure immediately builds a graph of eliminations for given word.
  // varProperties defines a behavior of every variables of the word.

  void appendNewSolution(ListOf<SingularEndo>& solutions, 
			 const SingularEndo& newSolution);
  // Includes a new singular solution to the list of solutions, unless it is a
  // specialization of one of the list.


  // METHODS OF RANK EQUATION BUILDER

  int rankOfBasicSolution(const Endomorphism& solution) const;
  // Computes rank of the given endomorphism.

  // METHODS OF REGSTAB BUILDER

  void processOneLoop(const Edge& edge);
  // Builds a generator of stabilizer by the given edge of graph.

  // METHODS OF SURFACE FORM BUILDER
  //@dp these descriptions is not quite fine, more detailed comments
  //    to appear.

//  void computeSurfaceForm();
  // Computes surface form of the equation and an automorphism bringing
  // the one to the surface form.

  Word extractSquare(Word& w, int firstLocation, int secondLocation);
  // Rewrites given word by extracting square of variable at given locations.

  Word extractPinch(Word& w, int firstLocation,	int secondLocation);
  // Rewrites given word by extracting pinch of variable at given locations.

  Word extractCommutator(Word& w, int xFirstLocation,	int xSecondLocation, 
			 int yFirstLocation);
  // Rewrites given word by extracting commutator of variables at given 
  // locations.

  int getLocationOfArbitraryVariable(const Word& w, int start, int stop) const;
  // Returns location of an arbitrary variable which occurrs in the given 
  // non-empty word, otherwise returns -1.

  int getPairOfVariable(Word& w, int& firstLocation, int& secondLocation, 
			bool oppositeOrder) const;

  Word bringToCanonicForm(Word& squares, Word& commutators, Word constants, 
			  Word& pinches);
  // Last stage of computing a surface form and a surface automorphism.

  /////////////////////////////////////////////////////////////////////////
  //                                                                     //
  // Data Members:                                                       //
  //                                                                     //
  /////////////////////////////////////////////////////////////////////////

  Word theEquation;           // the given equation
  int theNumberOfGenerators;
  int theNumberOfVariables;
  FreeGroup theGroup; 

  VectorPtrOf<Automorphism> theRegStabGenerators;
  VectorPtrOf<Endomorphism> theBasicSolutions;

  int theRank; // rank of given equation
  Word theSurfaceForm; // surface form of the equation
  Automorphism toSurface; // auto bringing into surface form

  // Control variables of the process

  bool computationIsStarted;
  bool computationIsDone;

  int solution; // number of last retrieved basic solution by the user
  int generator; // number of last retieved generator of RegStab by the user


  Endomorphism theEliminator;
  // This endomorphism eliminates variables mapping them to 1. Constants are mapped
  // to themselves.


  // TREE BUILDER PROPERTIES

  // The maximal subtree is represented with pairs (associations) of
  // a word (some image of the root) and an edge -- an elementary
  // regular transformation mapping the word to its PARENT. So,
  // edges in the tree are directed from offsprings to parents,
  // and we can easily reconstruct a regular automorphism mapping
  // the root to the vertex.
  // The tree is stored as associative array because we need fast search 
  // of vertices.

  struct Edge {

    // edge of a graph of regular transforms of the equation; includes
    // source vertex

    Word vertex;
    ElementaryRegularAuto edge;

    Edge() : edge(1,2) {} // `dummy' default constructor for use in Sets

    Edge(const Word& w, const ElementaryRegularAuto& e) : vertex(w), edge(e) 
    {}

    friend inline bool operator ==(const Edge& x, const Edge& y) {
      return ( x.vertex == y.vertex && x.edge == y.edge );
    }

    friend ostream& operator <<( ostream& o, const Edge& E);
    // This operator is required by SetOf<Edge> class.
    // We don't need it, so prohibit the one.

    int hash() const { return vertex.hash(); }
  };

  Automorphism startPath; // an automorhism mapping the initial word into its
  // minimal form (root)
  Automorphism invStartPath;
  Word root;             // current root of the tree
  QuickAssociationsOf<Word, ElementaryRegularAuto> maxSubTree;
  // maximal subtree of the graph of regular transforms of
  // theEquation's minimal form (root).

  QueueOf<Word> newVertices; // new transforms to be proceeded

  QueueOf<Edge> loops; //edges not included into the subtree which define loops


  // BASIC SOLUTION BUILDER PROPERTIES

  Endomorphism removeVarEndo;
  // Endomorphism which removes all variables from a word and leaves
  // constants only.
  SetOf<Endomorphism> setOfBasicSolutions; 
  // Temporary fast access storage of basic solutions to prevent duplicate 
  // ones. 

  enum { MUST_BE_MAPPED_TO_ITSELF,
	 MUST_BE_MAPPED_TO_1,
	 CAN_BE_MAPPED_TO_1
  };
  // Behavior of variables of a vertex of the tree when a specialization 
  // is searched.


  // RANK BUILDER PROPERTIES

  int tempRank;
  // Make intermediate computed value of rank unavailable for the user
  // while computation is incomplete.

  // REGSTAB BUILDER PROPERTIES

  SetOf<Automorphism> regStabSet;
  // Generators of RegStab which are already found to prevent duplicate them. 

  // SURFACE FORM BUILDER

  bool surfaceFormIsComputed;

  // CLASS INFORMATION

  EquationStatus status;

#ifdef DEBUG
  void debugPrint( ostream& o ) const;
  //friend int main();
#endif
*/
//  friend ostream& operator << ( ostream&, const QEqnSolutionsInFreeGroup& );
   %addmethods{
	char* __str__() {
		strstream s;
		s << (*self) << '\0' << flush;
		return s.str();
	}

  }

};

/*
// This is a procedure converting Set into Vector. It's a double of
// a makeVectorOf(const ListOf<T>&) from conversions.h and also
// should be placed there.

template <class T> VectorPtrOf<T> makeVectorPtrOf(const SetOf<T>& S)
{
  VectorPtrOf<T> result( S.cardinality() );

  int i = 0;
  SetIterator<T> I(S);

  while ( !I.done() ) {
    result[i++] = I.value();
    I.next();
  }

  return result;
}

*/
///////////////@ep added on October1996 /////////////////////////////////////////////

Chars  checkEquation(const FreeGroup& G, const Word& equation, int numOfVar);



