from mago.test_suite.evolution import EvolutionTestSuite
from mago.application.evolution import Evolution, AccountInfo
from mago.check import ScreenshotCompare, FAIL
from mago.application.deskex import IndicatorApplet 

from ConfigParser import ConfigParser
import ldtp, ooldtp, ldtputils
from time import sleep, time
from shutil import copytree, move
from os.path import expanduser

class EvolutionUseApp(Evolution):
    def open(self, profile_template='', credentials='',
             me_account=''):
        self.me_account = AccountInfo(me_account, credentials)

        self.backup_config()
        self.generate_profile(profile_template, self.me_account.template_args)

        Evolution.open(self, False, credentials)

class EvolutionIndicatorTest(EvolutionTestSuite):
    APPLICATION_FACTORY = EvolutionUseApp
    def cleanup(self):
        return

    def testIndicatorShowsUp(self):
        indicator = IndicatorApplet()
        if not indicator.is_server_shown("Evolution Mail"):
            raise AssertionError("The indicator didn't show up", ldtputils.imagecapture())

    def testIndicateMyself(self, subject, body, password=''):

        indicator = IndicatorApplet()
        no_message = indicator.capture_applet_icon()
        email = self.application.me_account.template_args['emailaddress']
        password = self.application.me_account.template_args['password']

        self.application.compose_new_message(email, subject, body)
        self.application.send_email(subject)

        # Force sending the email
        ldtp.wait(5)

        # Get new messages
        self.application.send_and_receive(password, True, True)

        # Check that the applet icon changed
        with_message = indicator.capture_applet_icon()

        checker = ScreenshotCompare(no_message, with_message)
        
        if checker.perform_test() != FAIL:
            raise AssertionError('icon did not change.', ldtputils.imagecapture())




  
