from mago.test_suite.evolution import EvolutionTestSuite
from mago.application.evolution import Evolution, AccountInfo
from mago.check import ScreenshotCompare, FAIL
from mago.application.deskex import NotifyOSD

from ConfigParser import ConfigParser
import ldtp, ooldtp, ldtputils
from time import sleep, time
from shutil import copytree, move
from os.path import expanduser

class EvolutionUseApp(Evolution):
    def open(self, profile_template='', credentials='',
             me_account=''):
        self.me_account = AccountInfo(me_account, credentials)

        self.backup_config()
        self.generate_profile(profile_template, self.me_account.template_args)

        Evolution.open(self, False, credentials)

class EvolutionNotifyTest(EvolutionTestSuite):
    APPLICATION_FACTORY = EvolutionUseApp
    def cleanup(self):
        return

    def testNotifyMyself(self, subject, body, oracle, password=''):

        notify = NotifyOSD()
        email = self.application.me_account.template_args['emailaddress']
        password = self.application.me_account.template_args['password']

        self.application.compose_new_message(email, subject, body)
        self.application.send_email(subject)

        # Force sending the email
        ldtp.wait(5)

        # Get new messages
        self.application.send_and_receive(password, True, True)

        # Wait for notification (TODO)
        elapsed, screeny = notify.grab_image_and_wait("1 New Message", 40)

        checker = ScreenshotCompare(oracle, screeny)

        try:
            passed = checker.perform_test()
        except Exception, e:
            checker.calibrate()
            raise e

        if passed == FAIL:
            raise AssertionError('screenshots differ', screeny)

       
        # Get the list of messages and check if it was correctly received
        messages_list = self.application.get_list_messages()

        found = False
        for msg in messages_list:
            if str(msg['subject']) == str(subject):
                found = True
                break

        if not found:
            raise AssertionError("The message was not correctly received.", 
                    ldtputils.imagecapture())





  
