from main import Application
from ..utils import show_desktop 
import ldtp, ldtputils, ooldtp
import os
import gtk, glib
import tarfile
from shutil import move, rmtree, copytree, copy
from ConfigParser import ConfigParser
from string import Formatter

class AccountInfo(object):

    def __init__(self, name, credentials):
        if not isinstance(credentials, ConfigParser):
            creds_fn = credentials
            credentials = ConfigParser()
            credentials.read(creds_fn)
        self.details = dict(credentials.items(name))
        self.name = name

    def __getattr__(self, name):
        try:
            return self.details[name]
        except KeyError:
            raise AttributeError

    @property
    def template_args(self):
        args = {}
        for arg in ('popaccount', 'popserver', 'smtpaccount', 'smtpserver', 
                    'emailaddress', 'accountname', 'realname', 'protocol', 'password'):
            args[arg] = getattr(self, arg)
        return args

class Evolution(Application):
    """
    Evolution application helper class.
    """
    WINDOW         = "*-Evolution"
    LAUNCHER       = "evolution"
    BTN_OK         = "OK"

    # Main window elements
    BTN_SENDRECEIVE = "btnSend/Receive"
    DLG_SENDRECEIVE = "dlgSend&ReceiveMail"
    DLG_ENTER_PASSWORD = "dlgEnterPasswordfor*" 
    TBL_MSG_FOLDERS = 'ttblMailFolderTree'

    # Compose message constants
    MNU_COMPOSENEW = "mnuComposeNewMessage"
    FRM_COMPOSE    = "frmComposeMessage"
    TXT_TO         = "txtTo"
    TXT_SUBJECT    = "txtSubject"
    TXT_BODY       = "txt6"
    BTN_SEND       = "btnSend"

    # Messages treetable
    MESSAGES       = "ttblMessages"
    STATUS_LBL     = "Status"
    STATUS_INDEX   = 0
    ATTACH_LBL     = "Attachment"
    ATTACH_INDEX   = 1
    FLAGGED_LBL    = "Flagged"
    FLAGGED_INDEX  = 2
    FROM_LBL       = "From"
    FROM_INDEX     = 3
    SUBJECT_LBL    = "Subject"
    SUBJECT_INDEX  = 4
    DATE_LBL       = "Date"
    DATE_INDEX     = 5

    def __init__(self):
        Application.__init__(self)

    def open(self, clean_profile=True, credentials=''):
        """
        It saves the old profile (if needed) and
        set up a new one. After this initial process,
        it opens the application

        @type clean_profile: boolean
        @param clean_profile: True, to back up the old profile and create a 
            new one (default)
        @type credentials: string
        @param credentials: Path to the config file with accounts information
        """
        clean_profile = clean_profile not in ('False', '0', False)
        self.creds_fn = credentials
        self.credentials = ConfigParser()
        self.credentials.read(self.creds_fn)

        if clean_profile:
            self.backup_config()

        Application.open(self)

    def generate_profile(self, profile_template, template_args=None):
        """
        It uses the profile_template and the
        credentials to build a new profile folder
        """
        
        conf_folder = '~/.gconf/apps/evolution'
        template_file = 'mail/%gconf.xml'

        formatter = Formatter()
        copytree(profile_template, os.path.expanduser(conf_folder))

        buf = open(os.path.join(os.path.join(profile_template, template_file))).read()
        f = open(os.path.join(os.path.expanduser(conf_folder), template_file), 'w')
        try:
            buf = formatter.format(buf, **template_args)
        except KeyError, e:
            raise Exception, e
        f.write(buf)
        f.close()

    def compose_new_message(self, to, subject='', body='', account=''):
       
        evolution = ooldtp.context(self.WINDOW)
        mnuComposeNew = evolution.getchild(self.MNU_COMPOSENEW)
        mnuComposeNew.click()
        ldtp.waittillguiexist(self.FRM_COMPOSE)
        compose_window = ooldtp.context(self.FRM_COMPOSE)
        txtTo = compose_window.getchild(self.TXT_TO)
        txtTo.settextvalue(to)
        txtSubject = compose_window.getchild(self.TXT_SUBJECT)
        txtSubject.settextvalue(subject)
       
        # Remap is needed because the frame changes its name
        self.remap() 
        
        compose_window = ooldtp.context(subject)

        txtBody = compose_window.getchild(self.TXT_BODY)
        txtBody.settextvalue(body)
   
    def send_email(self, subject):

        compose_window = ooldtp.context(subject)
        btnSend = compose_window.getchild(self.BTN_SEND)
        btnSend.click()

    def send_and_receive(self, password='', minimize=False, dont_wait=False):
        evolution = ooldtp.context(self.WINDOW)
        btnsr = evolution.getchild(self.BTN_SENDRECEIVE)
        btnsr.click()
        ldtp.waittillguiexist(self.DLG_SENDRECEIVE)

        if minimize:
            show_desktop(True)

        if ldtp.waittillguiexist(self.DLG_ENTER_PASSWORD, guiTimeOut=2) == 1:
            enter_pass_dlg = ooldtp.context(self.DLG_ENTER_PASSWORD)
            txt_pass = enter_pass_dlg.getchild(role='password_text')[0]
            txt_pass.settextvalue(password)
            btn_ok = enter_pass_dlg.getchild(self.BTN_OK)
            btn_ok.click()
            if minimize:
                show_desktop(True)

        if dont_wait:
            return

        ldtp.waittillguinotexist(self.DLG_SENDRECEIVE)

     
    def get_list_messages(self, only_unread=False, folder="Inbox"):

        messages_list = []
        
        self.select_folder(folder)

        evolution = ooldtp.context(self.WINDOW)
        messages = evolution.getchild(self.MESSAGES)

        for i in range(messages.getrowcount()):
            status  = messages.getcellvalue(i, self.STATUS_INDEX)
            sender  = messages.getcellvalue(i, self.FROM_INDEX)
            subject = messages.getcellvalue(i, self.SUBJECT_INDEX)

            if not only_unread or status == '0':
                messages_list.append({'subject':subject,'sender':sender,'status':status})

        return messages_list

    def select_folder(self, folder):
        evolution = ooldtp.context(self.WINDOW)
        table_msg = evolution.getchild(self.TBL_MSG_FOLDERS)
        table_msg.selectrowpartialmatch(folder)

    def backup_config(self):
        """
        It saves the configuration of Evolution in a file
        called ~/.evo.bak.tar.gz{.n}

        It saves the evolution config & messages
        """
        p = os.path.expanduser('~/.evo.bak.tar.gz')
        backup_path = p
        i = 2
        while os.path.exists(backup_path):
            backup_path = '%s.%d' % (p, i)
            i += 1
            
        try:
            tar = tarfile.open(backup_path, mode='w:gz')
            evolution_conf = os.path.expanduser('~/.evolution')
            evolution_gconf = os.path.expanduser('~/.gconf/apps/evolution')

            if os.path.exists(evolution_conf):
                tar.add(evolution_conf)
                rmtree(evolution_conf)
            if os.path.exists(evolution_gconf):
                tar.add(evolution_gconf)
                rmtree(evolution_gconf)
            tar.close()
        except IOError:
            pass
        else:
            self.backup_path = backup_path

        # Shutdown processes related to the evolution configuration
        os.popen("evolution --force-shutdown")
        os.popen("gconftool-2 --shutdown")
        
    def restore_config(self):
        """
        It deletes the configuration folder and restore then
        one backed up (at backup_path)
        """
        try:
            rmtree(os.path.expanduser('~/.evolution'))
            rmtree(os.path.expanduser('~/.gconf/apps/evolution'))
        except OSError:
            pass

        try:
            tar = tarfile.open(self.backup_path, mode='r:gz')
            tar.extractall(os.path.expanduser('/.'))
        except IOError:
            traceback.print_exc()


    
if __name__ == "__main__":
    from time import sleep
    test = Evolution()
    #test.open()
    #subject = "Greetings"
    #test.compose_new_message("tester.ubuntu@gmail.com", subject, "hey hey")
    #test.send_email(subject)
    #test.send_and_receive('testingubuntu')
    test.backup_config()
    test.restore_config()
   # test.close()
