# Copyright (C) 2010 Canonical Ltd
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA

"""Minimal Test

This is a basic test to verify that mago-ng is working as expected and can
be run with various testing framework

To run it with:
$ mago-ng <path_to_this_file>

You can code ldtp directly in there or an external module
The only mandatory element is 'launcher' (and window_name for now)

set setupOnce to False to launch/close the app for each test

The purpose of this example is to demo the smallest mago script that can be
written.
"""

from mago import TestCase
import unittest

class TestMinimal(TestCase):
    """The minimal test that can be written with mago
    """
    launcher = 'sol'
    #: This is optional. If it is not defined, mago tries to guess it by querying Xlib
    #window_name = 'frmKlondike'

    def test_minimal(self):
        """A really simple test

        This test verifies True is True. If it fails, then reinstall your system.
        """
        self.assertTrue(True)

if __name__ == "__main__":
    unittest.main()
