#!/usr/bin/env ruby

require 'test/unit'
require 'mahoro'

class MahoroTestCase < Test::Unit::TestCase

	def initialize(*args)
		super
		@m = Mahoro.new
	end

	def test_file
		@m.flags = Mahoro::NONE
		assert_equal('ASCII C program text', @m.file('mahoro.c'))
	end

	def test_mime_file
		@m.flags = Mahoro::MIME
		assert_equal('text/x-c; charset=us-ascii', @m.file('mahoro.c'))
	end

	def test_buffer
		@m.flags = Mahoro::NONE
		assert_equal('ASCII C program text',
		             @m.buffer(File.read('mahoro.c')))
	end

	def test_mime_buffer
		@m.flags = Mahoro::MIME
		assert_equal('text/x-c; charset=us-ascii',
		             @m.buffer(File.read('mahoro.c')))
	end

	def test_valid
		assert(@m.valid?, 'Default database was not valid.')
	end

end

# arch-tag: test
