#include "mb_util.h"

#include <time.h>
#include <stdlib.h>


mb_log::mb_log(CPCCHAR logFile, CPCCHAR errFile, struct tm *loc)
 : m_log(NULL)
 , m_errlog(NULL)
 , m_loc(loc)
 , m_interactive(false)
{
  if(logFile)
    m_log = fopen(logFile, "a");
  if(errFile)
    m_errlog = fopen(errFile, "a");
  if(logFile && !m_log)
  {
    if(m_errlog)
      fprintf(m_errlog, "Can't open %s\n", logFile);
    printf("Can't open %s\n", logFile);
    exit(1);
  }
  if(errFile && !m_errlog)
  {
    if(m_log)
      fprintf(m_log, "Can't open %s\n", errFile);
    printf("Can't open %s\n", errFile);
    exit(1);
  }
}

mb_log::~mb_log()
{
  if(m_log)
    fclose(m_log);
  if(m_errlog)
    fclose(m_errlog);
}

void mb_log::error(CPCCHAR message, CPCCHAR data, CPCCHAR data2, bool serious)
{
  reallog(m_errlog, message, data, data2);
  if(serious || m_interactive)
  {
    printf(message, data, data2);
    printf("\n");
  }
}

void mb_log::info(CPCCHAR message, CPCCHAR data, CPCCHAR data2)
{
  reallog(m_log, message, data, data2);
  if(m_interactive)
  {
    printf(message, data, data2);
    printf("\n");
  }
}

void mb_log::reallog(FILE *fp, CPCCHAR message, CPCCHAR data, CPCCHAR data2)
{
  if(fp)
  {
    fprintf(fp, "%04d-%02d-%02d:%02d:%02d:%02d "
              , m_loc->tm_year + 1900, m_loc->tm_mon + 1, m_loc->tm_mday
              , m_loc->tm_hour, m_loc->tm_min, m_loc->tm_sec);
    fprintf(fp, message, data, data2);
  }
}
