/*
   Copyright (C) 2007 Omat Holding B.V. <info@omat.nl>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

#ifndef AddressLabel_H
#define AddressLabel_H

#include <QLabel>

namespace Mailody
{
/**
 * @class AddressLabel
 * This class is a simple subclass of QLabel, which only adds a signal for
 * right mouse button clicks.
 * @author Tom Albers <tomalbers@kde.nl>
 */
class AddressLabel : public QLabel
{
    Q_OBJECT

public:

    /**
     * Constructor
     */
    explicit AddressLabel( QWidget* );

    /**
     * Destructor
     */
    ~AddressLabel();

private slots:
    void slotLinkHovered( const QString& link );

protected:
    virtual void mousePressEvent( QMouseEvent* );

private:
    QString                     m_link;

signals:
    void rightMouseActivated( const QString& );
    void leftMouseActivated( const QString& );
};
}
#endif // AddressLabel_H
