/* This file is part of the KDE project
   Copyright (C) 2006 Omat Holding B.V. <info@omat.nl>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

// Own
#include "datalistview.h"

// Qt
#include <QHeaderView>
#include <QKeyEvent>
#include <QScrollBar>
#include <QTimer>

// KDE
#include <KDebug>

using namespace Mailody;

DataListView::DataListView( QWidget* parent, int data_column, int columns )
        : MailodyBaseListView( parent ), m_datacolumn( data_column ),
        m_columns( columns ),m_size( 35 )

{
    header()->setResizeMode( QHeaderView::Fixed );
    setHorizontalScrollBarPolicy( Qt::ScrollBarAlwaysOff );

    setColumnCount( m_columns );
    for ( int i = 0; i < columns; i++ )
        if ( m_datacolumn != i )
            header()->resizeSection( i, m_size );

    m_clearTimer = new QTimer( this );
    m_clearTimer->setSingleShot( true );
    connect( m_clearTimer , SIGNAL( timeout() ), SLOT( slotResizeDoIt() ) );
}

void DataListView::resizeEvent( QResizeEvent * )
{
    slotResize();
}

void DataListView::slotResize()
{
    if ( m_clearTimer )
        m_clearTimer->start( 100 );
}

void DataListView::slotResizeDoIt()
{
    int extraspace = 4;
    if ( verticalScrollBar()->isVisible() )
        extraspace = verticalScrollBar()->width()+4;

    blockSignals( true );
    for ( int i = 0; i < m_columns; i++ ) {
        if ( m_datacolumn == i )
            setColumnWidth( i,width()-(( m_columns-1 )*m_size )-extraspace );
        else
            setColumnWidth( i,m_size );
    }
    blockSignals( false );
}

void DataListView::keyPressEvent( QKeyEvent* e )
{
    if ( e->key() == Qt::Key_Delete )
        deleteItem();
    else
        QTreeWidget::keyPressEvent( e );
}

void DataListView::deleteItem()
{
    QList<QTreeWidgetItem*> selectedItemList = selectedItems();
    if ( selectedItemList.size() == 0 )
        return;

    // Before deleting, save next item, 0 if none.
    QTreeWidgetItem* next = itemBelow( selectedItemList.last() );

    for ( int i = 0; i < selectedItemList.size(); ++i ) {
        if ( selectedItemList.at( i ) )
            delete selectedItemList.at( i );
    }

    if ( !next )
        return;

    /* crashing
    kDebug(5002) << "A" << endl;
    next->setSelected( true );
    setCurrentItem( next );
    */
}

/*void DataListViewItem::QTreeWidgetItem()
{
    setTextAlignment center....
}*/

#include "datalistview.moc"
