/* This file is part of the KDE project

   Copyright (C) 2007 Omat Holding B.V. <info@omat.nl>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

// Own
#include "headerview.h"
#include "headerproxy.h"
#include "headerdelegate.h"

// Qt
#include <QApplication>
#include <QPixmap>
#include <QPainter>

// KDE
#include <KDebug>

#include <akonadi/kmime/messagemodel.h>

using namespace Mailody;

HeaderView::HeaderView( QWidget * parent )
        : QTreeView( parent ), m_dragWidget( 0 )
{
    setAlternatingRowColors( true );
    setDragDropMode( QAbstractItemView::DragOnly );
    setDragEnabled( true );
    setAcceptDrops( false );
    setSortingEnabled( true );
    setSelectionMode( QAbstractItemView::ExtendedSelection );

    HeaderDelegate* delegate = new HeaderDelegate( this );
    setItemDelegate( delegate );
}

void HeaderView::mousePressEvent( QMouseEvent * event )
{
    event->accept();
    QTreeView::mousePressEvent( event );

    // bail out when the user clicks on an empty area of the view.
    QModelIndex index = indexAt( event->pos() );
    if ( !index.isValid() )
        return;

    const HeaderProxy *headerProxy =
        static_cast<const HeaderProxy*>( indexAt( event->pos() ).model() );
    const Akonadi::MessageModel *messageModel =
        static_cast<const Akonadi::MessageModel*>( headerProxy->sourceModel() );

    Akonadi::Item item = messageModel->itemForIndex( index );

    if ( !item.isValid() )
        return;

    if ( event->button() == Qt::MidButton )
        emit selectMessageMiddle( item );
    else if ( event->button() == Qt::RightButton )
        emit selectMessageRight( item );
}

/*
void HeaderView::keyPressEvent( QKeyEvent* e )
{
    if ( e->key() == Qt::Key_Left ) {
        e->accept();
        QModelIndex above = indexAbove( currentIndex() );
        if ( !above.isValid() )
            return;
        setSelection( visualRect( currentIndex() ), QItemSelectionModel::Deselect );
        setCurrentIndex( above );
        scrollTo( above,QAbstractItemView::PositionAtCenter );

        QSortFilterProxyModel* proxy = static_cast<QSortFilterProxyModel*>( model() );
        HeaderModel* model = static_cast<HeaderModel*>( proxy->sourceModel() );
        QModelIndex modelIndex = proxy->mapToSource( above );
        QPair<int,QString> item = model->getMessage( modelIndex );
        emit selectMessageLeft( item );
    } else if ( e->key() == Qt::Key_Right ) {
        e->accept();
        QModelIndex below = indexBelow( currentIndex() );
        if ( !below.isValid() )
            return;
        setSelection( visualRect( currentIndex() ), QItemSelectionModel::Deselect );
        setCurrentIndex( below );
        scrollTo( below,QAbstractItemView::PositionAtCenter );

        QSortFilterProxyModel* proxy = static_cast<QSortFilterProxyModel*>( model() );
        HeaderModel* model = static_cast<HeaderModel*>( proxy->sourceModel() );
        QModelIndex modelIndex = proxy->mapToSource( below );
        QPair<int,QString> item = model->getMessage( modelIndex );
        emit selectMessageLeft( item );
    } else if ( e->key() == Qt::Key_Down ) {
        e->accept();
        emit scrollDown();
    } else if ( e->key() == Qt::Key_Up ) {
        e->accept();
        emit scrollUp();
    } else if ( e->key() == Qt::Key_PageDown ) {
        e->accept();
        emit scrollPageDown();
    } else if ( e->key() == Qt::Key_PageUp ) {
        e->accept();
        emit scrollPageUp();
    } else
        QTreeView::keyPressEvent( e );

}

QModelIndex HeaderView::nextUnread()
{
    QModelIndex start = currentIndex();
    QModelIndex below = indexBelow( currentIndex() );

    if ( !start.isValid() )
        start = below = indexAt( QPoint( 0,0 ) );

    const QSortFilterProxyModel* proxy =
        static_cast<QSortFilterProxyModel*>( model() );
    const HeaderModel* model = static_cast<HeaderModel*>( proxy->sourceModel() );
    while ( below.isValid() ) {
        const QModelIndex modelIndex = proxy->mapToSource( below );
        if ( model->isNew( modelIndex ) )
            return below;

        below = indexBelow( below );

        if ( below == start )
            break;
    }
    return QModelIndex();
}
*/

QList<int> HeaderView::columnSizes()
{
    QList<int> sizes;
    if ( !model() )
        return sizes; /* before the first folder...*/

    for ( int i = 0; i < model()->columnCount(); ++i )
        sizes.append( columnWidth( i ) );
    return sizes;
}

void HeaderView::setColumnSizes( QList<int> sizes )
{
    for ( int i = 0; i < sizes.size(); ++i )
        setColumnWidth( i, sizes.at( i ) );
}

void HeaderView::openItem( const QModelIndex & index )
{
    static const HeaderProxy *headerProxy =
        static_cast<const HeaderProxy*>( model() );
    setExpanded( headerProxy->mapFromSource( index ), true );
}

#include "headerview.moc"
