/*
   Copyright (C) 2006-2007 Omat Holding B.V. <info@omat.nl>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

#include "mailodybaselistview.h"

#include <QMouseEvent>
#include <QTreeWidget>
#include <QDateTime>


using namespace Mailody;

MailodyBaseListView::MailodyBaseListView( QWidget* parent )
        : QTreeWidget( parent )
{
    setSortingEnabled( true );
    setContextMenuPolicy( Qt::CustomContextMenu );
    setAlternatingRowColors( true );
}

void MailodyBaseListView::leaveEvent( QEvent* )
{
    emit leftWidget();
}

QList<int> MailodyBaseListView::columnSizes()
{
    QList<int> sizes;
    for ( int i = 0; i < columnCount(); ++i )
        sizes.append( columnWidth( i ) );
    return sizes;
}

void MailodyBaseListView::setColumnSizes( QList<int> sizes )
{
    for ( int i = 0; i < sizes.size(); ++i )
        setColumnWidth( i, sizes.at( i ) );
}

void MailodyBaseListView::mousePressEvent( QMouseEvent * event )
{
    // TODO: convert to the customcontext way.

    QTreeWidget::mousePressEvent( event );

    MailodyBaseListViewItem* item =
        static_cast<MailodyBaseListViewItem*>( itemAt( event->pos() ) );

    int column = columnAt( event->x() );

    if ( event->button() == Qt::LeftButton )
        emit selectButton( item, column );
    else if ( event->button() == Qt::MidButton )
        emit midButton( item, column );
    else if ( event->button() == Qt::RightButton )
        emit contextButton( item, column );
}

//-------------------------------------------------------------------//

MailodyBaseListViewItem::MailodyBaseListViewItem( QTreeWidget* parent )
        : QTreeWidgetItem( parent ), m_level( 1 )
{
}

MailodyBaseListViewItem::MailodyBaseListViewItem( MailodyBaseListViewItem* parent )
        : QTreeWidgetItem( parent ), m_level( parent->level() )
{
}

bool MailodyBaseListViewItem::operator<( const QTreeWidgetItem &other ) const
{
    MailodyBaseListViewItem otherItem
    = static_cast<const MailodyBaseListViewItem&>( other );

    if ( level() < otherItem.level() )
        return true;

    if ( level() > otherItem.level() )
        return false;

    int column = treeWidget()->sortColumn();
    QVariant first = data( column, Qt::UserRole );
    QVariant second = otherItem.data( column, Qt::UserRole );

    if ( first.type() == QVariant::Int )
        return first.toInt() < second.toInt() ;
    else if ( first.type() == QVariant::DateTime )
        return first.toDateTime() < second.toDateTime();
    else if ( first.type() == QVariant::String )
        return first.toString().compare( second.toString() ) < 0;

    return QTreeWidgetItem::operator<( other );
}

#include "mailodybaselistview.moc"
