/* This file is part of the KDE project

   Copyright (C) 2006-2007 Omat Holding B.V. <info@omat.nl>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

#ifndef QUICKREPLYWIDGET_H
#define QUICKREPLYWIDGET_H

#include <QWidget>

class KTextEdit;
class QLabel;

namespace Mailody
{

class MessageData;

/**
 * @class QuickReplyWidget
 * This widget can be used to quickly reply to a message, by only providing
 * a text edit.
 * @author Tom Albers <tomalbers@kde.nl>
 */
class QuickReplyWidget : public QWidget
{
    Q_OBJECT

public:
    /**
      * Constructor
      * @param parent the parent widget
      */
    explicit QuickReplyWidget( QWidget* parent );

    /**
      * Set the message on which the reply will be.
      */
    void setMessage( MessageData* );

private slots:
    void slotSend();
    void slotDone();
    void slotError( const QString& error );

private:
    KTextEdit *m_editor;
    QLabel *m_details;
    MessageData *m_message;

signals:
    void finished();
};

}

#endif
