/* This file is part of the KDE project
   Copyright (C) 2006-2007 Omat Holding B.V. <info@omat.nl>

   Original copied from showfoto:
    Copyright 2005 by Gilles Caulier <caulier.gilles@free.fr>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

// Own
#include "setup.h"
#include "global.h"
#include "setupservers.h"
#include "setupidentities.h"
#include "setupmisc.h"

// KDE
#include <KLocale>
#include <KMessageBox>

// Qt
#include <QSslSocket>
using namespace Mailody;

class SetupPriv
{
public:
};

Setup::Setup( QWidget* parent, const char* name )
        : KPageDialog( parent )
{
    setObjectName( name );
    setFaceType( KPageDialog::List );
    setCaption( i18n( "Configure" ) );

    m_serversPage = new SetupServers( this );
    KPageWidgetItem *page_servers = addPage( m_serversPage, i18n( "Servers" ) );
    page_servers->setHeader( i18n( "Servers" ) );
    page_servers->setIcon( KIcon( "configure" ) );

    m_identitiesPage = new SetupIdentities( this );
    KPageWidgetItem *page_identities = addPage( m_identitiesPage,
                                       i18n( "Identities" ) );
    page_identities->setHeader( i18n( "Identities Settings" ) );
    page_identities->setIcon( KIcon( "configure" ) );

    m_miscPage = new SetupMisc( this );
    KPageWidgetItem *page_misc = addPage( m_miscPage, i18n( "Misc" ) );
    page_misc->setHeader( i18n( "Misc" ) );
    page_misc->setIcon( KIcon( "configure" ) );

    connect( this, SIGNAL( okClicked() ), this, SLOT( slotOkClicked() ) );

    setCurrentPage( page_servers );

    setInitialSize( QSize( 555,280 ) );
    show();

    if ( !QSslSocket::supportsSsl() ) {
        KMessageBox::information( 0,i18n( "Your system does not seem to be "
                                          "set up for TLS or SSL, these settings are disabled." ),
                                  QString(), "TLS_SSL_DISABLED" );
    }
}

Setup::~Setup()
{
    Global::myEmail( QString(), true );
}

void Setup::slotOkClicked()
{
    m_identitiesPage->applySettings();
    m_miscPage->applySettings();
    close();
}

#include "setup.moc"
