/* This file is part of the KDE project
   Copyright (C) 2006-2007 Omat Holding B.V. <info@omat.nl>
   Copyright (C) 2007 Frode M. Døving <frode@lnix.net>

   Original copied from showfoto:
    Copyright 2005 by Gilles Caulier <caulier.gilles@free.fr>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

#ifndef SETUPIDENTITIES_H
#define SETUPIDENTITIES_H

#include <klistwidget.h>

class KLineEdit;
class KTabWidget;
class KTextEdit;

class QButtonGroup;
class QGroupBox;
class QPushButton;

namespace KPIMIdentities
{
class SignatureConfigurator;
}

namespace Mailody
{

/**
 * @class SetupIdentities
 * These contain the identites settings
 * This file is originally copied from showfoto
 * @author Gilles Caulier <caulier.gilles@free.fr>
 * @author Tom Albers <tomalbers@kde.nl>
 */
class SetupIdentities : public QWidget
{
    Q_OBJECT

public:

    /**
     * Constructor
     * @param parent Parent Widget
     */
    SetupIdentities( QWidget *parent = 0 );

    /**
     * Destructor
     */
    ~SetupIdentities();

    /**
     * Call this if you want the settings saved from this page.
     */
    void applySettings();

    /**
     * Call this if the number of list items changes.
     */
    void updateButtons();

private slots:
    void slotDel();
    void slotAdd();
    void slotSelectionChanged( QListWidgetItem*, QListWidgetItem* );
    void slotIdentityNameEdit( const QString &text );

private:
    void readSettings();
    void saveCurrent();

    QString                 m_currentIdentity;

    KTabWidget             *m_tabWidget;
    KListWidget            *m_identybox;

    KLineEdit              *m_identityName;
    KLineEdit              *m_fullName;
    KLineEdit              *m_emailAddress;
    QPushButton            *m_del;
    QGroupBox              *m_htmlPart;
    QGroupBox              *m_htmlPrefer;
    QGroupBox              *m_sigPos;

    QButtonGroup           *m_htmlPart_group;
    QButtonGroup           *m_htmlPrefer_group;
    QButtonGroup           *m_sigPos_group;

    KPIMIdentities::SignatureConfigurator   * m_signatureWidget;
};

}

#endif
