/* This file is part of the KDE project

   Copyright (C) 2008 Omat Holding B.V. <info@omat.nl>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/


#ifndef SYSTEMTRAY_H
#define SYSTEMTRAY_H

#include <QIcon>
#include <QPixmap>

#include <KSystemTrayIcon>

namespace Mailody
{

class SystemTray : public KSystemTrayIcon
{
    Q_OBJECT

public:
    /**
     * Contructor
     * @param parent Parent Widget
     */
    SystemTray( QWidget *parent );

    /**
     * Destructor
     */
    ~SystemTray();

public slots:
    void unreadCountChanged( int );

protected:
    /**
     * Reimplemented to catch the tooltip event.
     */
    virtual bool event( QEvent * event );

private:
    QImage m_lightIconImage;
    QPixmap m_defaultIcon;
    int m_unread;
};
} // namespace Mailody

#endif // SYSTEMTRAY_H

