/* This file is part of the KDE project
    Copyright (C) 2006-2007 Omat Holding B.V. <info@omat.nl>

   It has been copied from RSIBreak:
     Copyright (C) 2005-2006 Bram Schoenmakers <bramschoenmakers@kde.nl>
     Copyright (C) 2006 Tom Albers <tomalbers@kde.nl>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

// Own
#include "tooltip.h"

// System
#include <math.h>

// Qt
#include <QLabel>
#include <QPixmap>
#include <QTimer>
#include <QApplication>
#include <QMouseEvent>
#include <QContextMenuEvent>
#include <QTextEdit>

// KDE
#include <kapplication.h>
#include <kdebug.h>
#include <kiconloader.h>
#include <klocale.h>
#include <kvbox.h>

using namespace Mailody;

ToolTip::ToolTip( QWidget *parent, const char *name )
        : KPassivePopup( parent )
{
    setObjectName( name );
    setTimeout( 5 * 1000 );

    KHBox *hbox = new KHBox( this );
    hbox->setSpacing( 10 );

    QLabel* mIcon = new QLabel( hbox );
    mIcon->resize( 32, 32 );
    mIcon->setPixmap( DesktopIcon( "mailody" ) );

    KVBox *vbox = new KVBox( hbox );
    vbox->setSpacing( 5 );
    new QLabel( "<qt><strong>Mailody</strong></qt>", vbox );
    mText = new QLabel( vbox );

    setView( hbox );

    m_clearTimer = new QTimer( this );
    m_clearTimer->setSingleShot( true );
    connect( m_clearTimer , SIGNAL( timeout() ), SLOT( clearBlockList() ) );
}

ToolTip::~ToolTip()
{
}

void ToolTip::addToBlockList( const QString& mb )
{
    m_blockList[mb] = true;
    m_clearTimer->start( 10000 );
}

void ToolTip::clearBlockList()
{
    m_blockList.clear();
}

void ToolTip::setText( const QString &mb, const QString& text )
{
    if ( m_blockList[mb] )
        return;

    if ( isVisible() )
        mText->setText( mText->text() + "<br>" + text );
    else
        mText->setText( text );

    adjustSize();

    // this is needed so the popup does not popup on random locations...
    kapp->processEvents();
    show();
}

void ToolTip::setText( const QPoint& point,  const QString& text )
{
    mText->setText( text );
    adjustSize();
    show();
    moveNear( QRect( point,point ) );
}

void ToolTip::mouseReleaseEvent( QMouseEvent * e )
{
    QTextEdit rt( this );
    rt.setText( mText->text() );
    rt.setFont( font() );
//     rt.setWidth(mText->width());
    QString link = rt.anchorAt( mText->mapFrom( this,e->pos() ) );

    // Delete the popup before emitting
    KPassivePopup::mouseReleaseEvent( e );
    if ( !link.isEmpty() )
        emit leftClicked( link );
}

void ToolTip::contextMenuEvent( QContextMenuEvent * e )
{
    QTextEdit rt( this );
    rt.setText( mText->text() );
    rt.setFont( font() );
//     rt.setWidth(mText->width());
    QString link = rt.anchorAt( mText->mapFrom( this,e->pos() ) );
    if ( !link.isEmpty() )
        rightClicked( link );

    hide();
}

#include "tooltip.moc"
