/* This file is part of Malaga, a system for Natural Language Analysis.
 * Copyright (C) 1995-1999 Bjoern Beutel
 *
 * Bjoern Beutel
 * Universitaet Erlangen-Nuernberg
 * Abteilung fuer Computerlinguistik
 * Bismarckstrasse 12
 * D-91054 Erlangen
 * e-mail: malaga@linguistik.uni-erlangen.de 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */

/* description ==============================================================*/

/* This module contains data structures and functions related to the generation
 * of the allomorph lexicon. */

/* variables ================================================================*/

GLOBAL int_t lex_entry_line_number; 
/* line number of lexical entry just parsed. READ ONLY! */

GLOBAL string_t lex_entry_file_name;
/* name of lexicon file just parsed. READ ONLY! */

GLOBAL rule_sys_t *allo_rule_sys; /* READ ONLY! */

/* functions ================================================================*/

extern void write_lex_buffer (string_t file_name);
/* Write lexicon buffer in binary format to file <file_name>. */

extern void print_lex_buffer (FILE *stream, string_t allo_format);
/* Write lexicon buffer in text format to <stream>. */

extern void print_lex_statistics (FILE *stream);
/* Print statistics about lexicon buffer into <stream>. */

extern void generate_allos_for_file (string_t source_name);
/* Parse a lexicon file <source_name> and generate allomorphs.
 * Write allomorphs into lexicon buffer. */

extern void generate_allos_for_line (string_t lexicon_name, int_t line);
/* Read line <line> in lexicon file <lexicon_name> and generate allomorphs.
 * Write allomorphs into lexicon buffer. */

extern void generate_allos_for_string (string_t category_string);
/* Generate allomorphs for "category_string".
 * Write allomorphs into lexicon buffer. */

extern void init_lex_compiler (string_t allo_rule_file);
/* Initialise the lex_compiler module.
 * Use allomorph rules from "allo_rule_file". */

extern void terminate_lex_compiler (void);
/* Free the lex_compiler module. */

/* end of file ==============================================================*/
