/* Copyright (C) 1995 Bjoern Beutel. */

/* Description. =============================================================*/

/* In this file, the administration of breakpoints is managed. */

/* Types. ===================================================================*/

typedef struct /* Associates a rule system with a name. */
{ 
  rule_sys_t *rule_sys;
  string_t name; /* Name of the above rule system. */
} rule_sys_name_t;

/* Functions. ===============================================================*/

extern void get_breakpoint( string_t argument, 
			    rule_sys_t **rule_sys_p, 
			    int_t *instr_p );
/* Parse breakpoint in ARGUMENT and set *RULE_SYS_P and *INSTR_P. */

extern int_t at_breakpoint( rule_sys_t *rule_sys, int_t instruction );
/* Return breakpoint number if INSTRUCTION in RULE_SYS hits a breakpoint; 
 * return 0 else. */

extern void init_breakpoints( int_t rule_sys_count, 
			      rule_sys_name_t rule_sys[] );
/* Initialise this module. Pass the number of rule systems in RULE_SYS_COUNT
 * and their names in RULE_SYS. */

extern void terminate_breakpoints( void ); 
/* Terminate this module. */

/* Commands. ================================================================*/

extern command_t delete_command;
/* Delete a breakpoint. */

extern command_t break_command;
/* Define a breakpoint. */

extern command_t list_command;
/* List breakpoints. */

/* End of file. =============================================================*/
