Request for Contributions
=========================

Please contribute to this repository if any of the following is true: - You have
ability in community development, communication, or education - You want the
open source communities to be more collaborative and inclusive - You want to
help lower the burden to first time contributors

How to Contribute
=================

Prerequisites:

-   Familiarity with [pull
    requests](https://help.github.com/articles/using-pull-requests) and
    [issues](https://guides.github.com/features/issues/).

-   Knowledge of Machine Language if editing source code documents.

This community seeks the following types of contributions:

-   **Ideas**: take part in an issue thread or start your own to have your voice
    heard.

-   **Resources**: send a pull request to add to RESOURCES.md with links to
    related content.

-   **Outline sections**: help us ensure that this repository is comprehensive.
    if there exists an overlooked topic, please add it, even if it is just a
    stub in the form of a header and single sentence comment. Initially, most
    things fall into this category.

-   **Writing**: contribute your ability in an area by helping us expand the
    included content.

-   **Copy editing**: fix typos, clarify language, and improve the quality of
    the content.

-   **Formatting**: help keep content easy to read with consistent formatting.

Conduct
=======

We have committed to offering a friendly, safe, and welcoming environment for
all, regardless of gender, sexual orientation, disability, ethnicity, religion,
or similar personal characteristic.

Please be kind and courteous. There exists no need to be mean or rude. **Respect
the differences of opinion and know that every strategic design or
implementation choice carries a trade-off between benefits and costs.** There is
seldom a ‘right’ answer, merely an optimized answer given a set of values and
circumstances.

Please keep unstructured critique to a minimum. If you have solid ideas you want
to experiment with, make a fork and see how it works!

We will exclude you from interaction if you insult, demean, or harass anyone.
That is not welcome behavior. We interpret the term "harassment" as including
the definition in the [Citizen Code of
Conduct](http://citizencodeofconduct.org/); if you have any lack of clarity
about what exists in that concept, please read their definition.

Whether you are a regular contributor or a newcomer, we care about making this
community a safe place for you and we have your back. Likewise, any spamming,
trolling, flaming, baiting or other attention-stealing behavior is not welcome.

Communication
=============

We invite you to join us! You're welcome to drop in and ask questions, discuss
bugs, etc.

GitHub issues are the primary way for communicating about specific proposed
changes to this project.

Please follow the conduct guidelines above. Language issues are often
contentious and we would like to keep discussion scientific, civil and focused
on delivering the fastest, most efficient 3D Fractal Generation System.
