/**
 * Mandelbulber v2, a 3D fractal generator  _%}}i*<.        ____                _______
 * Copyright (C) 2018 Mandelbulber Team   _>]|=||i=i<,     / __ \___  ___ ___  / ___/ /
 *                                        \><||i|=>>%)    / /_/ / _ \/ -_) _ \/ /__/ /__
 * This file is part of Mandelbulber.     )<=i=]=|=i<>    \____/ .__/\__/_//_/\___/____/
 * The project is licensed under GPLv3,   -<>>=|><|||`        /_/
 * see also COPYING file in this folder.    ~+{i%+++
 *
 * Surf Box Fold v2 4d
 * based on DarkBeam's code "Mixed fold by Luca 2016".
 * @reference
 * http:// http://www.fractalforums.com/amazing-box-amazing-surf-and-variations/
 * httpwww-shaperich-comproshred-elite-review
 * This formula contains aux.color,

 * This file has been autogenerated by tools/populateUiInformation.php
 * from the function "TransfSurfBoxFoldV24dIteration" in the file fractal_formulas.cpp
 * D O    N O T    E D I T    T H I S    F I L E !
 */

REAL4 TransfSurfBoxFoldV24dIteration(REAL4 z, __constant sFractalCl *fractal, sExtendedAuxCl *aux)
{
	Q_UNUSED(aux);

	REAL colorAdd = 0.0f;
	REAL4 oldZ = z;
	REAL4 foldMod = fractal->transformCommon.offset2222;
	REAL4 fold = fractal->transformCommon.offset1111;
	REAL4 sg = z;
	sg.x = sign(z.x);
	sg.y = sign(z.y);
	sg.z = sign(z.z);
	sg.w = sign(z.w);

	REAL4 folder = z;
	REAL4 Tglad = z;
	Tglad = fabs(z + fold) - fabs(z - fold) - z;
	folder = sg * (z - Tglad);
	folder = fabs(folder);

	folder.x = min(folder.x, foldMod.x);
	folder.y = min(folder.y, foldMod.y);
	folder.z = min(folder.z, foldMod.z);
	folder.w = min(folder.w, foldMod.w);

	z -= sg * folder;

	// analyic DE tweak
	if (fractal->analyticDE.enabledFalse)
	{
		aux->DE = mad(aux->DE, fractal->analyticDE.scale1, fractal->analyticDE.offset0);
	}
	// color
	if (fractal->foldColor.auxColorEnabledFalse)
	{
		REAL4 zCol = z;
		if (fractal->transformCommon.functionEnabledCxFalse)
		{
			if (zCol.x != oldZ.x)
				colorAdd += fractal->mandelbox.color.factor4D.x
										* (fabs(zCol.x) - fractal->transformCommon.offset1111.x);
			if (zCol.y != oldZ.y)
				colorAdd += fractal->mandelbox.color.factor4D.y
										* (fabs(zCol.y) - fractal->transformCommon.offset1111.y);
			if (zCol.z != oldZ.z)
				colorAdd += fractal->mandelbox.color.factor4D.z
										* (fabs(zCol.z) - fractal->transformCommon.offset1111.z);
			if (zCol.w != oldZ.w)
				colorAdd += fractal->mandelbox.color.factor4D.w
										* (fabs(zCol.w) - fractal->transformCommon.offset1111.w);
		}
		else
		{
			if (zCol.x != oldZ.x) aux->color += fractal->mandelbox.color.factor4D.x;
			if (zCol.y != oldZ.y) aux->color += fractal->mandelbox.color.factor4D.y;
			if (zCol.z != oldZ.z) aux->color += fractal->mandelbox.color.factor4D.z;
			if (zCol.w != oldZ.w) aux->color += fractal->mandelbox.color.factor4D.w;
		}
		aux->color += colorAdd;
	}
	return z;
}