#include <gtk/gtk.h>

#include "guiutils.h"
#include "aboutdialog.h"
#include "manedit.h"
#include "config.h"

#include "images/icon_ok_20x20.xpm"
#include "images/manedit_48x48.xpm"   
#include "images/manedit_banner_400x150.xpm"


static void AboutDialogOKCB(GtkWidget *widget, gpointer data);
static gint AboutDialogDeleteEventCB(
	GtkWidget *widget, GdkEvent *event, gpointer data
);

about_dialog_struct *AboutDialogNew(void *core_ptr);
void AboutDialogMap(about_dialog_struct *ad);
void AboutDialogUnmap(about_dialog_struct *ad);
void AboutDialogDelete(about_dialog_struct *ad);


#define ABOUT_DIALOG_BTN_WIDTH	(100 + (2 * 3))
#define ABOUT_DIALOG_BTN_HEIGHT	(30 + (2 * 3))


/*
 *	Ok callback.
 */
static void AboutDialogOKCB(GtkWidget *widget, gpointer data)
{
	about_dialog_struct *ad = ABOUT_DIALOG(data);
	if(ad == NULL)
	    return;

	AboutDialogUnmap(ad);
}

/*
 *	"delete_event" signal callback.
 */
static gint AboutDialogDeleteEventCB(
	GtkWidget *widget, GdkEvent *event, gpointer data
)
{
	AboutDialogOKCB(widget, data);
	return(TRUE);
}


/*
 *	Creates a new About Dialog.
 */
about_dialog_struct *AboutDialogNew(void *core_ptr)
{
	GdkWindow *window;
	GtkStyle *style;
	GtkWidget *w, *parent, *parent2, *parent3;
	gchar version_string[256];
	medit_cursors_list_struct *cursors_list = NULL;
	medit_styles_list_struct *styles_list = NULL;
	about_dialog_struct *ad = ABOUT_DIALOG(g_malloc0(
	    sizeof(about_dialog_struct)
	));
	if(ad == NULL)
	    return(NULL);

	/* Get resources from the core */
	if(core_ptr != NULL)
	{
	    cursors_list = &MEDIT_CORE(core_ptr)->cursors_list;
	    styles_list = &MEDIT_CORE(core_ptr)->styles_list;
	}

	/* Reset values */
	ad->initialized = TRUE;
	ad->map_state = FALSE;

	/* Toplevel */
	ad->toplevel = w = gtk_window_new(GTK_WINDOW_DIALOG);
	gtk_widget_realize(w);
	window = w->window;
	if(window != NULL)
	{
	    gdk_window_set_decorations(
		window,
		GDK_DECOR_BORDER | GDK_DECOR_TITLE | GDK_DECOR_MENU |
		GDK_DECOR_MINIMIZE
	    );
	    gdk_window_set_functions(
		window,
		GDK_FUNC_MOVE | GDK_FUNC_MINIMIZE | GDK_FUNC_CLOSE
	    );
	}
	GUISetWMIcon(w->window, (guint8 **)manedit_48x48_xpm);
	gtk_signal_connect(
	    GTK_OBJECT(w), "delete_event",
	    GTK_SIGNAL_FUNC(AboutDialogDeleteEventCB), ad
	);
	parent = w;


	/* Main vbox */
	w = gtk_vbox_new(FALSE, 0);
	gtk_container_add(GTK_CONTAINER(parent), w);
	gtk_widget_show(w);
	parent = w;


	/* Hbox to hold banners and labels */
	w = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(parent), w, TRUE, TRUE, 5);
	gtk_widget_show(w);
	parent2 = w;

	/* Vbox inside of hbox for alignment */
	w = gtk_vbox_new(FALSE, 5);
	gtk_box_pack_start(GTK_BOX(parent2), w, TRUE, TRUE, 5);
	gtk_widget_show(w);
	parent2 = w;

	/* Heading image */
	w = gtk_alignment_new(0.5, 0.5, 1.0, 1.0);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent3 = w;

	w = (GtkWidget *)GUICreateMenuItemIcon(
	    (guint8 **)manedit_banner_400x150_xpm
	);
	gtk_widget_set_usize(w, 400, 150);
	gtk_container_add(GTK_CONTAINER(parent3), w);
	gtk_widget_show(w);

	/* Version banner */
	g_snprintf(
	    version_string, sizeof(version_string),
	    "Version %s",
	    PROG_VERSION
	);
	style = (styles_list != NULL) ?
	    styles_list->heading3_rev_text : NULL;
	if(style != NULL)
	{
	    w = GUIBannerCreate(
		version_string,
		MEDIT_FONT_NAME_HEADING3_REV,
		style->fg[GTK_STATE_NORMAL],
		style->bg[GTK_STATE_NORMAL],
		GTK_JUSTIFY_CENTER, TRUE
	    );
	    gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	    gtk_widget_show(w);
	}

	/* Copyright label */
	w = gtk_label_new(PROG_COPYRIGHT);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_label_set_justify(GTK_LABEL(w), GTK_JUSTIFY_LEFT);
	gtk_widget_show(w);


	/* Horizontal rule */
	w = gtk_hseparator_new();
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
	gtk_widget_show(w);

	/* Hbox to hold buttons homogeniously */
	w = gtk_hbox_new(TRUE, 0);   
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 5);
	gtk_widget_show(w);
	parent2 = w;

	/* Ok button */
	w = GUIButtonPixmapLabelH(
	    (guint8 **)icon_ok_20x20_xpm, "OK", NULL
	);
	ad->ok_btn = w;
	gtk_widget_set_usize(w,
	    ABOUT_DIALOG_BTN_WIDTH, ABOUT_DIALOG_BTN_HEIGHT
	);
	GTK_WIDGET_SET_FLAGS(w, GTK_CAN_DEFAULT);
	gtk_box_pack_start(GTK_BOX(parent2), w, TRUE, FALSE, 0);
	gtk_signal_connect(
	    GTK_OBJECT(w), "clicked",
	    GTK_SIGNAL_FUNC(AboutDialogOKCB),
	    (gpointer)ad
	);
	gtk_widget_show(w);

	return(ad);
}


/*
 *	Maps the About Dialog.
 */
void AboutDialogMap(about_dialog_struct *ad)
{
	GtkWidget *w;

	if(ad == NULL)
	    return;

	w = ad->ok_btn;
	if(w != NULL)
	{
	    gtk_widget_grab_focus(w);
	    gtk_widget_grab_default(w);
	}

	w = ad->toplevel;
	if(w != NULL)
	    gtk_widget_show_raise(w);

	ad->map_state = TRUE;
}

/*
 *	Unmaps the About Dialog.
 */
void AboutDialogUnmap(about_dialog_struct *ad)
{
	GtkWidget *w;

	if(ad == NULL)
	    return;

	w = ad->toplevel;
	if(w != NULL)
	    gtk_widget_hide(w);

	ad->map_state = FALSE;
}

/*
 *	Deletes the About Dialog.
 */
void AboutDialogDelete(about_dialog_struct *ad)
{
	if(ad == NULL)
	    return;

	GTK_WIDGET_DESTROY(ad->ok_btn)
	GTK_WIDGET_DESTROY(ad->toplevel)
	g_free(ad);
}
