/*
                Manual Page Editor: Operations and Procedures
 */

#ifndef EDITOROP_H
#define EDITOROP_H

#include <gtk/gtk.h>
#include "editor.h"


extern void EditorSyntaxHighlight(
        editor_struct *editor, GtkWidget *w,
        gint cursor_pos, gint start_pos, gint end_pos
);

extern void EditorDoFetchValues(
	editor_struct *editor, GtkCTreeNode *branch
);
extern void EditorDoApplyValues(
	editor_struct *editor, GtkCTreeNode *branch
);
extern void EditorDoClearValues(editor_struct *editor);

extern void EditorDoPreview(
        editor_struct *editor, GtkCTreeNode *branch,
        gint viewer_num
);

extern gboolean EditorDoFind(
        editor_struct *editor, GtkText *text,
        gchar *haystack, gchar *needle,
        gint haystack_len, gint start_pos,
        gboolean case_sensitive,
	gboolean move_to,
        gboolean *search_wrapped
);
extern gboolean EditorDoReplace(
        editor_struct *editor, GtkText *text,
        gchar *haystack, gchar *needle, const gchar *replacement,
        gint haystack_len, gint start_pos,
        gboolean case_sensitive
);
extern gint EditorDoReplaceAll(
        editor_struct *editor, GtkText *text,
        gchar *needle, const gchar *replacement,
        gboolean case_sensitive
);

#endif	/* EDITOROP_H */
