/*
                   Manual Page Editor: Editor Callbacks
 */

#ifndef EDITORCB_H
#define EDITORCB_H

#include <gtk/gtk.h>
#include "editor.h"


extern void EditorItemDestroyCB(gpointer data);

extern gint EditorKeyEventCB(GtkWidget *widget, GdkEventKey *key, gpointer data);
extern void EditorDestroyCB(GtkObject *object, gpointer data);
extern gint EditorCloseCB(GtkWidget *widget, GdkEvent *event, gpointer data);
extern void EditorCloseMCB(GtkWidget *widget, gpointer data);
extern void EditorCloseAllMCB(GtkWidget *widget, gpointer data);

extern void EditorManualNewCB(GtkWidget *widget, gpointer data);
extern void EditorManualOpenCB(GtkWidget *widget, gpointer data);
extern void EditorManualNewFromTemplateCB(GtkWidget *widget, gpointer data);
extern void EditorManualSaveCB(GtkWidget *widget, gpointer data);
extern void EditorManualSaveAsCB(GtkWidget *widget, gpointer data);
extern void EditorManualRevertCB(GtkWidget *widget, gpointer data);
extern void EditorManualCloseCB(GtkWidget *widget, gpointer data);

extern void EditorManualAddHeaderCB(GtkWidget *widget, gpointer data);
extern void EditorManualAddSectionCB(GtkWidget *widget, gpointer data);
extern void EditorManualRemoveSectionCB(GtkWidget *widget, gpointer data);
extern void EditorManualPropertiesCB(GtkWidget *widget, gpointer data);
extern void EditorManualPreviewCB(GtkWidget *widget, gpointer data);

extern void EditorManualSyntaxHighlightToggleCB(
	GtkWidget *widget, gpointer data
);

extern void EditorUndoCB(GtkWidget *widget, gpointer data);
extern void EditorRedoCB(GtkWidget *widget, gpointer data);
extern void EditorCutCB(GtkWidget *widget, gpointer data);
extern void EditorCopyCB(GtkWidget *widget, gpointer data);
extern void EditorPasteCB(GtkWidget *widget, gpointer data);
extern void EditorDeleteCB(GtkWidget *widget, gpointer data);
extern void EditorClipboardBrowserCB(GtkWidget *widget, gpointer data);
extern void EditorSelectAllCB(GtkWidget *widget, gpointer data);
extern void EditorUnselectAllCB(GtkWidget *widget, gpointer data);
extern void EditorPreferencesCB(GtkWidget *widget, gpointer data);

extern void EditorFmtParagraphLeftCB(GtkWidget *widget, gpointer data);
extern void EditorFmtParagraphRightCB(GtkWidget *widget, gpointer data);
extern void EditorFmtParagraphIndentedCB(GtkWidget *widget, gpointer data);
extern void EditorFmtListItemCB(GtkWidget *widget, gpointer data);
extern void EditorFmtBoldCB(GtkWidget *widget, gpointer data);
extern void EditorFmtUnderlineCB(GtkWidget *widget, gpointer data);
extern void EditorFmtLineBreakCB(GtkWidget *widget, gpointer data);
extern void EditorFmtAmpersandCB(GtkWidget *widget, gpointer data);
extern void EditorFmtLessThanCB(GtkWidget *widget, gpointer data);
extern void EditorFmtGreaterThanCB(GtkWidget *widget, gpointer data);
extern void EditorStripTagsCB(GtkWidget *widget, gpointer data);

extern void EditorMapFIPCB(GtkWidget *widget, gpointer data);

extern void EditorFindBarFindCB(GtkWidget *widget, gpointer data);
extern void EditorFindBarReplaceCB(GtkWidget *widget, gpointer data);
extern void EditorFindBarReplaceAllCB(GtkWidget *widget, gpointer data);
extern void EditorFindBarReplaceEntirePageCB(GtkWidget *widget, gpointer data);

extern void EditorFindBarFindActivateCB(GtkWidget *widget, gpointer data);
extern void EditorFindBarReplaceActivateCB(GtkWidget *widget, gpointer data);

extern gint EditorMenuMapCB(GtkWidget *widget, GdkEvent *event, gpointer data);
extern void EditorButtonMenuMapCB(GtkButton *button, gpointer data);
extern void EditorMenuHideCB(GtkWidget *widget, gpointer data);

extern void EditorLayoutCTreeDoExpandCB(GtkWidget *widget, gpointer data);
extern void EditorLayoutCTreeSelectCB(
        GtkCTree *ctree, GtkCTreeNode *branch, gint column, gpointer data
);
extern void EditorLayoutCTreeUnselectCB(
        GtkCTree *ctree, GtkCTreeNode *branch, gint column, gpointer data
);
extern void EditorLayoutCTreeExpandCB(
        GtkCTree *ctree, GtkCTreeNode *node, gpointer data
);

extern gint EditorSyntaxHighlightTimeoutCB(gpointer data);

extern gint EditorTextKeyEventCB(
        GtkEditable *editable, GdkEventKey *key, gpointer data
);
extern void EditorTextChangeCB(GtkEditable *editable, gpointer data);
extern void EditorTextInsertCB(
        GtkEditable *editable, const gchar *text, gint length,
        gint *position, gpointer data
);
extern void EditorTextDeleteCB(
        GtkEditable *editable, gint start_pos, gint end_pos, gpointer data
);


#endif	/* EDITORCB_H */
