.TH MainFrame "tcl" "tcllib - BWidget"

.SH NAME
.B MainFrame - 管理带有菜单、工具条和状态条的顶层窗口

.SH 创建 CREATION
.B MainFrame pathName ?option value...?

.SH 描述 DESCRIPTION
MainFrame 管理的顶层窗口有:

* 建立带有自动快捷键绑定和动态帮助关联的简单菜单，

* 用户可以隐藏的一个或多个工具条，

* 显示用户消息或菜单描述的一个状态条，和可选的一个进度条。 
    
.SH 组件特有选项 WIDGET-SPECIFIC OPTIONS
.TP
-height  
以 Tk_GetPixels 可接受的任何形式为用户框架指定想要的高度。如果这个选项小于等于零(缺省)则对这个窗口根本不要求任何大小。

.TP
-menu (read-only)  
这个选项描述菜单。它是一个列表，每五个元素描述一个级联菜单。它有下列格式: {菜单名 标签(tag)列表 菜单Id 撕开项 菜单项...} 这里的菜单项是一个列表，其中每个元素描述一个菜单项，它们可以是:

一个分隔符:
{separator}

一个命令:
{command 菜单名 ?标签列表? ?描述? ?快捷键? ?选项值? ...}

复选按钮:
{checkbutton 菜单名 ?标签列表? ?描述? ?快捷键? ?选项值? ...}

单选按钮:
{radiobutton 菜单名 ?标签列表? ?描述? ?快捷键? ?选项值? ...}

一个级联菜单:
{cascad 菜单名 ?标签列表? 菜单Id 撕开项 菜单项} 

这里的:
 
如果菜单名包含一个 &, 则把随后的字符自动的转换成 menu add 命令的相应的选项。
 
标签列表是这个条目的所有标签的列表，用于使用 MainFrame::setmenustate 来启用或停用菜单条目。

菜单Id 是给这个菜单的 id，你可以用 MainFrame::getmenu 来从它得到菜单路径名。

撕开项指定菜单是否有撕开条目。

描述为动态帮助指定字符串。

快捷键指定一个击键序列。它是两个元素的一个列表，其中的第一个元素是 Ctrl、Alt 或 CtrlAlt 之一，而第二个元素是一个字母或数字。建造一个快捷键字符串并在顶层窗口上设置相应的绑定来调用菜单项。

选项值为这个条目指定补充选项(参见 menu add 命令)。

被 ? 包围的每个值都是可选的并且缺省为空串，但是如果下列选项是非空则必须提供值。
 
.TP
-separator (只读) 
 指定是否把分隔线画在用户窗口的顶部和/或底部。必须是值 none、top、bottom 或 both 之一。 它依赖于用户窗口的子组件的面型(relief)。

.TP
-textvariable  
为状态条的标签指定 textvariable 选项。在这个 MainFrame 的建立的时候把菜单条目的动态帮助描述映射到这个变量。如果用 MainFrame::configure 变更了这个变量，菜单描述将不可获得。你可以通过修改这个变量的值来变更这个标签的文字。

.TP
-width  
以 Tk_GetPixels 可接受的任何形式为用户框架指定想要的宽度。如果这个选项小于等于零(缺省)则对这个窗口根本不要求任何大小。

.SH 范例
.nf
set descmenu {
    "&File" {} {} 0 {
        {command "&New"     {} "建立一个新文档"     {Ctrl n} -command Menu::new}
        {command "&Open..." {} "打开一个现存文件" {Ctrl o} -command Menu::open}
        {command "&Save"    open "保存这个文档" {Ctrl s} -command Menu::save}
        {cascad  "&Export"  {} export 0 {
            {command "Format &1" open "导出文档为格式 1" {} -command {Menu::export 1}}
            {command "Format &2" open "导出文档为 2" {} -command {Menu::export 2}}
        }}
        {separator}
        {cascad "&Recent files" {} recent 0 {}}
        {separator}
        {command "E&xit" {} "退出应用程序" {} -command Menu::exit}
    }
    "&Options" {} {} 0 {
        {checkbutton "Toolbar" {} "显示/隐藏工具栏" {} 
            -variable Menu::_drawtoolbar
            -command  {$Menu::_mainframe showtoolbar toolbar $Menu::_drawtoolbar}
        }
    }
}
.fi

.SH 组件命令
.TP
pathName addindicator ?arg...? 
在状态条的右端增加一个指示器(indicator)框。从左到右增加每个指示器。指示器是用 ?arg...? 给出的选项-值配置的一个 Tk 标签(label)组件。-relief 和 -borderwidth 选项分别缺省为 sunken(凹陷) 和 1。返回建立的标签的路径名。

.TP
pathName addtoolbar  
向 MainFrame 添加一个工具条。返回在其中放置工具条的那个新窗口的路径名。

.TP
pathName cget option  
返回用 option 给出的配置选项的当前值。Option 可以是能被建立命令接受的任何值。

.TP
pathName configure ?option? ?value option value ...? 
查询或修改这个组件的配置选项。如果未指定 option ，则返回描述 pathName 的所有可获得的选项的一个列表。如果指定了不带 value 的 option，则这个命令返回描述这个指名的 option 的一个列表(这个列表与未指定 option 所返回的值的相应的子集是一样的)。如果指定了一个或多个选项-值 对，则这个命令把给定的组件选项修改为给定的值；在这种情况下这个命令返回一个空串。Option 可以是能被建立命令接受的任何值。只读选项不可修改。

.TP
pathName getframe  
返回用户窗口的路径名。

.TP
pathName getindicator index  
返回第 index 次增加的指示器。 

.TP
pathName getmenu menuid  
返回 id 是 menuid 的菜单的路径名。 

.TP
pathName gettoolbar index  
返回第 index 次增加的工具条的路径名。 

.TP
pathName setmenustate tag state  
把有标签 tag 的所有菜单项的 -state 选项的值设置成 state。 

.TP
pathName showstatusbar name  
name 是 none、status 或 progression 之一。使用 none 来隐藏状态条，用 status 来只显示标签(label)，或用 progression 来显示标签和进度条。 

.TP
pathName showtoolbar index bool  
如果 bool 是 0 则隐藏第 index 次增加的工具条，如果 bool 是 1 则显示第 index 次增加的工具条。要防止你的顶层窗口在隐藏/显示工具条期间调整大小，在操纵(manage)它的时候做 [wm geometry $top [wm geometry $top]] 。


.SH "[中文版维护人]"
.B 寒蝉退士
.SH "[中文版最新更新]"
.B 2001/05/06
.SH "《中国 Linux 论坛 man 手册页翻译计划》:"
.BI http://cmpp.linuxforum.net
