'\"
'\" Copyright (c) 1998 Sun Microsystems, Inc.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" RCS: @(#) $Id: regexp.n,v 1.2 2003/11/24 05:09:59 bbbush Exp $
'\" 
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: regexp.n,v 1.2 2003/11/24 05:09:59 bbbush Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 5.5c 11c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH regexp n 8.3 Tcl "Tcl Built-In Commands"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
regexp \- 针对一个字符串匹配一个正则表达式

.SH "总览 SYNOPSIS"
\fBregexp \fR?\fIswitches\fR? \fIexp string \fR?\fImatchVar\fR? ?\fIsubMatchVar subMatchVar ...\fR?
.BE

.SH "描述 DESCRIPTION"
.PP
确定正则表达式 \fIexp\fR 是否匹配部分或全部 \fIstring\fR，在未指定 \fB-inline\fR (参见后面)的时候，如果匹配则返回 1，否则返回 0。(正则表达式匹配的描述请参见 \fBre_syntax\fR 参考页。)
.LP
如果在 \fIstring\fR 之后指定了补充的参数，则把它们作为变量的名字对待，把关于 \fIstring\fR 中匹配 \fIexp \fR的那部分的信息返回到其中。\fIMatchVar\fR 将被设置为匹配全部 \fIexp \fR的 \fIstring \fR的范围。第一个\fIsubMatchVar\fR 将包含与 \fIexp \fR中最左的圆括号中的子表达式相匹配的 \fIstring\fR 中那部分字符，下一个 \fIsubMatchVar\fR 将包含与\fIexp \fR中从左到右的下一个圆括号中的子表达式相匹配的 \fIstring\fR 中那部分字符，以此类推。
.PP
如果给 \fBregexp\fR 的初始的参数以 \fB-\fR 为开始，则它们被作为开关来对待。当前支持下列开关:
.TP 15
\fB\-about\fR
不再尝试匹配正则表达式，返回包含关于正则表达式信息的一个列表。列表的第一个元素是子表达式计数。第二个元素是描述正则表达式各种特性的属性名的一个列表。这个开关主要用于调试目的。
.TP 15
\fB\-expanded\fR
启用展开的(expanded)正则表示式语法，将忽略白空格和注释。这与指定 \fB(?x)\fR 嵌入选项相同。(see METASYNTAX, below).
.TP 15
\fB\-indices\fR
改变在 \fIsubMatchVar\fR 中存储的内容。不再存储 \fIstring \fR中匹配的字符串，每个变量将包含两个十进制字符串组成的一个列表，它们给出匹配的字符范围中的第一个和最后一个字符在     \fIstring\fR 中的索引 。
.TP 15
\fB\-line\fR
启用换行敏感匹配。缺省的，换行是没有特殊意义的一个完全的普通字符。加上了这个标志，‘[^’ 方括号表达式和‘.’将永不匹配换行，‘^’除了它的正常功能之外还匹配在任何换行之后的空串，而‘$’除了它的正常功能之外还匹配在任何换行之前的空串。这个标志等价于指定 \fB-linestop\fR 和 \fB-lineanchor \fR二者，或者 \fB(?n)\fR 嵌入选项。 (see METASYNTAX, below).
.TP 15
\fB\-linestop\fR
改变‘[^’方括号表达式和‘.’的行为，这样表示式将停止于换行。这与指定 \fB(?p)\fR 嵌入选项相同。 (see METASYNTAX, below).
.TP 15
\fB\-lineanchor\fR
改变‘^’和‘$’(“锚”)的行为，这样它们分别的匹配一行的开始和结束。这与指定 \fB(?w)\fR 嵌入选项相同。 (see METASYNTAX, below).
.TP 15
\fB\-nocase\fR
导致在匹配处理中把 \fIstring\fR 中的大写字符与小写字符同样对待。
.VS 8.3
.TP 15
\fB\-all\fR
导致尽字符串中可能的次数去匹配正则表达式，返回发现的匹配总数。如果一起指定的还有匹配变量，它们将只保持最后的匹配。
.TP 15
\fB\-inline\fR
导致命令把原先要放置到匹配变量中的数据作为一个列表返回。当使用 \fB-inline\fR 的时候，不可以指定匹配变量。如果还使用了 \fB-all\fR，在每次重复操作(iteration)时串联列表，这样将总是返回一个平坦的列表。对于每次匹配的重复操作，这个命令将添加整体的匹配数据，为正则表达式中的每个子表达式加上一个元素。例如:
.CS
    regexp -inline -- {\\w(\\w)} " inlined "
 => {in n}
    regexp -all -inline -- {\\w(\\w)} " inlined "
 => {in n li i ne e}
.CE
.TP 15
\fB\-start\fR \fIindex\fR
在字符串中指定一个字符索引，在这个偏移量上开始匹配。当使用了这个开关的时候，‘^’将不匹配行的开始，而     \A 将仍旧在 \fIindex \fR上匹配字符串的开始。如果指定了 \fB-indices\fR，编制索引将以输入字符串的绝对开始为起始。\fIindex\fR     将被约束为输入字符串的束缚。
.VE 8.3
.TP 15
\fB\-\|\-\fR
标记开关的结束。这个标志之后的参数即使以 \fB- \fR为开始仍被作为 \fIexp\fR 对待。
.PP
如果 \fIsubMatchVar\fR 比 \fIexp\fR 中的圆括号中的子表达式多，或者在 \fIexp\fR 中的一个特定子表达式不匹配字符串。(比如，因为它是不被匹配的子表达式的一部分), 则在指定了 \fB-indices\fR 的时候，相应\fIsubMatchVar\fR 将被设置成``\fB\-1 \-1\fR''，其他时候被设置成空串。

.SH "参见 SEE ALSO"
re_syntax(n), regsub(n)

.SH "关键字 KEYWORDS"
match, regular expression, string

.SH "[中文版维护人]"
.B 寒蝉退士
.SH "[中文版最新更新]"
.B 2001/10/27
.SH "《中国 Linux 论坛 man 手册页翻译计划》:"
.BI http://cmpp.linuxforum.net
