<?php

/*
 * PHP-RSS20 version 1.0
 * Copyright (c)2004 LEMOINE Christophe - Licence GNU/GPL
 * christophe.lemoine1@tiscali.fr
 *
 * 'PHP-RSS20' est un script permettant de gnrer des flux RSS conforme  partir
 * de tous autres scripts PHP. Le modle XML respecte la version 1.0 et un encodage
 * UTF8. Le RSS respecte la version 2.0.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/*
 * Classe primaire
 *
 * Cre la structure du flux et renseigne les lments et paramtres optionnels
 *
 */
class rssChannel
{

	var $feed;
    	var $beginFeed;
	var $endFeed;
	var $fTitle;
	var $fDescription;
	var $fLink;
	var $fLanguage;
	var $fCopyright;
	var $fEditor;
	var $fWebmaster;
	var $fPubdate;
	var $fLastbuiltdate;
	var $fCategory;
	var $fGenerator;
	var $fTtl;
	var $fImage;
	var $fItem;

    /*
     * Convertit les caractres & en son code html &amp;
     * Convertit les codes html <br> au format xhtml <br />
     * Convertit les signes < en leur code html &lt;
     * Convertit les signes > en leur code html &gt;
     *
     */
    function Convert($text)
    {
    	$t = str_replace("&", '&amp;', $text);
    	$t = str_replace("<br>", "<br />", $t);
    	$t = str_replace("<", "&lt;", $t);
    	$t = str_replace(">", "&gt;", $t);
    	return $t;
    }

    /*
     * Initialise les variables o seront stockes les valeurs des paramtres
     * et du corps du flux RSS.
     *
     */
    function rssChannel()
    {
    	$this->feed = '';
    	$this->beginFeed = '<?xml version="1.0" encoding="UTF-8" ?>';
    	$this->beginFeed .= '<rss version="2.0">';
        $this->beginFeed .= '<channel>';
    	$this->endFeed = '</channel>';
        $this->endFeed .= '</rss>';
        $this->fLanguage = '';
        $this->fCopyright = '';
        $this->fEditor = '';
        $this->fWebmaster = '';
        $this->fPubdate = date('r', time());
        $this->fLastbuiltdate = date('r', time());
        $this->fCategory = '';
        $this->fTtl = 0;
        $this->fImage = array();
        $this->fItem = array();
    }
    
    /*
     * Mmorise le titre du flux
     *
     */
    function feedTitle($value)
    {
    	$this->fTitle = utf8_encode($this->Convert(trim($value)));
    }
    
    /*
     * Mmorise la description du flux
     *
     */
    function feedDescription($value)
    {
    	$this->fDescription = utf8_encode($this->Convert(trim($value)));
    }
    
    /*
     * Mmorise le lien direct du flux (gnralement le site internet en rapport)
     *
     */
    function feedLink($value)
    {
    	$this->fLink = utf8_encode(trim($value));
    }
    
    /*
     * Mmorise le language utilis par le flux (format ISO-639)
     *
     */
    function feedLanguage($value)
    {
    	$this->fLanguage = trim($value);
    }
    
    /*
     * Mmorise le copyright attach  ce flux
     *
     */
    function feedCopyright($value)
    {
    	$this->fCopyright = utf8_encode($this->Convert(trim($value)));
    }
    
    /*
     * Mmorise l'adresse email de la personne charge de la publication
     *
     */
    function feedEditor($value)
    {
    	$this->fEditor = utf8_encode($this->Convert(trim($value)));
    }
    
    /*
     * Mmorise l'adresse email de la personne charge du cot technique
     *
     */
    function feedWebmaster($value)
    {
    	$this->fWebmaster = utf8_encode(trim($value));
    }
    
    /*
     * Mmorise la date  laquelle ce flux a t publi (format RFC-822)
     *
     */
    function feedPubdate($value)
    {
    	$this->fPubdate = @date('r', (int) $value);
    }
    
    /*
     * Mmorise la date  laquelle ce flux a t modifi (format RFC-822)
     *
     */
    function feedLastbuiltdate($value)
    {
    	$this->fLastbuiltdate = @date('r', (int) $value);
    }
    
    /*
     * Mmorise la catgorie se rapportant au thme du flux
     *
     */
    function feedCategory($value)
    {
    	$this->fCategory = utf8_encode($this->Convert(trim($value)));
    }
    
    /*
     * Mmorise le nom de l'application ayant gnre ce flux
     *
     */
    function feedGenerator($value)
    {
    	$this->fGenerator = utf8_encode($this->Convert(trim($value)));
    }
    
    /*
     * Mmorise le nombre de minutes durant lesquelles le lecteur RSS peut garder
     * ce flux dans sa mmoire cache.
     *
     */
    function feedTtl($value)
    {
    	$this->fTtl = (int) $value;
    }
    
    /*
     * Ajoute une image au flux suivant son url (complte), un titre (fonctionnalit
     * alt="" en html), le lien du site internet l'hbergeant, ainsi qu'optionnelemnt
     * la taille en longueur et hauteur (respectivement de 88  144 pour la largeur
     * et de 31  400 pour la hauteur)
     *
     */
    function feedImage($url, $title, $link, $width = 88, $height = 31)
    {
    	if ($width < 88) { $width = 88; }
    	if ($height < 31) { $height = 31; }
    	if ($width > 144) { $width = 144; }
    	if ($height > 400) { $height = 400; }
    	if (strlen(trim($title)) > 0 && strlen(trim($url)) > 0 && strlen(trim($link)) >0)
        {
        	$this->fImage[0] = utf8_encode(trim($url));
        	$this->fImage[1] = utf8_encode($this->Convert(trim($title)));
        	$this->fImage[2] = utf8_encode(trim($link));
        	$this->fImage[3] = (int) $width;
        	$this->fImage[4] = (int) $height;
        }
    }
    
    /*
     * Ajoute un lment au flux RSS (lment ' <item> ')
     *
     */
    function AddItem($value)
    {
    	if (!$value) { return false; exit(); }
   		$this->fItem[count($this->fItem)] = $value;
   		return true;
    }
    
    /*
     * Met en forme le flux RSS pour un affichage ou un enregistrement futur.
     *
     */
    function Create()
    {
    	if ($this->fTitle == '') { return false; exit(); }
    	if ($this->fDescription == '') { return false; exit(); }
    	if ($this->fLink == '') { return false; exit(); }
    	$this->feed = $this->beginFeed;
    	$this->feed .= '<docs>http://blogs.law.harvard.edu/tech/rss</docs>';
    	$this->feed .= '<title>'.$this->fTitle.'</title>';
    	$this->feed .= '<description>'.$this->fDescription.'</description>';
    	$this->feed .= '<link>'.$this->fLink.'</link>';
    	if (strlen($this->fLanguage) > 0) { $this->feed .= '<language>'.$this->fLanguage.'</language>'; }
    	if (strlen($this->fCopyright) > 0) { $this->feed .= '<copyright>'.$this->fCopyright.'</copyright>'; }
    	if (strlen($this->fEditor) > 0) { $this->feed .= '<managingEditor>'.$this->fEditor.'</managingEditor>'; }
    	if (strlen($this->fWebmaster) > 0) { $this->feed .= '<webMaster>'.$this->fWebmaster.'</webMaster>'; }
    	if (strlen($this->fPubdate) > 0) { $this->feed .= '<pubDate>'.$this->fPubdate.'</pubDate>'; }
    	if (strlen($this->fLastbuiltdate) > 0) { $this->feed .= '<lastBuildDate>'.$this->fLastbuiltdate.'</lastBuildDate>'; }
    	if (strlen($this->fCategory) > 0) { $this->feed .= '<category>'.$this->fCategory.'</category>'; }
        if (strlen($this->fGenerator) > 0) { $this->feed .= '<generator>'.$this->fGenerator.'</generator>'; }
        if (strlen($this->fTtl) > 0) { $this->feed .= '<ttl>'.$this->fTtl.'</ttl>'; }
        if (count($this->fImage) == 5)
        {
        	$this->feed .= '<image>';
        	$this->feed .= '<url>'.$this->fImage[0].'</url>';
        	$this->feed .= '<title>'.$this->fImage[1].'</title>';
        	$this->feed .= '<link>'.$this->fImage[2].'</link>';
        	$this->feed .= '<width>'.$this->fImage[3].'</width>';
        	$this->feed .= '<height>'.$this->fImage[4].'</height>';
        	$this->feed .= '</image>';
        }
        if (count($this->fItem) > 0)
        {
        	for ($n = 0; $n < count($this->fItem); $n++)
        	{
        		$this->feed .= $this->fItem[$n];
        	}
        }
    	$this->feed .= $this->endFeed;
    	return true;
    }
    
    /*
     * Enregistre le flux mis en forme dans un fichier pass en paramtre
     *
     */
    function Save($Filename)
    {
    	if (@file_exists($Filename)) { @unlink($Filename); }
    	$fp = @fopen($Filename, 'w+');
    	if (!$fp) { return false; exit(); }
    	fwrite($fp, $this->feed);
    	fclose($fp);
    	return true;
    }
    
    /*
     * Renvoi sur la fentre du naviguateur le contenu du flux RSS mis en forme.
     *
     */
    function Show()
    {
    	header('Content-type: text/xml');
        echo $this->feed;
    }

}

/*
 * Classe secondaire
 *
 * Cre la structure d'un lment ' <item> '
 *
 */
class rssItem
{

	var $item;
	var $beginItem;
	var $endItem;
	var $iTitle;
	var $iDescription;
	var $iLink;
	var $iAuthor;
	var $iCategory;
	var $iComments;
	var $iEnclosure;
	var $iGuid;
	var $iPubdate;
	var $iSource;

    /*
     * Convertit les caractres & en son code html &amp;
     * Convertit les codes html <br> au format xhtml <br />
     * Convertit les signes < en leur code html &lt;
     * Convertit les signes > en leur code html &gt;
     *
     */
    function Convert($text)
    {
    	$t = str_replace("&", '&amp;', $text);
    	$t = str_replace("<br>", "<br />", $t);
    	$t = str_replace("<", "&lt;", $t);
    	$t = str_replace(">", "&gt;", $t);
    	return $t;
    }

	function rssItem()
	{
		$this->beginItem = '<item>';
		$this->endItem = '</item>';
		$this->Clean();
	}
	
	function Clean()
	{
		$this->item = '';
		$this->iTitle = '';
		$this->iDescription = '';
		$this->iLink = '';
		$this->iAuthor = '';
		$this->iCategory = '';
		$this->iComments = '';
		$this->iEnclosure = array();
		$this->iGuid = '';
		$this->iPubdate = date('r', time());
		$this->iSource = array();
	}
    
    /*
     * Mmorise le titre de l'lmnt
     *
     */
	function itemTitle($value)
	{
		$this->iTitle = utf8_encode($this->Convert(trim($value)));
	}
    
    /*
     * Mmorise la description de l'lmnt
     *
     */
	function itemDescription($value)
	{
		$this->iDescription = utf8_encode($this->Convert(trim($value)));
	}
    
    /*
     * Mmorise l'url direct en rapport avec cet l'lmnt
     *
     */
	function itemLink($value)
	{
		$this->iLink = utf8_encode(trim($value));
	}
    
    /*
     * Mmorise le nom de l'auteur de cet l'lmnt
     *
     */
	function itemAuthor($value)
	{
		$this->iAuthor = utf8_encode($this->Convert(trim($value)));
	}
    
    /*
     * Mmorise la catgorie se rapportant au thme de cet lment
     *
     */
	function itemCategory($value)
	{
		$this->iCategory = utf8_encode($this->Convert(trim($value)));
	}

        
    /*
     * Mmorise l'url de la page internet commentant cet lment
     *
     */
	function itemComments($value)
	{
		$this->iComments = utf8_encode($this->Convert(trim($value)));
	}
    
    /*
     * Mmorise une chaine de caractre identifiant cet lment de manire unique
     *
     */
	function itemGuid($value)
	{
		$this->iGuid = utf8_encode(trim($value));
	}
    
    /*
     * Mmorise la date de publication de cet lment (format RFC-822)
     *
     */
    function itemPubdate($value)
    {
    	$this->iPubdate = @date('r', (int) $value);
    }

    
    /*
     * Mmorise l'url et le nom du fichier XML, source de cet lment
     *
     */
	function itemSource($url, $title)
	{
    	if (strlen(trim($url)) > 0 && strlen(trim($title)) > 0)
        {
        	$this->iSource[0] = utf8_encode(trim($url));
            $this->iSource[1] = utf8_encode($this->Convert(trim($title)));
        }
	}

    /*
     * Ajoute un mdia  cet lment suivant son url (complte), sa taille xacte en octets
     * ainsi que son type MIME (type exact)
     *
     */
	function itemEnclosure($url, $length, $type)
	{
    	if ($length <= 0) { $length = 0; }
    	if (strlen(trim($url)) > 0 && strlen(trim($type)) > 0)
        {
        	$this->iEnclosure[0] = utf8_encode(trim($url));
        	$this->iEnclosure[1] = utf8_encode(trim($type));
        	$this->iEnclosure[2] = (int) $length;
        }
	}
    
    /*
     * Met en forme l'lment et le renvoie
     *
     */
    function Create()
    {
    	if ($this->iTitle == '') { return false; exit(); }
    	if ($this->iDescription == '') { return false; exit(); }
    	if ($this->iLink == '') { return false; exit(); }
    	$this->item = $this->beginItem;
    	$this->item .= '<title>'.$this->iTitle.'</title>';
    	$this->item .= '<description>'.$this->iDescription.'</description>';
    	$this->item .= '<link>'.$this->iLink.'</link>';
    	if (strlen($this->iAuthor) > 0) { $this->item .= '<author>'.$this->iAuthor.'</author>'; }
        if (strlen($this->iCategory) > 0) { $this->item .= '<category>'.$this->iCategory.'</category>'; }
        if (strlen($this->iComments) > 0) { $this->item .= '<comments>'.$this->iComments.'</comments>'; }
        if (strlen($this->iGuid) > 0) { $this->item .= '<guid isPermaLink="false">'.$this->iGuid.'</guid>'; }
    	if (strlen($this->iPubdate) > 0) { $this->item .= '<pubDate>'.$this->iPubdate.'</pubDate>'; }
        if (count($this->iSource) == 2) { $this->item .= '<source url="'.$this->iSource[0].'">'.$this->iSource[1].'</source>'; }
        if (count($this->iEnclosure) == 3) { $this->item .= '<enclosure url="'.$this->iEnclosure[0].'" length="'.$this->iEnclosure[2].'" type="'.$this->iEnclosure[1].'" />'; }
    	$this->item .= $this->endItem;
    	return $this->item;
    }

}

?>
