<?php
/**
 * MantisBT is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 * 
 * MantisBT is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with MantisBT.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

/**
 * Debian MantisBT installer
 * 
 * To allow all MantisBT db_types on debian installation this page it was 
 * was rewritten to offer compatibility with more databases and the  
 * compatibilty with debconf file config_inc which is used by debian.
 * Upstream had development this page to ensure that the new installations and 
 * upgrades are controlled from the source an this schema files, which it depends on a 
 * diferent MantisBT funcionalities setting by users. The code it is growing up
 * very hard then it is necessary that the upgrades options will work perfect 
 * on each configuration, the only way to ensure that works fine as expected by
 * upstream releases is relating to the upstream scripts to install or upgrade
 * databases.   
 * 
 */

/**
 * @package MantisBT
 * @copyright Copyright (C) 2000 - 2002  Kenzaburo Ito - kenito@300baud.org
 * @copyright Copyright (C) 2002 - 2010  MantisBT Team - mantisbt-dev@lists.sourceforge.net
 * @copyright Copyright (C) 2011 - 2011  Silvia Alvarez - sils@powered-by-linux.com
 * @link http://www.mantisbt.org
 */

/****
* TODO Debian
* Now db2 installation is blocked on new installations
* To implement this option is necessary to test it.
*/

error_reporting ( E_ALL );

/** @todo put this somewhere */
set_time_limit ( 0 );

$g_skip_open_db = true; // don't open the database in database_api.php

define ( 'MANTIS_INSTALLER', true );
define ( 'PLUGINS_DISABLED', true ); //checkings

require_once (dirname ( dirname ( __FILE__ ) ) . DIRECTORY_SEPARATOR . 'core.php');
require_once ('install_functions.php');
require_once ('install_helper_functions.php');

$g_error_send_page_header 	= TRUE; // bypass page headers in error handler //CHANGE
$g_failed 					= false;
 
/**************************
 * CHECKING NEW OR UPGRADE
 */
$g_database_upgrade 		= false;

//check if config_inc.php exists
$t_config_filename = $g_absolute_path . 'config_inc.php';
$t_config_exists = file_exists( $t_config_filename );

if ($t_config_exists){
		
	// config already exists - check for new install or upgrade
	$f_dsn 				= config_get( 'dsn', '' ); //used for other than mysql, mysqli, pgsql
	$f_hostname 		= config_get( 'hostname', '' );
	$f_hostname 		= ($f_hostname=="") ? "localhost" : $f_hostname; //assuming localhost when is blank
	$f_db_type 			= config_get( 'db_type', '' );
	$f_database_name 	= config_get( 'database_name', '' );
	$f_db_username 		= config_get( 'db_username', '' );
	$f_db_password 		= config_get( 'db_password', '' );		
		
	//test if database exists else assuming a new installation
	$g_db = ADONewConnection( $f_db_type );
	$t_result = @$g_db->Connect( $f_hostname, $f_db_username, $f_db_password, $f_database_name );
	if( $g_db->IsConnected() ) { $g_db_connected = true; }
	
	if($g_db_connected == true){
		//if connection true - assuming upgrade	
		$g_database_upgrade = true;
	}else{
		//if connection false - assuming new install		
	}
} else {
	// the user had change something 
	// not debian installation at all, probably
	// assuming new - the user may know what is he doing 
}

//print test result
function print_test_result($p_result, $p_hard_fail = true, $p_message = '') {
	global $g_failed;
	echo '<td width="60%" ';
	if (BAD == $p_result) {
		if ($p_hard_fail) { $g_failed = true; echo 'bgcolor="red">BAD';	} else { echo 'bgcolor="pink">POSSIBLE PROBLEM'; }
		if ('' != $p_message) { 	echo '<br />' . $p_message;	}
	}
	
	if (GOOD == $p_result) { echo 'bgcolor="green">GOOD'; }
	echo '</td>';
}

// -------
// print test header and result
function print_test($p_test_description, $p_result, $p_hard_fail = true, $p_message = '') {
	echo "\n<tr><td width=\"60%\" bgcolor=\"#ffffff\">$p_test_description</td>";
	print_test_result ( $p_result, $p_hard_fail, $p_message );
	echo "</tr>\n";
}

// --------
// create an SQLArray to insert data
function InsertData($p_table, $p_data) {
	$query = "INSERT INTO " . $p_table . $p_data;
	return Array ($query );
}

// install_state
//   0 = no checks done
//   1 = server ok, get database information
//   2 = check the database information
//   3 = install the database
//   4 = write the config file
//	 5 = post install checks
//	 6 = installation complete

//set default state and eval returned values
$t_install_state = gpc_get_int ( 'install', 0 );

//get returned values and set defaults
//to work around without config_file and 
//make a new installation
$t_config_exists 	= false;
$f_log_queries 		= false;
$f_db_exists 		= false;
$f_db_schema 		= ''; //para DB2


if($g_database_upgrade == true){

	//vars from config file
	$f_dsn 				= $f_dsn;
	$f_hostname 		= $f_hostname;
	$f_database_name 	= $f_database_name;
	$f_db_username 		= $f_db_username;
	$f_db_password 		= $f_db_password;
	
	$f_db_type 			= $f_db_type;
	if ($f_db_type == 'db2') {
		// If schema name is supplied, then separate it from database name.
		if (strpos ( $f_database_name, '/' ) != false) {
			$f_db2AS400 = $f_database_name;
			list ( $f_database_name, $f_db_schema ) = explode ( '/', $f_db2AS400, 2 );
		}
	}	
	
	//for upgrade option is needed superadmin
	$f_admin_username 	= (isset($_POST["admin_username"]) ) 	? $_POST["admin_username"] 	: "root";
	$f_admin_password 	= (isset($_POST["admin_password"]) ) 	? $_POST["admin_password"] 	: "";	
	
}else{
	
	$f_hostname 		= (isset($_POST["hostname"]) ) 			? $_POST["hostname"] 		: "localhost";
	$f_admin_username 	= (isset($_POST["admin_username"]) ) 	? $_POST["admin_username"] 	: "root";
	$f_admin_password 	= (isset($_POST["admin_password"]) ) 	? $_POST["admin_password"] 	: "";
	$f_database_name 	= (isset($_POST["database_name"]) ) 	? $_POST["database_name"] 	: "mantis";
	$f_db_username 		= (isset($_POST["db_username"]) ) 		? $_POST["db_username"] 	: "mantis_user";
	$f_db_password 		= (isset($_POST["db_password"]) ) 		? $_POST["db_password"] 	: "";

	$f_g_administrator_email 	= (isset($_POST["g_administrator_email"]) AND $_POST["g_administrator_email"]!="" ) ? $_POST["g_administrator_email"]	: "root@localhost";
	$f_g_webmaster_email 		= (isset($_POST["g_webmaster_email"]) ) ? $_POST["g_webmaster_email"]	: "root@localhost";
	$f_db_admin_mantis_password = (isset($_POST["db_admin_mantis_password"]) ) ? $_POST["db_admin_mantis_password"]	: "root";
	
	$f_db_type 			= (isset($_POST["db_type"]) ) ? $_POST["db_type"] : "mysql";
	if ($f_db_type == 'db2') {
		// If schema name is supplied, then separate it from database name.
		if (strpos ( $f_database_name, '/' ) != false) {
			$f_db2AS400 = $f_database_name;
			list ( $f_database_name, $f_db_schema ) = explode ( '/', $f_db2AS400, 2 );
		}
	}
	
}

//user confirm
$user_confirm_debian = (isset($_POST["user_confirm_debian"]) AND $_POST["user_confirm_debian"]==1) ? ""	: $t_install_state=0;

//settings for message errors
$error_go_back		= " <a href='install.php' onclick='javascript:history.go(-1);'>GO BACK </a>";
$cheking_system 	= "Please check your system installation and return to this page in order to continue with your installation.";
$cheking_db_values 	= "Please go back and review the errors in order to continue. $error_go_back";

?>

<html>
<head>
<title>MantisBT Administration - Installation</title>
<link rel="stylesheet" type="text/css" href="admin.css" />
</head>
<body>

<!-- BEGIN HEADER PAGE -->
<table width="100%" border="0" cellspacing="0" cellpadding="0" bgcolor="#ffffff">
	<tr class="top-bar">
		<td class="links"> </td>
		<td class="title">
		<?php
		switch ($t_install_state) {
			case 6 : echo "Installation Complete"; break;
			case 5 : echo "Post Installation Checks"; break;
			case 4 : echo "Install Configuration File"; break;
			case 3 : echo "Install Database"; break;
			case 2 : echo "Check and Install Database"; break;
			case 1 : echo "Database Parameters"; break;
			case 0 :
			default: echo "Pre-Installation Check"; break;
		}
		?>
		</td>
	</tr>
</table>
<br />
<!-- END HEADER PAGE -->

<!-- BEGIN INSTALL ADVICE -->
<?php if (0 == $t_install_state OR 1 == $t_install_state ) { ?>
<table width="100%" bgcolor="#f1dfae" border="0" cellpadding="10" cellspacing="1">
	<tr>
		<td align="left" style="pading-left:20px">
			<b>README FIRST</b><br />
			Read this notes carefully before you install or upgrade your database. 
			Remember you have all needed information on your local system /usr/share/doc/mantis/ <br /><br />
			
			<b>NEW INSTALLATION</b><br />
			* <u>Database collation "UTF-8"</u>: releases Mantis 1.1.a2 and avobe now uses UTF-8 encoding by default on language files and encoding for database saved and read from the database.<br />
				The script installation set up the encoding UTF-8 for your new databases.<br />
				Be aware if you are using <b>non-Latin characters</b> on your database configuration and do not install before you ensure that will be work on your system.
			<br />
			* <u>User custom configuration</u>: debian installation creates a custom file config_local.php, instead of editing config_inc.php directly. Everything you set on 
			this file has precedence over settings defined in the config_inc.php
			<br /><br />
			
			<b>UPGRADE INSTALLATION</b><br />
			
			* <u>Backup before upgrading:</u> - <b>Always backup your database data before upgrading</b> <br />
			* <u>Database collation "UTF-8"</u>: releases Mantis 1.1.a2 and avobe now uses UTF-8 encoding by default on language files and encoding for database saved and read from the database.<br />
			The script installation set up the encoding UTF-8 just for the newest creation information, do not update existing.<br />
			<b>It highly recommended convert to UTF-8 your data information before upgrade.</b> <br />
			Read this information: <a href="http://www.mantisbt.org/wiki/doku.php/mantisbt:upgrade_to_utf8">Upgrading to a Mantis UTF8</a><br />
			Be aware if you are using <b>non-Latin characters</b> on your database configuration and do not install before you ensure that will be work on your system.
			<br />
			* <u>User custom configuration</u>: debian installation maintains a custom file config_local.php, instead of editing config_inc.php directly. Everything you set on 
			this file has precedence over settings defined in the config_inc.php <br />
			* <u>Upgrading:</u>: Upgrades may take several minutes depending on the size of your database.
			<br /><br />
			
			<span style="color:red">Warning: When you finish the installation or upgrade process is is highly recommended to delete the admin directory.</span>
			
		</td>
	</tr>
</table>
<br />
<?php } ?>
<!-- /END INSTALL ADVICE -->

<!--  BEGIN INSTALL STATE 0 -->
<?php 
//install_state == 0
if (0 == $t_install_state) { ?>

<table width="100%" bgcolor="#222222" border="0" cellpadding="10" cellspacing="1">
	<tr>
		<td bgcolor="#e8e8e8" colspan="2"><span class="title">Checking Installation...</span></td>
	</tr>
	<!-- Check PHP Version -->
	<?php print_test ( ' Checking PHP version (your version is ' . phpversion () . ')', check_php_version ( phpversion () ), true, 'Upgrade to a more recent version of PHP' ); ?>
	<!-- Check Safe Mode -->
	<?php print_test ( 'Checking if safe mode is enabled for install script', ! ini_get ( 'SAFE_MODE' ), true, 'Disable safe_mode in php.ini before proceeding' ) ?>
	
	<!--  Check Upgrade Mode -->
	<?php if( $g_database_upgrade == true ) {
		print_test( 'Setting Database Type', '' !== $f_db_type, true, 'database type is blank?' );
		print_test( 'Checking Database connection settings exist', ( $f_dsn !== '' || ( $f_database_name !== '' && $f_db_username !== '' && $f_hostname !== '' ) ), true, 'database connection settings do not exist?' );
		print_test( 'Checking PHP support for database type', db_check_database_support( $f_db_type ), true, 'database is not supported by PHP. Check that it has been compiled into your server.' );
		} 
	?>
</table>

<?php 
	//do not allow to continue if checking if not passed
	if( $g_database_upgrade == true ) {
		if ( ! ini_get( 'SAFE_MODE' ) AND check_php_version( phpversion ())==1 AND ('' !== $f_db_type) AND ( $f_dsn !== '' || ( $f_database_name !== '' && $f_db_username !== '' && $f_hostname !== '' ) ) AND db_check_database_support( $f_db_type ) ){  } else { echo $cheking_system ; exit; }
	}else{
		if ( ! ini_get( 'SAFE_MODE' ) AND check_php_version( phpversion ())==1 ){  } else { echo $cheking_system ; exit; }	
	}
?>
<br />

<form name="installation" action="install.php" method="POST">
<input name="install" value="2" type="hidden">
<table width="100%" border="0" cellpadding="10" cellspacing="1">
<tr>
	<td colspan="2" bgcolor="#e8e8e8"><span class="title">Installation Options</span></td>
</tr>
<tr>
	<td>Type of Database</td>
	<td>
		<?php if($g_database_upgrade == true){ ?>
			<?php echo $f_db_type ?>
			<input type="hidden" name="db_type" value="<?php echo $f_db_type?>">
		<?php }else{?>
		<select name="db_type">
		<?php
		if ($f_db_type == 'mysql') {
			echo '<option value="mysql" selected="selected">MySql (default)</option>';
		} else {
			echo '<option value="mysql">MySql (default)</option>';
		}
		
		if ($f_db_type == 'mysqli') {
			echo '<option value="mysqli" selected="selected">MySqli</option>';
		} else {
			echo '<option value="mysqli">MySqli</option>';
		}
		
		if ($f_db_type == 'pgsql') {
			echo '<option value="pgsql" selected="selected">PGSQL (experimental)</option>';
		} else {
			echo '<option value="pgsql">PGSQL (experimental)</option>';
		}
		
		if ($f_db_type == 'oci8') {
			echo '<option value="oci8" selected="selected">Oracle - oci8 (experimental)</option>';
		} else {
			echo '<option value="oci8">Oracle - oci8 (experimental)</option>';
		}
		
		/************
		 * TODO
		 * allow db2 databases
		 * not allowed on new installation
		 */
		/*
		if ($f_db_type == 'db2') {
			echo '<option value="db2" selected="selected">db2/400 (experimental)</option>';
		} else {
			echo '<option value="db2">db2/400 (experimental)</option>';
		}*/
		
		?>
		</select>		
		
		<?php }?>
	</td>
</tr>

<?php if($g_database_upgrade == true){ ?>
<tr>
	<td>Database Administrative Username (to upgrade Database)</td> <td><input name="admin_username" value="<?php echo $f_admin_username  ?>" type="textbox"></td>
</tr>
<tr>
	<td>Database Administrative Password (to upgrade Database)</td> <td><input name="admin_password" value="" type="password"></td>
</tr>
<?php }else{?>
<tr>
	<td>Hostname (for Database Server)</td>	<td><input name="hostname" value="localhost" type="textbox"></td>
</tr>
<tr>
	<td>Database Administrative Username (to create Database)</td> <td><input name="admin_username" value="<?php echo $f_admin_username  ?>" type="textbox"></td>
</tr>
<tr>
	<td>Database Administrative Password (to create Database)</td> <td><input name="admin_password" value="" type="password"></td>
</tr>
<tr>
	<td>System Administrative Email (to maintanance)<br />In case you install mysql,mysqli,pgsql. 
	This email it will set for administrative actions </td> <td><input name="g_administrator_email" value="<?php echo $f_g_administrator_email?>" type="textbox"></td>
</tr>

<tr>
	<td colspan="2"> </td>
</tr>

<tr>
	<td>Database name (for Database)</td> <td><input name="database_name" value="<?php echo $f_database_name?>" type="textbox"></td>
</tr>

<tr>
	<td>Username (for Mantis Database)</td> <td><input name="db_username" value="<?php echo $f_db_username?>" type="textbox"></td>
</tr>
<tr>
	<td>Password (for Mantis Database)</td> <td><input name="db_password" value="" type="password"></td>
</tr>
<tr bgcolor="#eaeaea">
	<td colspan="2">
	By default, the mantis package creates an 'administrator' account. <br />
	The email  for this account is '<?php echo $f_g_webmaster_email?>'.<br />
	The password  for this account is 'root'.<br />
	On this installation, if you chooise a Type of Database: mysql, mysqli, pgsql, you would be able to set another password and email using this form.<br />
	In other cases, the password will be the default.
	</td>
</tr>
<tr>
	<td>Change default email for Mantis 'administrator' account <br /> (just available for mysql,mysqli,pgsql)</td> 
	<td><input name="g_webmaster_email" value="<?php echo $f_g_webmaster_email?>" type="textbox"></td>
</tr>
<tr>
	<td>Change default password for Mantis 'administrator' account <br /> (just available for mysql,mysqli,pgsql)</td> 
	<td><input name="db_admin_mantis_password" value="<?php echo $f_db_admin_mantis_password?>" type="password"></td>
</tr>
<?php }?>
<tr bgcolor="#fbd9d9">
	<td>Have you read the Installation notes, including NEWS.Debian and 
	  verify if you Database are compatible with UTF-8 (needed to create or upgrade mantis Database) ?</td> 
	<td><input name="user_confirm_debian" value="1" type="checkbox"></td>
</tr>
<tr>
	<td> </td> <td><input name="go" value="Install / Upgrade Database" type="submit"></td>
</tr>
</table>
</form>
<?php } /*end install state 0*/?>
<br /> <br />
<!--  END INSTALL STATE 0 -->

<!--  BEGIN INSTALL STATE 2 -->
<?php
//install_state == 2
// got database information, check and install
if (2 == $t_install_state) {
?>

<table width="100%" border="0" cellpadding="10" cellspacing="1">
	<!-- Setting config variables -->
	<?php print_test ( 'Setting Database Hostname', '' !== $f_hostname, true, 'host name is blank' ); ?>
	<!-- Setting config variables -->
	<?php print_test ( 'Setting Database Type', '' !== $f_db_type, true, 'database type is blank?' ); ?>
	<!-- Checking DB support-->
	<?php print_test ( 'Checking PHP support for database type', db_check_database_support ( $f_db_type ), true, 'database is not supported by PHP. Check that it has been compiled into your server.' ); ?>
	<!-- Checking admin email -->
	<?php if($g_database_upgrade == false){ ?>
		<?php print_test ( 'Setting Admin Email Address', '' !== $f_g_administrator_email, true, 'admin email is blank'); ?>
	<?php } ?>
	<!-- Checking config database -->
	<?php print_test ( 'Setting Database Username', '' !== $f_db_username, true, 'database username is blank'); ?>
	<?php print_test ( 'Setting Database Password', '' !== $f_db_password, false, 'database password is blank'); ?>
	<?php print_test ( 'Setting Database Name', '' !== $f_database_name, true, 'database name is blank' ); ?>
	<?php if ($f_db_type == 'db2') { print_test ( 'Setting Database Schema', ! is_blank ( $f_db_schema ), true, 'must have a schema name for AS400 in the form of DBNAME/SCHEMA' );} ?>
</table>

<table width="100%" border="0" cellpadding="10" cellspacing="1">
	<?php 
		//checking errors
		//do not allow to continue if checking if not passed
		$checking_values_error = "";
		if ( ('' !== $f_hostname) AND  ('' !== $f_db_type) AND  (db_check_database_support ( $f_db_type )==1)  AND ('' !== $f_db_username) AND ('' !== $f_db_password) AND ('' !== $f_database_name) ) { 
			//verify db2
			if( $f_db_type == 'db2' AND is_blank ( $f_db_schema ) ){ 
				print_test ( 'Errors Found','', false, $cheking_db_values ); 
				exit;
			}
		}else{
			//echo $cheking_db_values;  exit;
			print_test ( '','', false, $cheking_db_values );
			exit;
		}
	?>
</table>

<?php //ensuring db does not exists - this is an new installation ?>
<table width="100%" border="0" cellpadding="10" cellspacing="1">
	<!-- connect to db -->
	<tr>
	<td bgcolor="#ffffff" width="60%">Attempting to connect to Database Type as admin</td>
		<?php
		$t_db_open = false;
		$g_db = ADONewConnection ( $f_db_type );
		$t_result = @$g_db->Connect ( $f_hostname, $f_admin_username, $f_admin_password );
		
		//check if administrative user can connect to db_type
		if($t_result){
			print_test_result ( GOOD );
		}else{
			print_test_result ( BAD, true, 'Does administrative user access to the engine? ' . $g_db->errorMsg () .' '.$error_go_back );
			exit;
		}
		?>
	</tr>
</table>

<?php if($g_database_upgrade == true){ ?>
<table width="100%" border="0" cellpadding="10" cellspacing="1">
	<tr>
		<td bgcolor="#ffffff" width="60%">Attempting to connect to database as user</td>	
		<?php
		$g_db = ADONewConnection( $f_db_type );
		$t_result = @$g_db->Connect( $f_hostname, $f_db_username, $f_db_password, $f_database_name );

		if( $t_result == true ) {
			$t_db_open = true;
			if( $f_db_type == 'db2' ) {
				$result = &$g_db->execute( 'set schema ' . $f_db_schema );
				if( $result === false ) {
					print_test_result( BAD, true, 'set schema failed: ' . $g_db->errorMsg().' '.$error_go_back );
					exit;
				}
			} else {
				print_test_result( GOOD );
			}
		} else {
			print_test_result( BAD, false, 'Database user doesn\'t have access to the database ( ' . db_error_msg() . ' ) '.$error_go_back );
			exit;
		}
		?>
	</tr>
</table>
<?php }?>

<?php if($g_database_upgrade == false){ ?>
<table width="100%" border="0" cellpadding="10" cellspacing="1">
	<tr>
		<td bgcolor="#ffffff" width="60%">Verify the new Database does not exists</td>	
		<?php 
		if ($t_result) 
		{
			// check if db exists for the admin
			$t_result = @$g_db->Connect ( $f_hostname, $f_admin_username, $f_admin_password, $f_database_name );
			
			if ($t_result) {
				$t_db_open = true;
				$f_db_exists = true;
			}
			
			if ($f_db_exists) {
				//db2 needs to exist the database but not the schema
				if( $f_db_type == 'db2' ) {
					$result = &$g_db->execute( 'set schema ' . $f_db_schema );
					if( $result === false ) {
						print_test_result ( GOOD );
					}else{
						print_test_result ( BAD, true, 'The Database/Schema exists, and you are doing a new installation? Make sure your config file are correctly set to use upgrade option or use another database naem to prevent errors. ' .$error_go_back );
						break;
					}
				}else{
					//other cases bad
					print_test_result ( BAD, true, 'The Database exists, and you are doing a new installation. Make sure your config file are correctly set to use upgrade option or use another database name. ' .$error_go_back );
					exit;						
				}				

			} else {
				if( $f_db_type == 'db2' ) {
					print_test_result ( BAD, true, 'The Database for the schema is needed. Check the errors and return to this page.' .$error_go_back );
					break;
				}else{
				 	print_test_result ( GOOD );	
				}
				
			}
		}
		?>
	</tr>
</table>
<?php }?>

<table width="100%" border="0" cellpadding="10" cellspacing="1">
<!-- display database version -->
<tr>
		<?php
		$t_warning = '';
		$t_error = '';
		switch ($f_db_type) {
			case 'mysql' :
			case 'mysqli' :
				
				// due to a bug in ADODB, this call prompts warnings, hence the @
				// the check only works on mysql if the database is open
				// using default mysql db to test the version
				$default_mysql_database =  "mysql" ;
				@$g_db->Connect ( $f_hostname, $f_admin_username, $f_admin_password,$default_mysql_database);
				$t_version_info = @$g_db->ServerInfo ();
				if (version_compare ( $t_version_info ['version'], '4.1.0', '<' )) {
					$t_error = 'MySQL 4.1.0 or later is required for installation. '.$error_go_back;
				}else{
					$t_result_validation = '<br /> Running ' . $f_db_type . ' version ' . $t_version_info ['description'];	
				}
				break;
			case 'pgsql' :
			case 'mssql' :
			case 'db2' :
			default :
				$t_result_validation = '<br /> Running ' . $f_db_type ;
				break;
		}
		?>
		<td bgcolor="#ffffff" width="60%">Checking Database Server Version <?php echo $t_result_validation?></td>
		<?php
		//show results 
		print_test_result ( ('' == $t_error) && ('' == $t_warning), ('' != $t_error), $t_error . ' ' . $t_warning ); 
		//control mysql errors
		if('' == !$t_error){ exit; }
		?>
</tr>
</table>

<?php $t_install_state =1; } // end 2 == $t_install_state ?>
<br /> <br />
<!--  END INSTALL STATE 2 -->


<!--  BEGIN INSTALL STATE 1 -->
<?php 
//install_state ==1
// got database information, check and install
if (1 == $t_install_state) {
?>
<table width="100%" border="0" cellpadding="10" cellspacing="1">
	<tr><td bgcolor="#e8e8e8" colspan="2"><span class="title"><?php	echo $g_database_upgrade ? 'Upgrade Options' : 'Installation Options'?></span></td></tr>
	<?php 
	//last cheking to prevent manually intervencions from user
	if (! $g_database_upgrade) {
		//new installation 
		print_test_result ( GOOD );
	} else {
		//upgrade installation 
		//print_test_result ( BAD, true, 'Detecting misconfiguration, maybe a manually intervention from user. ' . $error_go_back );
		print_test_result ( GOOD );
	}
	?>
</table>
<?php $t_install_state =3; } // end 1 == $t_install_state ?>
<br /> <br />
<!--  /END INSTALL STATE 1 -->


<!--  BEGIN INSTALL STATE 3 -->
<?php 
// all checks have passed, install the database
if (3 == $t_install_state) {
?>

<table width="100%" border="0" cellpadding="10" cellspacing="1">
<tr><td bgcolor="#e8e8e8" colspan="2"><span class="title"><?php	echo $g_database_upgrade ? 'Upgrading Database' : 'Installing Database'?></span></td></tr>

<tr><td bgcolor="#ffffff"><?php	echo $g_database_upgrade ? 'Updating database' : 'Creating new database'?></span> </td>
<?php 
		//preparing vars to install
		$t_result 	= false;
		$t_db_open 	= false;
		
		//check the connection to database
		$t_result = @$g_db->Connect( $f_hostname, $f_admin_username, $f_admin_password, $f_database_name );
		
		//@TODO review this for installation when db2 it will be implemented
		//setting up db2
		if ($f_db_type == 'db2') {
			$rs = $g_db->Execute ( "select * from SYSIBM.SCHEMATA WHERE SCHEMA_NAME = '" . $f_db_schema . "' AND SCHEMA_OWNER = '" . $f_db_username . "'" );
			if ($rs === false) {
				echo "<br />false";
			}
			
			if ($rs->EOF) {
				$t_result = false;
				echo $g_db->errorMsg ();
			} else {
				$t_result = &$g_db->execute ( 'set schema ' . $f_db_schema );
			}
		}
		
		//check for upgrade option
		if( $t_result == true AND $g_database_upgrade == true) {
			print_test_result( GOOD );
			$t_db_open = true;
		} else {		
			
			//connecting as admin user
			// create db
			$g_db 		= ADONewConnection ( $f_db_type );
			$t_result 	= $g_db->Connect ( $f_hostname, $f_admin_username, $f_admin_password );
			$dict 		= NewDataDictionary ( $g_db );
			
			//review again privileges
			if ($f_db_type == 'db2') {
				$rs = &$g_db->Execute ( "CREATE SCHEMA " . $f_db_schema );
				
				if (! $rs) {
					$t_result = false;
					print_test_result ( BAD, true, 'Does administrative user have access to create the database? ( ' . db_error_msg () . ' ) ' . $error_go_back );
					exit;
				} else {
					print_test_result ( GOOD );
					$t_db_open = true;
				}
			} else {
				/* ////////////////////WARNING UTF-8 ///////////////////// */
				$sqlarray = $dict->CreateDatabase ( $f_database_name, Array ('mysql' => 'DEFAULT CHARACTER SET utf8 DEFAULT COLLATE utf8_general_ci' ) );
				$ret = $dict->ExecuteSQLArray ( $sqlarray );
				if ($ret == 2) {
					print_test_result ( GOOD );
					$t_db_open = true;
				} else {
					$t_error = db_error_msg ();
					if (strstr ( $t_error, 'Database exists' )) {
						print_test_result ( BAD, false, 'Database already exists? ( ' . db_error_msg () . ' ) ' . $error_go_back);
						exit;
					} else {
						print_test_result ( BAD, true, 'Does administrative user have access to create the database? ( ' . db_error_msg () . ' )' . $error_go_back );
						exit;
					}
				}
			}				
			
		}
		$g_db->Close ();
		//admin user has connection
?>

<?php if($g_database_upgrade == false ) {?>
<tr>
	<td bgcolor="#ffffff">Attempting to connect to database as user</td>
	<?php
		$g_db = ADONewConnection ( $f_db_type );
		$t_result = @$g_db->Connect ( $f_hostname, $f_db_username, $f_db_password, $f_database_name );
		
		if ($f_db_type == 'db2') {
			$result = &$g_db->execute ( 'set schema ' . $f_db_schema );
			if ($result === false) {
				echo $g_db->errorMsg ();
			}
		}
		
		if ($t_result == true) {
			print_test_result ( GOOD );
		} else {
		//closing connection
		$g_db->Close ();
			
			//this result is BAD because the Database user doesn\'t have access to the database
			//for mysql,mysqli,pgsql on Debian installation try to create user and grant privileges
			
			//@TODO granted privileges for other engines
			// due upstream installation do not support granting privileges 
			// for Debian packages and mysql,mysqli,pgsql engines this action is included
			// on this page installation
			//For more information read the manual 
			// "/usr/share/doc/mantis/adminguide/administration_guide.html"
			
			//new connection as admin user
			$g_db = ADONewConnection ( $f_db_type );
			$t_result = @$g_db->Connect ( $f_hostname, $f_admin_username, $f_admin_password, $f_database_name);	
			
			//filtering db_types
			switch ($f_db_type) {
				case 'mysql' :
				case 'mysqli' :
					//grant privileges
					$t_query_grant ="GRANT ALL ON `".$f_database_name."`.* TO `".$f_db_username."`@`".$f_hostname."` IDENTIFIED BY  '".$f_db_password."' "; 
					$t_grant = @$g_db->Execute ( $t_query_grant );
				
					if ($t_grant == true) {
						print_test_result ( GOOD );
					}else{
						print_test_result ( BAD, true, 'Database user doesn\'t have UPDATE access to the database ( ' . db_error_msg () . ' )' );			
					}
				break;
			
				case 'pgsql' :
					//create user
					$t_query_create ="CREATE USER '".$f_db_username."' WITH PASSWORD '".$f_db_password."' "; 
					$t_create = @$g_db->Execute ( $t_query_create );
					
					if ($t_create == true) {
						//grant privileges on database
						$t_query_grant ="GRANT ALL PRIVILEGES ON DATABASE '".$f_database_name."' TO '".$f_db_username."' "; 
						$t_grant = @$g_db->Execute ( $t_query_grant );
									
						if ($t_grant == true) {
							print_test_result ( GOOD );
						}else{
							print_test_result ( BAD, true, 'Database user doesn\'t have access to the database ( ' . db_error_msg () . ' )' );			
						}						
						
					}else{
						print_test_result ( BAD, true, 'Database user doesn\'t have access to the database ( ' . db_error_msg () . ' )' );			
					}	
				break;
				
				case 'mssql' :
				case 'db2' :
				default :
					$t_result_validation = '<br /> Running ' . $f_db_type ;
					print_test_result ( BAD, true, 'Database user doesn\'t have access to the database ( ' . db_error_msg () . ' )' );
				break;
			}

			$g_db->Close ();
			
		}
		?>
</tr>
<?php } ?>

<?php if($g_database_upgrade == true ) { ?>
<tr>
	<td bgcolor="#ffffff">Attempting to connect to database as user</td>
	<?php
		$g_db = ADONewConnection( $f_db_type );
		$t_result = @$g_db->Connect( $f_hostname, $f_db_username, $f_db_password, $f_database_name );

		if( $f_db_type == 'db2' ) {
			$result = &$g_db->execute( 'set schema ' . $f_db_schema );
			if( $result === false ) {
				echo $g_db->errorMsg();
			}
		}

		if( $t_result == true ) {
			print_test_result( GOOD );
		} else {
			print_test_result( BAD, false, 'Database user doesn\'t have access to the database ( ' . db_error_msg() . ' )'. $error_go_back  );
			exit;
		}
		$g_db->Close();
		?>
</tr>
<?php } ?>

<?php 
 	// install the tables
	if (false == $g_failed) {
		$g_db_connected = false;
		
		// fake out database access routines used by config_get
		$GLOBALS ['g_db_type'] = $f_db_type;
		
		// database_api references this
		require_once (dirname ( __FILE__ ) . DIRECTORY_SEPARATOR . 'schema.php');
		
		//connection
		$g_db = ADONewConnection ( $f_db_type );
		$t_result = @$g_db->Connect ( $f_hostname, $f_admin_username, $f_admin_password, $f_database_name );
		$g_db_connected = true;
		
		$t_last_update = config_get ( 'database_version', - 1, ALL_USERS, ALL_PROJECTS );
		$lastid = count ( $upgrade ) - 1;
		$i = $t_last_update + 1;
		

		// Make sure we do the upgrades using UTF-8 if needed
		// Testing this installation do not upgrade Latin - probably bug -verify????
		if ($f_db_type === 'mysql' || $f_db_type === 'mysqli') {
			$g_db->execute ( 'SET NAMES UTF8' );
		}
		
		if ($f_db_type == 'db2') {
			$result = &$g_db->execute ( 'set schema ' . $f_db_schema );
			if ($result === false) {
				echo $g_db->errorMsg ();
			}
		}
		
		while ( ($i <= $lastid) && ! $g_failed ) {
			
			echo '<tr><td bgcolor="#ffffff">';
			
			$dict = NewDataDictionary ( $g_db );
			$t_sql = true;
			$t_target = $upgrade [$i] [1] [0];
			
			if ($upgrade [$i] [0] == 'InsertData') {
				$sqlarray = call_user_func_array ( $upgrade [$i] [0], $upgrade [$i] [1] );
			} else if ($upgrade [$i] [0] == 'UpdateSQL') {
				$sqlarray = array ($upgrade [$i] [1] );
				$t_target = $upgrade [$i] [1];
			} else if ($upgrade [$i] [0] == 'UpdateFunction') {
				$sqlarray = array ($upgrade [$i] [1] );
				if (isset ( $upgrade [$i] [2] )) {
					$sqlarray [] = $upgrade [$i] [2];
				}
				$t_sql = false;
				$t_target = $upgrade [$i] [1];
			} else {
				/* 0: function to call, 1: function params, 2: function to evaluate before calling upgrade, if false, skip upgrade. */
				if (isset ( $upgrade [$i] [2] )) {
					if (call_user_func_array ( $upgrade [$i] [2] [0], $upgrade [$i] [2] [1] )) {
						$sqlarray = call_user_func_array ( Array ($dict, $upgrade [$i] [0] ), $upgrade [$i] [1] );
					} else {
						$sqlarray = array ();
					}
				} else {
					$sqlarray = call_user_func_array ( Array ($dict, $upgrade [$i] [0] ), $upgrade [$i] [1] );
				}
			}
			
			echo 'Schema ' . $upgrade [$i] [0] . ' ( ' . $t_target . ' )</td>';
			
			if ($t_sql) {
				$ret = $dict->ExecuteSQLArray ( $sqlarray );
			} else {
				if (isset ( $sqlarray [1] )) {
					$ret = call_user_func ( 'install_' . $sqlarray [0], $sqlarray [1] );
				} else {
					$ret = call_user_func ( 'install_' . $sqlarray [0] );
				}
			}
			
			if ($ret == 2) {
				print_test_result ( GOOD );
				config_set ( 'database_version', $i );
			} else {
				$all_sql = '';
				foreach ( $sqlarray as $single_sql )
					$all_sql .= $single_sql . '<br />';
				print_test_result ( BAD, true, $all_sql . $g_db->ErrorMsg () );
			}
			
			echo '</tr>';
			$i ++;
		}

	}
	
	if (false == $g_failed) {
		//GOOD
		//now we can update the config_inc.php file
	} else {
		print_test_result ( BAD, true, 'Database ERROR. Try again, uninstall manually the Database if it was created, and return to the installation.' );
		exit;
	}
	
	?>
</table>
<?php $t_install_state =4; } // end 3 == $t_install_state ?>
<br /> <br />
<!--  /END INSTALL STATE 3 -->

<!--  BEGIN INSTALL STATE 4 -->
<?php if (4 == $t_install_state) { ?>

<?php if($g_database_upgrade == true ) { ?>
<?php }else{?>
<table width="100%" border="0" cellpadding="10" cellspacing="1">
<tr><td bgcolor="#e8e8e8" colspan="2"><span class="title">Write Configuration File(s)</span></td></tr>
<tr>
	<td bgcolor="#ffffff" width="60%">
	<?php
	// all checks have passed, write the config file
	$t_config_filename = $g_absolute_path . 'config_inc.php';
	$t_config_exists = file_exists ( $t_config_filename );	
	
	if (! $t_config_exists) {
		echo 'Creating Configuration File (config_inc.php)<br />';
		echo '<font color="red">(if this file is not created or is not writable, create it manually with the contents below)</font>';
	} else {
		echo 'Updating Configuration File (config_inc.php)<br />';
	}
	?>
	</td>
	
	<?php
	//preparing output
	$t_config = '<?php' . "\r\n";

	$t_config .= "\t/* Debian default configuration file for mantis. */\r\n";
	
	$t_config .= "\r\n";

	$t_config .= "\t\$g_hostname = '$f_hostname';\r\n";
	$t_config .= "\t\$g_db_username = '$f_db_username';\r\n";
	$t_config .= "\t\$g_db_password = '$f_db_password';\r\n";
	$t_config .= "\t\$g_database_name = '$f_database_name';\r\n";
	$t_config .= "\t\$g_db_type = '$f_db_type';\r\n";
	if ($f_db_type == 'db2') {
		$t_config .= "\t\$g_db_schema = '$f_db_schema';\r\n";
	}	
	
	$t_config .= "\r\n";

	$t_config .= "\t/* E-Mail addresses */\r\n";
    $t_config .= "\t\$g_administrator_email = '$f_g_administrator_email';\r\n";
    $t_config .= "\t\$g_webmaster_email = '$f_g_webmaster_email';\r\n";
    $t_config .= "\t\$g_from_email = 'mantis@localhost';\r\n";
    $t_config .= "\t\$g_return_path_email = '$f_g_administrator_email';\r\n";

    $t_config .= "\r\n";

	$t_config .= "\t/* Attention: if you need to add another config params\r\n";
	$t_config .= "\t  is highly recommended that you use the config_local.php file. */\r\n";
	
	$t_config .= "\r\n";
	
	$t_config .= "\t include(\"config_local.php\");  \r\n"; //just debian packages
	
	$t_config .= '?>' . "\r\n";
	
	
	//write if exists
	$t_write_failed = true;
	
	if ( $t_config_exists ) {
		if ($fd = @fopen ( $t_config_filename, 'w' )) {
			fwrite ( $fd, $t_config );
			fclose ( $fd );
		}
		
		if (file_exists ( $t_config_filename )) {
			print_test_result ( GOOD );
			$t_write_failed = false;
		} else {
			print_test_result ( BAD, false, 'cannot write ' . $t_config_filename );
		}
		
	} else {
		print_test_result ( BAD, false, 'The file  ' . $t_config_filename .' doesn\'t exists. If you are installing from Debian package, may be you will need to reinstall or modify the config file manually.'  );
		exit;
	}
	?>
</tr>
<?php
	if (true == $t_write_failed) {
		echo '<tr><table width="50%" border="0" cellpadding="10" cellspacing="1" align="center">';
		echo '<tr><td>Please ensure that the following lines are including correctly on to ' . $g_absolute_path . 'config_inc.php. </td></tr>';
		echo '<tr><td><pre>' . htmlentities ( $t_config ) . '</pre></td></tr></table></tr>';			
		exit;		
	}else{
		//good do not show the code	
	}
	?>
</table>
<?php }?>

<?php $t_install_state =5; } // end 4 == $t_install_state ?>
<br /> <br />
<!--  /END INSTALL STATE 4 -->


<!--  BEGIN INSTALL STATE 5 -->
<?php
// post install checks 
//updating the default administrator password 
if (5 == $t_install_state) {
?>

<table width="100%" bgcolor="#222222" border="0" cellpadding="10" cellspacing="1">
<tr><td bgcolor="#e8e8e8" colspan="2"><span class="title">Checking Installation...</span></td></tr>

<tr>
	<td bgcolor="#ffffff">Attempting to connect to database as user</td>
	<?php
	$g_db = ADONewConnection ( $f_db_type );
	$t_result = @$g_db->Connect ( $f_hostname, $f_db_username, $f_db_password, $f_database_name );
	
	if ($t_result == true) {
		print_test_result ( GOOD );
	} else {
		print_test_result ( BAD, false, 'Database user doesn\'t have access to the database ( ' . db_error_msg () . ' )' );
		exit;
	}
	
	if ($f_db_type == 'db2') {
		$result = &$g_db->execute ( 'set schema ' . $f_db_schema );
		if ($result === false) {
			echo $g_db->errorMsg ();
		}
	}
	?>
</tr>

<tr>
	<td bgcolor="#ffffff">Checking ability to SELECT records</td>
	<?php
	$t_mantis_config_table = db_get_table ( 'mantis_config_table' );
	$t_query = "SELECT COUNT(*) FROM $t_mantis_config_table";
	$t_result = @$g_db->Execute ( $t_query );
	
	if ($t_result != false) {
		print_test_result ( GOOD );
	} else {
		print_test_result ( BAD, true, 'Database user doesn\'t have SELECT access to the database ( ' . db_error_msg () . ' )' );
		exit;
	}
	?>
</tr>

<tr>
	<td bgcolor="#ffffff">Checking ability to INSERT records</td>
	<?php
	$t_query = "INSERT INTO $t_mantis_config_table ( value, type, access_reqd, config_id, project_id, user_id ) VALUES ('test', 1, 90, 'database_test', 20, 0 )";
	$t_result = @$g_db->Execute ( $t_query );
	
	if ($t_result != false) {
		print_test_result ( GOOD );
	} else {
		print_test_result ( BAD, true, 'Database user doesn\'t have INSERT access to the database ( ' . db_error_msg () . ' )' );
		exit;
	}
	?>
</tr>

<tr>
	<td bgcolor="#ffffff">Checking ability to UPDATE records</td>
	<?php
	$t_query = "UPDATE $t_mantis_config_table SET value='test_update' WHERE config_id='database_test'";
	$t_result = @$g_db->Execute ( $t_query );
	
	if ($t_result != false) {
		print_test_result ( GOOD );
	} else {
		print_test_result ( BAD, true, 'Database user doesn\'t have UPDATE access to the database ( ' . db_error_msg () . ' )' );
		exit;
	}
	?>
</tr>

<tr>
	<td bgcolor="#ffffff">Checking ability to DELETE records</td>
	<?php
	$t_query = "DELETE FROM $t_mantis_config_table WHERE config_id='database_test'";
	$t_result = @$g_db->Execute ( $t_query );
	
	if ($t_result != false) {
		print_test_result ( GOOD );
	} else {
		print_test_result ( BAD, true, 'Database user doesn\'t have DELETE access to the database ( ' . db_error_msg () . ' )' );
		exit;
	}
	?>
</tr>

<?php if($g_database_upgrade == false ) { ?>
<tr>
	<td bgcolor="#ffffff">Changing default password and email for 'administrator' account</td>
<!-- change administrator password -->
<?php 
			//try to change the administrator account password
			//filtering db_types
			switch ($f_db_type) {
				case 'mysql' :
				case 'mysqli' :
				case 'pgsql' :
					if(strlen($f_db_admin_mantis_password)>0 )
					{
						$t_query = "UPDATE mantis_user_table SET password='".MD5($f_db_admin_mantis_password)."', email='".$f_g_webmaster_email."'  WHERE username='administrator'";
						$t_result = @$g_db->Execute ( $t_query );
				
						if ($t_result == true) {
							print_test_result ( GOOD, true, 'Reseting \'administrator\' password account to:' . $f_db_admin_mantis_password );
							$result_change_admin_mantis_passord =true;
						}else{
							print_test_result ( BAD, true, 'Could not be change the \'administrator\' password account. ( ' . db_error_msg () . ' )' );			
						}
					}
				break;
				
				case 'mssql' :
				case 'db2' :
				default :
					print_test_result ( BAD, true, 'No changes' );
				break;
			}
?>
</tr>
<?php } ?>

</table>
<?php $g_db->Close (); $t_install_state =6; } // end 5 == $t_install_state ?>
<br /> <br />
<!--  /END INSTALL STATE 5 -->

<!--  BEGIN INSTALL STATE 6 -->
<?php
// Complete 
if (6 == $t_install_state) {
?>
<table width="100%" border="0" cellpadding="10" cellspacing="1">

<tr><td bgcolor="#e8e8e8"><span class="title">Installation / Upgrade Complete</span></td></tr>

<tr>
<td bgcolor="#ffffff" style="font-size:medium;">

<?php	echo $g_database_upgrade ? 'Upgrade' : 'Installation'?> process was complete! <br /><br />

<a href="../login_page.php">Continue</a> to log into Mantis. <br />

<?php if($result_change_admin_mantis_passord ==false) { ?>
Please log in as the 'administrator' and <a href="../manage_proj_create_page.php">create</a> your first project.<br /><br />
<?php }?>

<?php if($g_database_upgrade == false AND $result_change_admin_mantis_passord ==true ) {?>
	You haved change the default 'administrator' email to: <b><?php echo $f_g_webmaster_email?> </b><br />
	You haved change the default 'administrator' password to: <b><?php echo $f_db_admin_mantis_password?> </b><br />
<?php } ?>

<span style="color:red">Warning: When you finish the installation or upgrade process is is highly recommended to delete the admin directory.</span>

</td>
</tr>
</table>
<?php  } // end 6 == $t_install_state ?>
<!--  /END INSTALL STATE 6 -->
<br /> <br />

</body>
</html>
