//
//  Extension.cpp
//  
//
//  Created by Pierre Peterlongo on 22/10/2012
//

#ifndef ASSERTS
#define NDEBUG // disable asserts, they're computationnally intensive
#endif

#include "Extension.h"

extern Bloom * bloo1;
extern BinaryBank * SolidKmers;
extern char * prefix_trashable;


Extension::Extension(const char * kmer){
//  printf("CREATE EXTENSION for %s (direction:%s)\n", kmer,LeftorRight );
  starting_kmer = kmer;
  node_id=-1;
}



void Extension::perform_extension(const string prefix, int max_graph_depth, const char extension_type, int max_nodes, parcours_t search_mode){
    terminator->reset(); // distinct extensions may share kmers, however, a unique extension doesn't. 
    if(extension_type==1 || extension_type==2)
            IterativeExtensions::when_to_stop_extending = IterativeExtensions::After_first_contig; // sequence
    else
            IterativeExtensions::when_to_stop_extending = IterativeExtensions::Until_max_depth; //graph
    
    if(extension_type==1 || extension_type==3)
            IterativeExtensions::traversal_type = IterativeExtensions::SimplePaths; // strict
    else
            IterativeExtensions::traversal_type = IterativeExtensions::Monument; // contigs

    string linear_seq_name = prefix_trashable+starting_kmer;
     
    // construct and store the linear seqs'
    IterativeExtensions::dont_output_first_nucleotide = true;
    IterativeExtensions::construct_linear_seqs(starting_kmer,string(), max_graph_depth, linear_seq_name, 1, max_nodes,  search_mode);
    
    
    
    
}
