/* 
===========================================================================
 $Id: mserror.i,v 1.2 2005/01/30 01:24:17 sean Exp $
 
 Project:  MapServer
 Purpose:  MapScript exceptions
 Author:   Umberto Unicoletti, unicoletti@prometeo.it
           Jerry Pisk, jerry.pisk@gmail.com
           Sean Gillies, sgillies@frii.com

 Note: Python exceptions are in mapscript/python
============================================================================
*/

%include exception.i

%exception {
    $action 
    if (msGetErrorObj()!=NULL && msGetErrorObj()->code != MS_NOERR) {
        errorObj ms_error;

        memcpy(&ms_error, msGetErrorObj(), sizeof(errorObj));
        msResetErrorList();
       
        switch(ms_error.code) {
            case MS_NOTFOUND:
                break;
            case -1:
                break;
            case MS_IOERR:
                SWIG_exception(SWIG_IOError ,ms_error.message);
                break;
            case MS_MEMERR:
                SWIG_exception(SWIG_MemoryError,ms_error.message);
                break;
            case MS_TYPEERR:
                SWIG_exception(SWIG_TypeError,ms_error.message);
                break;
            case MS_EOFERR:
                SWIG_exception(SWIG_SyntaxError,ms_error.message);
                break;
            case MS_CHILDERR:
                SWIG_exception(SWIG_SystemError,ms_error.message);
                break;
            default:
                SWIG_exception(SWIG_UnknownError,ms_error.message);
                break;
        }       
    }
}
 

