/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.mariadb.jdbc.internal.MariaDbType;
import org.mariadb.jdbc.internal.packet.dao.ColumnInformation;
import org.mariadb.jdbc.internal.util.ExceptionMapper;

public class MariaDbResultSetMetaData
implements ResultSetMetaData {
    private ColumnInformation[] fieldPackets;
    private int datatypeMappingflags;
    private boolean returnTableAlias;

    public MariaDbResultSetMetaData(ColumnInformation[] fieldPackets, int datatypeMappingFlags, boolean returnTableAlias) {
        this.fieldPackets = fieldPackets;
        this.datatypeMappingflags = datatypeMappingFlags;
        this.returnTableAlias = returnTableAlias;
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.fieldPackets.length;
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        return (this.getColumnInformation(column).getFlags() & 0x200) != 0;
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        return (this.getColumnInformation(column).getFlags() & 0x80) != 0;
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        return true;
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        return false;
    }

    @Override
    public int isNullable(int column) throws SQLException {
        if ((this.getColumnInformation(column).getFlags() & 1) == 0) {
            return 1;
        }
        return 0;
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        return this.getColumnInformation(column).isSigned();
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        return this.getColumnInformation(column).getDisplaySize();
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        return this.getColumnInformation(column).getName();
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        String columnName = this.getColumnInformation(column).getOriginalName();
        if (this.returnTableAlias) {
            columnName = this.getColumnInformation(column).getName();
        }
        if ("".equals(columnName)) {
            columnName = this.getColumnLabel(column);
        }
        return columnName;
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        return this.getColumnInformation(column).getDb();
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        return (int)this.getColumnInformation(column).getLength();
    }

    @Override
    public int getScale(int column) throws SQLException {
        return this.getColumnInformation(column).getDecimals();
    }

    @Override
    public String getTableName(int column) throws SQLException {
        if (this.returnTableAlias) {
            return this.getColumnInformation(column).getTable();
        }
        return this.getColumnInformation(column).getOriginalTable();
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        return "";
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        ColumnInformation ci = this.getColumnInformation(column);
        switch (ci.getType()) {
            case BIT: {
                if (ci.getLength() == 1L) {
                    return -7;
                }
                return -3;
            }
            case TINYINT: {
                if (ci.getLength() == 1L && (this.datatypeMappingflags & 1) != 0) {
                    return -7;
                }
                return -6;
            }
            case YEAR: {
                if ((this.datatypeMappingflags & 2) != 0) {
                    return 91;
                }
                return 5;
            }
            case BLOB: {
                if (ci.getLength() < 0L || ci.getLength() > 0xFFFFFFL) {
                    return -4;
                }
                return -3;
            }
            case VARCHAR: 
            case VARSTRING: {
                if (ci.isBinary()) {
                    return -3;
                }
                if (ci.getLength() < 0L) {
                    return -1;
                }
                return 12;
            }
            case STRING: {
                if (ci.isBinary()) {
                    return -2;
                }
                return 1;
            }
        }
        return ci.getType().getSqlType();
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        ColumnInformation ci = this.getColumnInformation(column);
        return MariaDbType.getColumnTypeName(ci.getType(), ci.getLength(), ci.isSigned(), ci.isBinary());
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        return !this.isReadOnly(column);
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        return !this.isReadOnly(column);
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        ColumnInformation ci = this.getColumnInformation(column);
        MariaDbType type = ci.getType();
        return MariaDbType.getClassName(type, (int)ci.getLength(), ci.isSigned(), ci.isBinary(), this.datatypeMappingflags);
    }

    private ColumnInformation getColumnInformation(int column) throws SQLException {
        if (column >= 1 && column <= this.fieldPackets.length) {
            return this.fieldPackets[column - 1];
        }
        throw ExceptionMapper.getSqlException("No such column");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }
}

