/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.AcknowledgedBulkWriteResult;
import com.mongodb.BasicDBObject;
import com.mongodb.BulkWriteError;
import com.mongodb.BulkWriteException;
import com.mongodb.BulkWriteResult;
import com.mongodb.BulkWriteUpsert;
import com.mongodb.CommandResult;
import com.mongodb.DBObject;
import com.mongodb.MongoInternalException;
import com.mongodb.WriteConcernError;
import com.mongodb.WriteRequest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class WriteCommandResultHelper {
    static boolean hasError(CommandResult commandResult) {
        return commandResult.get("writeErrors") != null || commandResult.get("writeConcernError") != null;
    }

    static BulkWriteResult getBulkWriteResult(WriteRequest.Type type, CommandResult commandResult) {
        int count = WriteCommandResultHelper.getCount(commandResult);
        List<BulkWriteUpsert> upsertedItems = WriteCommandResultHelper.getUpsertedItems(commandResult);
        return new AcknowledgedBulkWriteResult(type, count - upsertedItems.size(), WriteCommandResultHelper.getModifiedCount(type, commandResult), upsertedItems);
    }

    static BulkWriteException getBulkWriteException(WriteRequest.Type type, CommandResult commandResult) {
        if (!WriteCommandResultHelper.hasError(commandResult)) {
            throw new MongoInternalException("This method should not have been called");
        }
        return new BulkWriteException(WriteCommandResultHelper.getBulkWriteResult(type, commandResult), WriteCommandResultHelper.getWriteErrors(commandResult), WriteCommandResultHelper.getWriteConcernError(commandResult), commandResult.getServerUsed());
    }

    private static List<BulkWriteError> getWriteErrors(CommandResult commandResult) {
        ArrayList<BulkWriteError> writeErrors = new ArrayList<BulkWriteError>();
        List writeErrorsDocuments = (List)commandResult.get("writeErrors");
        if (writeErrorsDocuments != null) {
            for (DBObject cur : writeErrorsDocuments) {
                writeErrors.add(new BulkWriteError((Integer)cur.get("code"), (String)cur.get("errmsg"), WriteCommandResultHelper.getErrInfo(cur), (Integer)cur.get("index")));
            }
        }
        return writeErrors;
    }

    private static WriteConcernError getWriteConcernError(CommandResult commandResult) {
        DBObject writeConcernErrorDocument = (DBObject)commandResult.get("writeConcernError");
        if (writeConcernErrorDocument == null) {
            return null;
        }
        return new WriteConcernError((Integer)writeConcernErrorDocument.get("code"), (String)writeConcernErrorDocument.get("errmsg"), WriteCommandResultHelper.getErrInfo(writeConcernErrorDocument));
    }

    private static List<BulkWriteUpsert> getUpsertedItems(CommandResult commandResult) {
        List upsertedValue = (List)commandResult.get("upserted");
        if (upsertedValue == null) {
            return Collections.emptyList();
        }
        ArrayList<BulkWriteUpsert> bulkWriteUpsertList = new ArrayList<BulkWriteUpsert>();
        for (DBObject upsertedItem : upsertedValue) {
            bulkWriteUpsertList.add(new BulkWriteUpsert(((Number)upsertedItem.get("index")).intValue(), upsertedItem.get("_id")));
        }
        return bulkWriteUpsertList;
    }

    private static int getCount(CommandResult commandResult) {
        return commandResult.getInt("n");
    }

    private static Integer getModifiedCount(WriteRequest.Type type, CommandResult commandResult) {
        Integer modifiedCount = (Integer)commandResult.get("nModified");
        if (modifiedCount == null && type != WriteRequest.Type.UPDATE && type != WriteRequest.Type.REPLACE) {
            modifiedCount = 0;
        }
        return modifiedCount;
    }

    private static DBObject getErrInfo(DBObject response) {
        DBObject errInfo = (DBObject)response.get("errInfo");
        return errInfo != null ? errInfo : new BasicDBObject();
    }

    private WriteCommandResultHelper() {
    }
}

