/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.queryresults;

import java.sql.Statement;
import org.mariadb.jdbc.internal.queryresults.ExecutionResult;
import org.mariadb.jdbc.internal.queryresults.resultset.MariaSelectResultSet;

public class SingleExecutionResult
extends ExecutionResult {
    long insertId;
    long affectedRows;

    public SingleExecutionResult(Statement statement, int fetchSize, boolean selectPossible, boolean canHaveCallableResultset) {
        super(statement, fetchSize, selectPossible, canHaveCallableResultset);
    }

    @Override
    public void addResult(MariaSelectResultSet result, boolean moreResultAvailable) {
        this.result = result;
        this.insertId = -2L;
        this.affectedRows = -1L;
        this.setMoreResultAvailable(moreResultAvailable);
    }

    @Override
    public void addStats(long affectedRows, long insertId, boolean moreResultAvailable) {
        this.insertId = insertId;
        this.affectedRows = affectedRows;
        this.setMoreResultAvailable(moreResultAvailable);
    }

    @Override
    public long[] getInsertIds() {
        return new long[]{this.insertId};
    }

    public long getInsertId() {
        return this.insertId;
    }

    public long getAffectedRows() {
        return this.affectedRows;
    }

    @Override
    public boolean hasMoreThanOneAffectedRows() {
        return this.affectedRows > 1L;
    }

    @Override
    public int getFirstAffectedRows() {
        return (int)this.affectedRows;
    }

    @Override
    public void addStatsError() {
    }
}

