/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.core.io;

import com.mysql.cj.core.io.DefaultValueFactory;
import java.math.BigDecimal;
import java.math.BigInteger;

public class BigDecimalValueFactory
extends DefaultValueFactory<BigDecimal> {
    int scale;
    boolean hasScale;

    public BigDecimalValueFactory() {
    }

    public BigDecimalValueFactory(int scale) {
        this.scale = scale;
        this.hasScale = true;
    }

    private BigDecimal adjustResult(BigDecimal d2) {
        if (this.hasScale) {
            try {
                return d2.setScale(this.scale);
            }
            catch (ArithmeticException ex) {
                return d2.setScale(this.scale, 4);
            }
        }
        return d2;
    }

    @Override
    public BigDecimal createFromBigInteger(BigInteger i2) {
        return this.adjustResult(new BigDecimal(i2));
    }

    @Override
    public BigDecimal createFromLong(long l2) {
        return this.adjustResult(BigDecimal.valueOf(l2));
    }

    @Override
    public BigDecimal createFromBigDecimal(BigDecimal d2) {
        return this.adjustResult(d2);
    }

    @Override
    public BigDecimal createFromDouble(double d2) {
        return this.adjustResult(BigDecimal.valueOf(d2));
    }

    @Override
    public String getTargetTypeName() {
        return BigDecimal.class.getName();
    }
}

