/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you wish to add, delete or rename slots use Qt Designer which will
** update this file, preserving your code. Create an init() slot in place of
** a constructor, and a destroy() slot in place of a destructor.
*****************************************************************************/
#include <iostream>
using namespace std;

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void Form2::init()
{
    // Qt version of a Constructor
    f = 0; // Logger Form pointer
    connect(&pmt, SIGNAL(dialed(int)), this, SLOT(dialit(int))); 
    connect(&pmt, SIGNAL(btnpress(int)), this, SLOT(pmBtn(int)));
    connect(&k2tr, SIGNAL(rxdata(QString)), this, SLOT(dataRcd(QString)));
    connect( this, SIGNAL(ftune()), this, SLOT(rdy4cmd()));
    txdly = 100;
    txstop = FALSE;
    t.start();
    v.start(); // Start the command delay timer
}
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void Form2::cmdK2( char * ddd)
{
    QTimer *led = new QTimer();
    connect( led, SIGNAL(timeout()), SLOT(txLedOFF()) ); 
    txLed->setEnabled(TRUE);
    led->start( 60, TRUE );
    k2tr.cmd_k2(ddd);
}     

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void Form2::dataRcd(QString rawrx)
{
    aaa = rawrx;
    if(!aaa.isEmpty())
    {
 decode();
    }
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void Form2::reset()
{
    // If a read fails this is the bailout routine to run.
    // As soon as I figure out what to do. <cough cough>
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void Form2::pwrBtn()
{
    bool loadit = FALSE;
    QMessageBox mb( "Marote",
      "Do you want to load your previous settings?",
      QMessageBox::Question,
      QMessageBox::Yes | QMessageBox::Default,
      QMessageBox::No  | QMessageBox::Escape,
      QMessageBox::NoButton );
    if ( mb.exec() == QMessageBox::Yes )   
 loadit = TRUE;
    
    if(loadit)
 loadsettings(FALSE);
    
    pwrLight->setEnabled(TRUE);
    on_btn->setText("Running");
    on_btn->setEnabled(FALSE);
    // The serial port you want to use
    if(port1RB->isChecked()){
 spt = 1;
    }
    if(port2RB->isChecked()){
 spt = 2;
    }
    
    k2tr.init_k2(spt);// Initialize the serial port
    k2tr.start();// Start K2 read thread 
    
    // Setup K2 with default values
    strcpy(cmd, "AI2;K22;");
    cmdK2( cmd ); 
    // set rf output to a reasonable level 5 watts LOL
    strcpy(cmd, "PC050;");
    cmdK2( cmd ); 
    // tune up 10 Hz to force K2 to send more complete status
    strcpy(cmd, "UP1;");
    cmdK2( cmd ); 
    // Zero out the RIT/XIT offset
    strcpy(cmd, "RC;");
    cmdK2( cmd ); 
    // LCD bits
    strcpy(cmd, "DS;");
    cmdK2( cmd );
    // Filters
    strcpy(cmd, "FW;");
    cmdK2( cmd ); 
    // AGC
    strcpy(cmd, "GT;");
    cmdK2( cmd );    
    // NB
    strcpy(cmd, "NB;");
    cmdK2( cmd ); 
    // CW buffer
    strcpy(cmd, "KS;");
    cmdK2( cmd );  
    // Get Mode
    strcpy(cmd, "MD;");
    cmdK2( cmd );
    
    readTimer();// Start S-meter sampling/
    if (loadit)      
 loadsettings(TRUE);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void Form2::decode( )
{
    rxLed->setEnabled(TRUE); 
    QTimer::singleShot( 250, this, SLOT(rxLedOFF()) );
    // S meter, BG
    if(aaa.find("BG", 0) == 0){
 QString s = aaa.mid(2, 2);
 int sval = s.toInt();
 //qDebug("DEBUG %d", sval);
 if(sval >=12){
     sval = sval -12;
 }
 Smeter->setProgress(sval);
 return;
    }
    
    // [IF] command 
    if(aaa.find("IF", 0) == 0){
 // IF command detected.
 // Extract frequency data
 QString freq = aaa.mid(5, 7);
 freq.insert(5, ".");
 float f = freq.toFloat();
 freq = "";
 freq = freq.setNum(f, 'f', 2);
 // ***************** Set Freq *********************
 Frequency->setText(freq);
 auxFreq->setText(freq);
 // ***************** Which VFO *****************
 QString wv = aaa.mid(30, 1);
 //qDebug(QString("the string is '%1'").arg(wv));
 if(wv == "0"){
     mainVFO->setText("A");
 }
 if(wv == "1"){
     mainVFO->setText("B");
 }
 // ***************** Extract RIT *****************
 QString RITstate = aaa.mid(23, 1);
 if(RITstate == "1"){
     RITchk->setChecked(TRUE);
     // Display the offset
     QString ritF = aaa.mid(18, 5);
     rit_offset->setText(ritF);
 }else{
     RITchk->setChecked(FALSE);
     //rit_offset->setText("");
 }
 // ***************** Extract XIT *****************
 QString XITstate = aaa.mid(24, 1);
 if(XITstate == "1"){
     XITchk->setChecked(TRUE);
     // Display the offset
     QString ritF = aaa.mid(18, 5);
     rit_offset->setText(ritF);
 }else{
     XITchk->setChecked(FALSE);
 }
 // ***************** Extract Mode ***************** 
 QString modeK2 = aaa.mid(29, 1);
 if(modeK2 == "1"){
     LSB_btn->setChecked(TRUE);
 }
 if(modeK2 == "2"){
     USB_btn->setChecked(TRUE);
 }
 if(modeK2 == "3"){
     CW_btn->setChecked(TRUE);
 }
 if(modeK2 == "6"){
     RTTY_btn->setChecked(TRUE);
 }
 if(modeK2 == "7"){
     CWR_btn->setChecked(TRUE);
 }
 if(modeK2 == "9"){
     RTTYR_btn->setChecked(TRUE);
 } 
 return;
    }       
    //[MD] command
    if(aaa.find("MD", 0) == 0) {
 QString modeK2 = aaa.mid(2, 1);
 if(modeK2 == "1"){
     LSB_btn->setChecked(TRUE);
 }
 if(modeK2 == "2"){
     USB_btn->setChecked(TRUE);
 }
 if(modeK2 == "3"){
     CW_btn->setChecked(TRUE);
 }
 if(modeK2 == "6"){
     RTTY_btn->setChecked(TRUE);
 }
 if(modeK2 == "7"){
     CWR_btn->setChecked(TRUE);
 }
 if(modeK2 == "9"){
     RTTYR_btn->setChecked(TRUE);
 } 
 return;
    }
    // [FA] command
    if(aaa.find("FA", 0) == 0) {
 // VFO A freq change
 freqA = aaa.mid(5,7);
 freqA.insert(5, ".");
 float fa = freqA.toFloat();
 freqA = "";
 freqA = freqA.setNum(fa, 'f', 2);
 emit ftune();
 return; //NEW
    }
    // [FB] command
    if(aaa.find("FB", 0) == 0) {
 // VFO B freq change
 freqB = aaa.mid(5,7);
 freqB.insert(5, ".");
 float fb = freqB.toFloat();
 freqB = "";
 freqB = freqB.setNum(fb, 'f', 2); 
 emit ftune();
 return; // NEW
    } 
    
    if(aaa.find("FR", 0) == 0) {
 // Receive vfo
 QString fr = aaa.mid(2,1);
 if(fr == "0"){
     vfoA_rx->setChecked(TRUE);
     Frequency->setText(freqA);
     auxFreq->setText(freqA);
     mainVFO->setText("A");
     SubFreq->setText(freqB);
     subVFO->setText("B");
 }
 if(fr == "1") {
     vfoB_rx->setChecked(TRUE);
     Frequency->setText(freqB);
     auxFreq->setText(freqB);
     mainVFO->setText("B");
     SubFreq->setText(freqA);     
     subVFO->setText("A");
 }
 return;
    }
    
    if(aaa.find("FT", 0) == 0) {
 // Transmit vfo
 QString ft = aaa.mid(2,1);
 if(ft == "0"){
     vfoA_tx->setChecked(TRUE);
 }
 if(ft == "1") {
     vfoB_tx->setChecked(TRUE);
 }
 return;
    }
    
    if(aaa.find("KS", 0) == 0) {
 // Keyer Speed
 QString cws = aaa.mid(3,2); 
 cwSPD->setText(cws);  // Updates text value
 auxCwSpd->setText(cws);
 bool ok;
 int val = cws.toInt(&ok, 10);
 slider1->setValue(val);
 return;
    }
    
    if(aaa.find("PC", 0) == 0) {
 // RF Power
 QString pwr = aaa.mid(2,3); 
 // Check length to see if extended response available
 QString amp = aaa.mid(5,1);
 bool ok;
 int q = amp.toInt(&ok, 10);
 //qDebug("Amp = %x", q); 
 int val = pwr.toInt(&ok, 10);
 rfSlider->setValue( val ); // Update slider position
 rfProgBar->setProgress( val );
 
 if(q == 1){
 paBtn->setChecked(TRUE);
 // High Power Range
double v = val;
pwr = pwr.setNum(v);
qrp_WBtn->setText("max W");
}else {
     paBtn->setChecked(FALSE);
     // Low Power Range
     double v = val *.1;
     pwr = pwr.setNum(v);
     qrp_WBtn->setText("5 W");
}
 rfTxt->setText(pwr);  // Updates text value
 return;
    } 
    
    if(aaa.find("GT", 0) == 0) {
 // AGC
 QString asf = aaa.mid(4, 1);
 QString aof = aaa.mid(5, 1);
 if( aof == "0"){
     agcOffBtn->setChecked(FALSE);
 }
 if( aof == "1"){
     if(asf == "2"){
  agcFastBtn->setChecked(TRUE);
     }
     if(asf == "4"){
  agcSlowBtn->setChecked(TRUE);
     }
 }
    }    
    
    if(aaa.find("NB", 0) == 0) {
 QString nbn = aaa.mid(2, 1);
 QString nbm = aaa.mid(3, 1);
 bool ok;
 int inbn = nbn.toInt(&ok, 10);
 int inbm = nbm.toInt(&ok, 10);
 
 switch(inbn)
 {
 case 0:
     nb1LBL->setEnabled(FALSE);
     nb2LBL->setEnabled(FALSE);
     break;
 case 1:
     nb1LBL->setEnabled(TRUE);
     nb2LBL->setEnabled(FALSE);
     break;
 case 2:
     nb1LBL->setEnabled(FALSE);
     nb2LBL->setEnabled(TRUE);
     break;      
 }
 switch(inbm)
 {
 case 0:
     thLoLBL->setEnabled(FALSE);
     thHiLBL->setEnabled(TRUE);      
     break;
 case 1:
     thLoLBL->setEnabled(TRUE);
     thHiLBL->setEnabled(FALSE);      
     break;
 }
 
    }
    
    if(aaa.find("FW", 0) == 0) {
 // Check filter setting
 QString fil = aaa.mid(6, 1);// X filter selected
 QString afil = aaa.mid(7, 1);// A filter selected  
 afilTxt->setText("Filter =" + afil);
 bool ok;
 int val = fil.toInt(&ok, 10);//X filter make it an int
 QString filbw = aaa.mid(2, 4); // Get the Hz of the X filter
 filnumTE->setText(fil);
 filbwTE->setText(filbw);
 filBWtxt->setText(filbw);
 switch(val)
 {
 case 1:
     filABtn->setChecked(TRUE);
     break;
 case 2:
     filBBtn->setChecked(TRUE);
     break;
 case 3:
     filCBtn->setChecked(TRUE);
     break;
 case 4:
     filDBtn->setChecked(TRUE);
     break; 
 }
 return; // NEW
    }
    
    if(aaa.find("DS", 0) == 0) {    
 // Big decode of entire K2 LCD display
 QString adS = aaa.mid(10, 1);
 QChar adC = adS.at(0);
 QString adfS = aaa.mid(11, 1);
 QChar adfC = adfS.at(0);
 
 if(adC & 0x40){
     // NB is on but unknown which one 1 or 2
 }
 if(adC & 0x20){
     // Antenna 2 on
     ant2Btn->setChecked(TRUE);
 }else {
     ant1Btn->setChecked(TRUE);
 }
 if(adC & 0x10){
     // Preamp on
     preampBtn->setChecked(TRUE);
 }
 if(adC & 0x08){
     // Atten on
     attenBtn->setChecked(TRUE);
 }
 if(adC & 0x02){
     // RIT on
     RITchk->setChecked(TRUE);
 }
 if(adC & 0x01){
     // XIT on
     XITchk->setChecked(TRUE);
 }
 
 if(adfC & 0x04){
     // Split mode
     splitVFOs->setChecked(TRUE);
 }
 return;
    }
    //   qDebug("decode FAILED!");
    //   cout << "Failed to decode this -> " << aaa << " Length = " << aaa.length() <<  endl;
} // End of Form2::decode()

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void Form2::readTimer()
{
    // Read the S-meter
    stimer = new QTimer();    
    connect( stimer, SIGNAL(timeout()), SLOT(Smtr()) );    
    stimer->start( 200, FALSE );    
}
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void Form2::Smtr()
{
    strcpy(cmd, "BG;"); 
    cmdK2(cmd);
}
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void Form2::rxLedOFF()
{
    rxLed->setEnabled(FALSE);
}
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void Form2::modeX()
{
    // Mode change slot
    if(LSB_btn->isOn()){
 modeNum = 1;
    }    
    if(USB_btn->isOn()){
 modeNum = 2;
    }    
    if(CW_btn->isOn()){
 modeNum = 3;
    }
    if(RTTY_btn->isOn()){
 modeNum = 6;
    }     
    if(CWR_btn->isOn()){
 modeNum = 7;
    }
    if(RTTYR_btn->isOn()){
 modeNum = 9;
    }        
    
    bzero(cmd, 30);
    strcpy(cmd, "MD");
    char ddd[10];
    bzero(ddd, 10);
    sprintf(ddd,  "%u", modeNum);
    strcat(cmd, ddd);
    strcat(cmd, ";");
    cmdK2(cmd);
}


///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void Form2::vfoDN()
{
    txstop = FALSE;
    if(tenHz_rbtn->isOn()){
 strcpy(vcmd, "DN1;");   
 offset = -.01;
    }
    if(twentyHz_rbtn->isOn()){
 strcpy(vcmd, "DN2;");   
 offset = -.02;
    }
    if(fiftyHz_rbtn->isOn()){
 strcpy(vcmd, "DN3;");
 offset = -.05;
    }
    if(oneKhz_rbtn->isOn()){
 strcpy(vcmd, "DN4;");   
 offset = -1.0;
    }    
    if(v.elapsed() >= txdly)
    {
 emit ftune();
    }   
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void Form2::vfoUP()
{
    txstop = FALSE;
    if(tenHz_rbtn->isOn()){
 strcpy(vcmd, "UP1;");   
 offset = .01;
    }
    if(twentyHz_rbtn->isOn()){
 strcpy(vcmd, "UP2;");   
 offset = .02;
    }
    if(fiftyHz_rbtn->isOn()){
 strcpy(vcmd, "UP3;");   
 offset = .05;
    }
    if(oneKhz_rbtn->isOn()){
 strcpy(vcmd, "UP4;");   
 offset = 1.0;
    }    
    if(v.elapsed() >= txdly)
    {
 emit ftune();
    }
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void Form2::freqAI()
{
    // Artifical Intelligence for tuning the vfo
    // Actually I am making up for the display lag from the K2
    QString fstr = Frequency->displayText();
    bool ok;    
    float fflt = fstr.toFloat( &ok);
    fflt += offset;
    fstr = fstr.setNum(fflt, 'f', 2);
    Frequency->setText(fstr);   
    auxFreq->setText(fstr);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void Form2::vfoTuned()
{
    // This gets called when user releases the tuning button
    //    strcpy(cmd, "IF;");
    //    cmdK2(cmd);   
    txstop = TRUE; // Stop TX since user has released tuning button
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void Form2::vfoChange()
{
    // Poll states of all buttons
    switch(vnum)
    {
    case 1:
 //VFO A RX
 strcpy(cmd, "FR0;");
 cmdK2(cmd);
 if( !splitVFOs->isOn() ){
     strcpy(cmd, "FT0;");
     cmdK2(cmd);
 } 
 break;
    case 2:
 // VFO B RX 
 strcpy(cmd, "FR1;");
 cmdK2(cmd);
 if( !splitVFOs->isOn() ){
     strcpy(cmd, "FT1;");
     cmdK2(cmd);
 }  
 break;
    case 3:
 // VFO A TX
 strcpy(cmd, "FT0;");
 cmdK2(cmd);
 if( !splitVFOs->isOn() ){
     strcpy(cmd, "FR0;");
     cmdK2(cmd);
 }  
 break;
    case 4:
 // VFO B TX
 strcpy(cmd, "FT1;");
 cmdK2(cmd);
 if( !splitVFOs->isOn() ){
     strcpy(cmd, "FR1;");
     cmdK2(cmd);
 } 
 break;
    default:
 break;
    }
    
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void Form2::varc()
{
    vnum = 1;
    emit vfoSwitch();
}
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void Form2::vbrc()
{
    vnum = 2;
    emit vfoSwitch();
}
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void Form2::vatc()
{
    vnum = 3;
    emit vfoSwitch();
}
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void Form2::vbtc()
{
    vnum = 4;
    emit vfoSwitch();
}
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void Form2::txLedOFF()
{
    txLed->setEnabled(FALSE);
}
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void Form2::rfPwr()
{
    QString g = rfTxt->displayText();
    g =g.remove('.');
    // FIll with leading zeros if needed
int a = g.length();
if(a == 2)
    g = g.prepend('0');
if(a == 1)
    g = g.prepend("00");
    strcpy(cmd, "PC");     
    strcat(cmd, g);
    strcat(cmd, ";");
    cmdK2( cmd );     
}
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void Form2::cwSpeed()
{
    char eee[4];
    int a = slider1->value();
    sprintf(eee,  "%u", a);
    cwSPD->setText( eee );
    auxCwSpd->setText( eee );
    strcpy(cmd, "KS0");
    strcat(cmd, eee);
    strcat(cmd, ";");
    cmdK2(cmd);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void Form2::ritRB()
{
    if( RITchk->isOn()){
 strcpy(cmd, "RT1;");
    }else{
 strcpy(cmd, "RT0;");
    }
    cmdK2( cmd );
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void Form2::xitRB()
{
    if( XITchk->isOn()){
 strcpy(cmd, "XT1;");
    }else{
 strcpy(cmd, "XT0;");
    }
    cmdK2( cmd );
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void Form2::ritDwn()
{
    strcpy(cmd, "RD;");
    cmdK2( cmd );
}

void Form2::ritUp()
{
    strcpy(cmd, "RU;");
    cmdK2( cmd );
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void Form2::bandUp()
{
    strcpy(cmd, "SW01;");
    cmdK2( cmd );
}

void Form2::bandDn()
{
    strcpy(cmd, "SW03;");
    cmdK2( cmd );
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void Form2::cwSlider()
{
    char eee[4];
    int a = slider1->value();
    sprintf(eee,  "%u", a);
    cwSPD->setText( eee );
    auxCwSpd->setText( eee );
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void Form2::vfoLock()
{
    if( !vfoWARN->isEnabled() ){
 strcpy(cmd, "LK1;");
 cmdK2( cmd );
 vfoWARN->setEnabled(TRUE);
    } else {
 strcpy(cmd, "LK0;");
 cmdK2( cmd );
 vfoWARN->setEnabled(FALSE);
    }
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void Form2::rfAdjust()
{
    // There is no difference in the cmd you send to K2 to set pwr
    // 000-150 without amp yields 0-15 Watts 
    // and 000-150 with amp yields 0-150 Watts
    int a = rfSlider->value();// value is an int
    //cout << "DEBUG a= " << a << endl;
    rfProgBar->setProgress( a );
    double b = a;
    QString rf;
    
    if(!paBtn->isOn()){
 b = a * .1;
                rf = rf.setNum(b, 'f', 1);
      }else{
 rf = rf.setNum(a);
      }              
       rfTxt->setText( rf );        
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void Form2::paOn()
{
    // This gets called when the PA button is toggled
    // rfTxt is number
    QString rft = rfTxt->displayText();
    uint len = rft.length();
    if( !paBtn->isOn()){
 // Remove decimal point
 rft = rft.remove(".");
 qrp_WBtn->setText("max W");
    }else {
 // Add decimal point
 rft = rft.insert( (len - 1), ".");
 qrp_WBtn->setText("5 W");
    }
    rfTxt->setText( rft );
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void Form2::abSwap()
{
    strcpy(cmd, "SW09;");
    cmdK2( cmd );
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void Form2::abEqual()
{
    strcpy(cmd, "SW10;");
    cmdK2( cmd );
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void Form2::qrpBtn()
{    
    if(paBtn->isOn()){
 strcpy(cmd, "PC150;");// Overshoot a bit 
    }else {
 strcpy(cmd, "PC050;");
    }
    cmdK2( cmd );
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void Form2::antenna1()
{
    strcpy(cmd, "AN1;");
    cmdK2( cmd );
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void Form2::antenna2()
{
    strcpy(cmd, "AN2;");
    cmdK2( cmd );
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void Form2::agcOff()
{
    strcpy(cmd, "GT0000;");
    cmdK2( cmd );
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void Form2::agcSlow()
{
    strcpy(cmd, "GT0041;");
    cmdK2( cmd );
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void Form2::agcFast()
{
    strcpy(cmd, "GT0021;");
    cmdK2( cmd );
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void Form2::fw1()
{
    strcpy(cmd, "FW00001;");
    cmdK2( cmd );
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void Form2::fw2()
{
    strcpy(cmd, "FW00002;");
    cmdK2( cmd );
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void Form2::fw3()
{
    strcpy(cmd, "FW00003;");
    cmdK2( cmd );
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void Form2::fw4()
{
    strcpy(cmd, "FW00004;");
    cmdK2( cmd );
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void Form2::atten()
{
    if( !attenBtn->isOn() ){
 strcpy(cmd, "RA00;"); // attenuator off
    }else{
 strcpy(cmd, "RA01;"); // attenuator on
    }
    cmdK2( cmd );
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void Form2::preamp()
{
    if( !preampBtn->isOn() ) {
 strcpy(cmd, "PA0;"); // Preamp off
    }else{
 strcpy(cmd, "PA1;"); // Preamp on
    }   
    cmdK2( cmd );
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void Form2::vfoSplit()
{
    if( splitVFOs->isOn() ){
 if( vfoA_rx->isOn() ){
     vfoB_tx ->setChecked(TRUE);
 }
 if( vfoB_rx->isOn() ){
     vfoA_tx ->setChecked(TRUE);
 } 
    } else {
 if( vfoA_rx->isOn() ){
     vfoA_tx ->setChecked(TRUE);
 }
 if( vfoB_rx->isOn() ){
     vfoB_tx ->setChecked(TRUE);
 }  
    }
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void Form2::msg1()
{
    QString m1 = msg1_txt->displayText();
    cwmsg(m1);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void Form2::msg2()
{
    QString m1 = msg2_txt->displayText();
    cwmsg(m1);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void Form2::msg3()
{
    QString m1 = msg3_txt->displayText();
    cwmsg(m1);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void Form2::msg4()
{
    QString m1 = msg4_txt->displayText();
    cwmsg(m1);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void Form2::msg5()
{
    QString m1 = msg5_txt->displayText();
    cwmsg(m1);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void Form2::nbToggle()
{
    strcpy(cmd, "NB0;"); // 0 or 1, value not important
    cmdK2( cmd );
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void Form2::thToggle()
{
    strcpy(cmd, "SW22;"); 
    cmdK2( cmd );
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void Form2::cwFileA()
{ 
    fileName = QFileDialog::getOpenFileName(
     ".",
     "CW Macros (*.cw )",
     this,
     "open file dialog",
     "Choose a CW file to open" );
    if(!fileName) {
 return;
    }
    cwFileAa(fileName); // restore settings from file selected
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void Form2::cwmsg( QString m )
{
    uint l =m.length();
    if(l == 0){return;}
    QString zz = "";
    // Check for macros
    for(uint k = 0; k < l; k++){ 
 if(m.mid(k, 1) == "$"){
     // Macro detected
     if(m.mid((k+1), 1) == "c" || m.mid((k+1), 1) == "C"){
  zz.insert( k, callTxt->displayText() );
     }
     if(m.mid((k+1), 1) == "r" || m.mid((k+1), 1) == "R"){
  zz.insert( k, rstTxt->displayText() );
     }
     if(m.mid((k+1), 1) == "n" || m.mid((k+1), 1) == "N"){
  // a bit more complicated need to actually count stuff
  zz.insert( k, countTxt->displayText() );
  // Ok we have sent current count now increment it for next time
  QString v = countTxt->displayText();
  bool ok;    
  int cnt = v.toInt( &ok, 10);
  cnt++;
  v = v.setNum(cnt, 10);
  if( v.length() == 1){
      v.prepend("00");
  }
  if( v.length() == 2){
      v.prepend("0");
  }
  countTxt->setText( v );
     }     
     if(m.mid((k+1), 1) == "x" || m.mid((k+1), 1) == "X"){
  zz.insert( k, xTxt->displayText() );
     }     
     if(m.mid((k+1), 1) == "y" || m.mid((k+1), 1) == "Y"){
  zz.insert( k, yTxt->displayText() );
     }     
     if(m.mid((k+1), 1) == "z" || m.mid((k+1), 1) == "Z"){
  zz.insert( k, zTxt->displayText() );
     }     
     k++;
 }else{
     zz += m.mid(k, 1);
 }
    }
    //debugTxt->setText(zz);
    l = zz.length();
    for(uint i = 0; i < l; i++){
 strcpy(cmd, "KY "); 
 strcat(cmd, zz.mid(i, 1));
 strcat(cmd, ";");
 cmdK2( cmd );
    }    
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void Form2::cwfileB()
{
    QString s = QFileDialog::getSaveFileName(
     ".",
     "CW Macros (*.cw)",
     this,
     "save file dialog"
     "Choose a filename to save under" );
    if(!s){return;} // No filename returned so exit
    QFile f3( s );
    f3.open( IO_WriteOnly );
    QTextStream ts( &f3 );
    ts << msg1_txt->displayText() << endl;
    ts << msg2_txt->displayText() << endl;
    ts << msg3_txt->displayText() << endl;
    ts << msg4_txt->displayText() << endl;
    ts << msg5_txt->displayText() << endl;
    ts << callTxt->displayText() << endl;
    ts << rstTxt->displayText() << endl;
    ts << countTxt->displayText() << endl;
    ts << xTxt->displayText() << endl;
    ts << yTxt->displayText() << endl;
    ts << zTxt->displayText() << endl;
    //Quick Buttons
    ts<< b1 << endl;
    ts<< b2 << endl;
    ts<< b3 << endl;
    ts<< b4 << endl;
    ts<< b5 << endl;
    ts<< b6 << endl;
    ts<< b7 << endl;
    
    f3.close();
    
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void Form2::cw25wpm()
{
    strcpy(cmd, "KS025;");
    cmdK2(cmd);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void Form2::cwDn5()
{
    char eee[4];
    int a = slider1->value();
    // Do sanity checks!  K2 cw speed range is 009-050 ( 9-50 wpm )
    a = a - 5;
    if(a < 9){ a = 9;}
    sprintf(eee,  "%u", a);
    if(a <= 9){
 strcpy(cmd, "KS00");
    }else{
 strcpy(cmd, "KS0");
    }
    strcat(cmd, eee);
    strcat(cmd, ";");
    cmdK2(cmd);
}
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void Form2::cwUp5()
{
    char eee[4];
    int a = slider1->value();
    // Do sanity checks!  K2 cw speed range is 009-050 ( 9-50 wpm )
    a = a + 5;
    if(a > 50 ){ a = 50;}
    sprintf(eee,  "%u", a);
    strcpy(cmd, "KS0");
    strcat(cmd, eee);
    strcat(cmd, ";");
    cmdK2(cmd);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void Form2::cwUp1()
{
    char eee[4];
    int a = slider1->value();
    // Do sanity checks!  K2 cw speed range is 009-050 ( 9-50 wpm )
    a = a + 1;
    if(a > 50){ a = 50;}
    sprintf(eee,  "%u", a);
    strcpy(cmd, "KS0");
    strcat(cmd, eee);
    strcat(cmd, ";");
    cmdK2(cmd);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void Form2::cwDn1()
{
    char eee[4];
    int a = slider1->value();
    // Do sanity checks!  K2 cw speed range is 009-050 ( 9-50 wpm )
    a = a - 1;
    if(a < 9){ a = 9;}
    sprintf(eee,  "%u", a);
    if(a <= 9){
 strcpy(cmd, "KS00");
    }else{
 strcpy(cmd, "KS0");
    }
    strcat(cmd, eee);
    strcat(cmd, ";");
    cmdK2(cmd);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void Form2::cwC()
{
    QString m1 = callTxt->displayText();
    cwmsg(m1);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void Form2::cwN()
{
    QString m1 = countTxt->displayText();
    int a = 0;
    // Count needs to have one subtracted 
    // Why? Because what is displayed is what will be sent in next MSG
    // We want to resend what was sent in MSG earlier.  I figure that the other 
    // operator didn't hear what you sent so this gives you an easy way to 
    // re-send the same number.
    
    // Lets turn the string into a number we can decrement
    a = m1.toInt();
    a = a - 1;
    m1 = QString( "%1" ).arg( a, 0, 10 );
    uint b = m1.length();
    if( b == 1 ){ m1 = m1.prepend( "00"); }
    if( b == 2 ){ m1 = m1.prepend( "0"); }
    cwmsg(m1);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void Form2::cwX()
{
    QString m1 = xTxt->displayText();
    cwmsg(m1);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void Form2::cwY()
{
    QString m1 = yTxt->displayText();
    cwmsg(m1);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void Form2::cwZ()
{
    QString m1 = zTxt->displayText();
    cwmsg(m1);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void Form2::cwR()
{
    QString m1 = rstTxt->displayText();
    cwmsg(m1);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void Form2::dsp_NR()
{
    strcpy(cmd, "SW81;");
    cmdK2(cmd);    
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void Form2::dsp_NT()
{
    strcpy(cmd, "SW80;");
    cmdK2(cmd);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void Form2::afw1()
{
    strcpy(cmd, "SW29;"); //Toggle audio filters
    cmdK2(cmd);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void Form2::pmb_blink(int blnk)
{
    if(pmEnable->isOn()){
 pmt.powermate_pulse_led(blnk);
    } 
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void Form2::pmb_off()
{
    if(pmEnable->isOn()){
 pmt.powermate_pulse_led_off();
    }   
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void Form2::dialit( int amt )
{
    // This slot gets called whne powermate has detected knob turned
    QTimer *p = new QTimer();
    connect( p, SIGNAL(timeout()), SLOT(pmtnocmd()) );     
    if(p->timerId () != -1)
    {
 p->stop(); // Stop timer if it is running
    }
    if(amt > 0){
 // tune up
 vfoUP();
    }
    if(amt < 0){
 //tune down
 vfoDN();
    }
    p->start( 100, TRUE );  
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void Form2::pmEnable_clicked()
{
    // This is where the powermate READ thread is started
    if(pmEnable->isOn()){
 pmt.start();// Start the thread to listen for knob twiddling
 
    }    
}

////////////////////////////////////////// Powermate set tuning rate and blink //////////////////////////////////////////
void Form2::pmBtn(int b)
{
    if(b == 1){
 if(tenHz_rbtn->isOn()){         
     twentyHz_rbtn->setChecked(TRUE);
     pmb_blink(257);
     return;
 }
 if(twentyHz_rbtn->isOn()){
     fiftyHz_rbtn->setChecked(TRUE);
     pmb_blink(260);
     return;
 }
 if(fiftyHz_rbtn->isOn()){
     oneKhz_rbtn->setChecked(TRUE);
     pmb_blink(265);     
     return;
 } 
 if(oneKhz_rbtn->isOn()){
     tenHz_rbtn->setChecked(TRUE);
     pmb_blink(253);
     return;
 } 
    }    
    // Pause briefly then shut off blinking
    sleep( 2 );
    pmb_off();
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void Form2::pmtListen()
{
    // This is where the powermate READ thread is started
    if(pmEnable->isOn()){
 //How about a quick check to see if the darn thing is there
 // Before starting the thread
 int ffd = fpm.find_powermate(O_RDONLY);
 if(ffd > 0){
     //All is well
     close(ffd);
     qDebug("DEBUG Found a powermate");
 }
 
 if(ffd <= 0){
     //  Panic!
     QMessageBox::critical( 0, "Marote", "Unable to find the Powermate, Disabling it\n"
       "You must correct the problem and restart Marote\n"
       "If you want to use the Powermate.\n"
       "Marote will continue without it now");
     pmEnable->setEnabled(FALSE);
     return;
 }
 
 pmt.start();// Start the thread to listen for knob twiddling
 pmt.wait();
    }
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void Form2::rdy4cmd()
{
    // Signal to this function notifies pgm that a freq tuning cmd was rx
    if(strlen(vcmd) > 0 & !txstop)
    {
 // tuning command ready to go;
 cmdK2(vcmd);
 bzero(vcmd, 30); // Clear out old command
 freqAI(); 
 v.restart(); // restart cmd delay timer
    }
    
    return;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void Form2::pmtnocmd()
{
    txstop = TRUE; // Knob has not turned so stop tuning
}


void Form2::fxfil()
{
    //   New way to count  3, 0, 1, 2
    switch (filterBtnGrp->selectedId())
    {
    case 3:
 fw2();
 break;
    case 0:
 fw3();
 break;
    case 1:
 fw4();
 break;
    case 2:
 fw1();
 break;
    }
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void Form2::savesettings()
{
    
    QFile f4( "k2settings.txt" );
    f4.open( IO_WriteOnly );
    QTextStream fs( &f4 );
       
    // Powermate status
    if(pmEnable->isOn())
    {
 fs << "TRUE" << endl;
    }else{ 
 fs << "FALSE" << endl;
    }
    // Serial port
    if(port1RB->isOn()){
 fs << "COM1" << endl;
    }
    if(port2RB->isOn()){
 fs << "COM2" << endl;
    }
    // CW macros
    if(!fileName.isEmpty()){
 //fileName.replace( QChar('/'), "//" );
 fs << fileName << endl;
    }else{
 fs << "NONE" << endl;
    }
    
    f4.close();
    QMessageBox::information( this, "Marote",
         "K2 settings saved" );
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void Form2::loadsettings(bool online)
{
    // online lets pgm know if K2 is on or off 
    QString sd = "";   
    QString fileName = "k2settings.txt";
    QFile f5(fileName );
    
    if(!f5.open( IO_ReadOnly ))
    {
 if(online){QMessageBox::information( this, "Marote","No K2 saved settings found" );}
 return;
    }  
    QTextStream rs( &f5 );
    // Powermate status
    sd = rs.readLine();
    if(sd == "TRUE")
    {
 if(online){pmEnable->animateClick();}// Only matters if it is on
    }    
    // Serial port
    sd = rs.readLine();
    if(sd == "COM1")
    {    
 if(!online){port1RB->setChecked(TRUE);}
    }
    if(sd == "COM2")
    {    
 if(!online){port2RB->setChecked(TRUE);}
    }   
    // CW Macro filename
    sd = rs.readLine();
    if(!online){   
 if(sd == "NONE")
 {
     // Nothing to load
 }else{
     fileName = sd;
     cwFileAa(fileName);
 }
    }
    f5.close(); 
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void Form2::cwkeyboard()
{
    // This should be called when RETURN is pressed in the cw keyboard text input field. 
    // Make sure it is ok to transmit
    if(cwkbd_CKBTN->isOn())
    {
 // Send first 24 characters or less.
 cwk =cwkbd_LE->displayText();   
 cwmsg(cwk);
    }
    cwkbd_LE->setText(""); // Erase the line if RETURN is pressed regardless
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void Form2::cwFileAa(QString fnm)
{
    QString lod = "";  
    QFile f2(fnm);
    f2.open( IO_ReadOnly );
    
    QTextStream ts( &f2 );
    // There should be five lines of data.  One line per macro.
    
    lod = ts.readLine();
    lod = lod.mid(0,60);
    msg1_txt->setText(lod); 
    
    lod = ts.readLine();
    lod = lod.mid(0,60);
    msg2_txt->setText(lod);
    
    lod = ts.readLine();
    lod = lod.mid(0,60);
    msg3_txt->setText(lod);
    
    lod = ts.readLine();
    lod = lod.mid(0,60);
    msg4_txt->setText(lod);
    
    lod = ts.readLine();
    lod = lod.mid(0,60);
    msg5_txt->setText(lod);         
    //  Save the macros 
    lod = ts.readLine();
    lod = lod.mid(0,10);
    callTxt->setText(lod);
    
    lod = ts.readLine();
    lod = lod.mid(0,3);
    rstTxt->setText(lod);
    
    lod = ts.readLine();
    lod = lod.mid(0,7);
    countTxt->setText(lod);
    
    lod = ts.readLine();
    lod = lod.mid(0,60);
    xTxt->setText(lod);
    
    lod = ts.readLine();
    lod = lod.mid(0,60);
    yTxt->setText(lod);
    
     lod = ts.readLine();
    lod = lod.mid(0,60);
    zTxt->setText(lod);   
    
    lod = ts.readLine();
    pushButton44->setText("1. <" + lod + ">");
    
    lod = ts.readLine();
    pushButton45->setText("2. <" + lod + ">");
    
    lod = ts.readLine();
    pushButton46->setText("3. <" + lod + ">");
        
    lod = ts.readLine();
    pushButton47->setText("4. <" + lod + ">");
    
    lod = ts.readLine();
    pushButton48->setText("5. <" + lod + ">");
    
    lod = ts.readLine();
    pushButton49->setText("6. <" + lod + ">");
    
    lod = ts.readLine();
    pushButton50->setText("7. <" + lod + ">");
    
    f2.close();
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void Form2::logit()
{
    // Collect data to send to Xlog logbook
    QString ftmp;
    // Nam of program sending data to Xlog
    strcpy(logmsg, "program:Marote\1");
    // Callsign to log
    ftmp = callsign_LE->displayText();
    if(!ftmp.isEmpty()){
 strcat(logmsg, "call:");    
 strcat(logmsg, ftmp);
 strcat(logmsg, "\1");
  }
    ftmp = "";
    // Freq in Mhz of qso
    ftmp = Frequency->displayText();
    strcat(logmsg, "mhz:");
    // Format frequency into Mhz format
    double a = ftmp.toDouble();
    //a = abs(a);
    a = a * .001;
    ftmp = ftmp.setNum(a, 'f', 3);
    strcat(logmsg, ftmp);
    strcat(logmsg, "\1");
    ftmp = "";
    // Mode of qso
    int bx = buttonGroup3->selectedId();
       switch(bx)
    {
    case 0:
               ftmp =  "LSB";
                break;
    case 1:
                ftmp =  "USB";
                break;  
    case 2:
                ftmp =  "CW";
                break;   
     case 3:
                ftmp =  "RTTY";
                break;   
    case 4:
               ftmp =   "CW";
                break;   
     case 5:
                ftmp =  "RTTY";
                break;     
     }
    if(!ftmp.isEmpty()){
         strcat(logmsg, "mode:");    
         strcat(logmsg, ftmp);
         strcat(logmsg, "\1");
  }        
    ftmp = "";
    // RST TX
    ftmp = txrst_LE->displayText();
    if(!ftmp.isEmpty()){
         strcat(logmsg, "tx:");    
         strcat(logmsg, ftmp);
         strcat(logmsg, "\1");
  }    
    ftmp = "";
    // RST RX
    ftmp = rxrst_LE->displayText();
    if(!ftmp.isEmpty()){
         strcat(logmsg, "rx:");    
         strcat(logmsg, ftmp);
         strcat(logmsg, "\1");
  }       
    ftmp = "";
    // Name
    ftmp = name_LE->displayText();
    if(!ftmp.isEmpty()){
         strcat(logmsg, "name:");    
         strcat(logmsg, ftmp);
         strcat(logmsg, "\1");
  }     
    ftmp = "";
    // QTH
    ftmp = qth_LE->displayText();
    if(!ftmp.isEmpty()){
         strcat(logmsg, "qth:");    
         strcat(logmsg, ftmp);
         strcat(logmsg, "\1");
  }         
    ftmp = "";
    // Notes
    ftmp = notes_LE->displayText();
    if(!ftmp.isEmpty()){
         strcat(logmsg, "notes:");    
         strcat(logmsg, ftmp);
         strcat(logmsg, "\1");
  }           
    ftmp = "";
    // power used for qso
     ftmp = rfTxt->displayText();
    if(!ftmp.isEmpty()){
         strcat(logmsg, "power:");    
         strcat(logmsg, ftmp);
         strcat(logmsg, "\1");
  }             
 ftmp = "";
    // freefield 1
    ftmp = free1_LE->displayText();
    if(!ftmp.isEmpty()){
         strcat(logmsg, "free1:");    
         strcat(logmsg, ftmp);
         strcat(logmsg, "\1");
  }       
    ftmp = "";
    // freefield 2
    ftmp = free2_LE->displayText();
    if(!ftmp.isEmpty()){
         strcat(logmsg, "free2:");    
         strcat(logmsg, ftmp);
         strcat(logmsg, "\1");
  }       
    ftmp = "";    
    
    if (xl.sendit(logmsg) == 1){
 // ERROR Routine
 QMessageBox::warning( this, "Marote","Could not send to Xlog program" );  
}else{    
    // Clear fields and get ready to log a new qso
    name_LE->setText("");
    qth_LE->setText("");
    callsign_LE->setText("");
    free1_LE->setText(""); 
    notes_LE->setText("");
    free2_LE->setText("");
}
    
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void Form2::rst599()
{
rxrst_LE->setText("599");
txrst_LE->setText("599");
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void Form2::clrlogfields()
{
rxrst_LE->setText("");
txrst_LE->setText("");
name_LE->setText("");
qth_LE->setText("");
callsign_LE->setText("");
notes_LE->setText("");
free1_LE->setText(""); 
free2_LE->setText("");
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void Form2::btn1()
{
b1 = lineEdit31->displayText();
pushButton44->setText("1. <" + b1 + ">");
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void Form2::btn1_send()
{
   cwmsg(b1);
}


void Form2::btn2()
{
b2 = lineEdit32->displayText();
pushButton45->setText("2. <" + b2 + ">");
}


void Form2::btn2_send()
{
cwmsg(b2);
}


void Form2::btn3()
{
b3 = lineEdit33->displayText();
pushButton46->setText("3. <" + b3 + ">");
}


void Form2::btn3_send()
{
cwmsg(b3);
}


void Form2::btn4()
{
b4 = lineEdit34->displayText();
pushButton47->setText("4. <" + b4 + ">");
}


void Form2::btn4_send()
{
cwmsg(b4);
}


void Form2::btn5()
{
b5 = lineEdit35->displayText();
pushButton48->setText("5. <" + b5 + ">");
}


void Form2::btn5_send()
{
cwmsg(b5);
}


void Form2::btn6()
{
b6 = lineEdit36->displayText();
pushButton49->setText("6. <" + b6 + ">");
}


void Form2::btn6_send()
{
cwmsg(b6);
}


void Form2::btn7()
{
b7 = lineEdit37->displayText();
pushButton50->setText("7. <" + b7 + ">");
}


void Form2::btn7_send()
{
cwmsg(b7);
}
