/*
 * Copyright (C) 2007 Intel Corporation
 *
 * Author:  Horace Li <horace.li@intel.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

//#define _GNU_SOURCE
#define _XOPEN_SOURCE 600  //prevent: 'implicit declaration of function 'isascii'
#include <gtk/gtk.h>
#include <glib-object.h>
#include <libhildondesktop/libhildondesktop.h>
#include <ctype.h>  //for isascii (menu title)

#include "drop-down-menu-plugin.h"

#define BTN_HEIGHT  52
#define BTN_WIDTH_FOR_800 220
#define BTN_WIDTH_FOR_1024 300 
#define TEXT_LEFT_MARGIN   30   //so that little arrow shows behind
#define MARQUEE_DROPDOWN "marquee-drowdown"

HD_DEFINE_PLUGIN (DropDownMenuPlugin, drop_down_menu_plugin, TASKNAVIGATOR_TYPE_ITEM);

static void drop_down_menu_finalize (GObject *object);


static void new_window_title (HDWM *hdwm, DropDownMenuPlugin *ddm_plugin)
{
   HDWMWindow *wnd = NULL;
   const gchar *wnd_title = NULL;
   int goodStr = 1;

   wnd = hd_wm_get_active_window();
   if (wnd) {
      wnd_title = hd_wm_window_get_name(wnd);
   }
   if (wnd_title && strlen(wnd_title)>0) { 
      for (int i=0; i < strlen(wnd_title); i++) {
         if (isascii((int)wnd_title[i])==0) {
            goodStr = FALSE;
            break;
         }
      }
   } else {
      goodStr = 0;
   }

   if (goodStr != 0) {
      gtk_label_set_text ((GtkLabel*)ddm_plugin->label, wnd_title);
   } else {
      gtk_label_set_text ((GtkLabel*)ddm_plugin->label, "Home");
   }
}

/* update window title */
static void update_window_title (HDWM *hdwm, HDWMEntryInfo *info, DropDownMenuPlugin *ddm_plugin)
{
   HDWMWindow *wnd = NULL;
   HDWMApplication *app = NULL;
   const gchar *wnd_title = NULL;
   int goodStr = 1;

   if (HD_WM_IS_APPLICATION (info))
   {
      app = HD_WM_APPLICATION (info);
      wnd = hd_wm_application_get_active_window (app);
   }
   else if (HD_WM_IS_WINDOW (info))
   {
      wnd = HD_WM_WINDOW (info);
   }
   else
   {
      g_print ("this info is neither an application nor a window.\n");
   }

   if (wnd) {
      wnd_title = hd_wm_window_get_name(wnd);
   }
   if (wnd_title && strlen(wnd_title)>0) {
      for (int i=0; i < strlen(wnd_title); i++) {
	 if (isascii(wnd_title[i])==0) {
	    goodStr = 0;
	    break;
	 }
      }
   } else {
      goodStr = 0;
   }

   if (goodStr != 0) {
	 gtk_label_set_text ((GtkLabel*)ddm_plugin->label, wnd_title);
   } else {
      gtk_label_set_text ((GtkLabel*)ddm_plugin->label, "Home");
   }
}

/* btn clicked */
static void on_clicked (GtkWidget *button, DropDownMenuPlugin *ddm_plugin)
{
   //get menu of active app
   g_print ("Get menu for active application\n");
   HDWMWindow *wnd = hd_wm_get_active_window();

   g_print ("Active window:%ld\n", (long)wnd);
   if (wnd != NULL) {
      Atom atom;
      Display *dpy = NULL;
      Window xwin;
      XEvent ev;
      memset(&ev, 0, sizeof(ev));

      atom = hd_wm_get_atom(HD_ATOM_MB_GRAB_TRANSFER);
      xwin = hd_wm_window_get_x_win(wnd);
      dpy = hd_wm_window_get_display(wnd);

      ev.xclient.type = ClientMessage;
      ev.xclient.window = xwin;
      ev.xclient.message_type = atom;
      ev.xclient.format = 32;
      ev.xclient.data.l[0] = 0;
      ev.xclient.data.l[1] = 0;
      ev.xclient.data.l[2] = 0;
      ev.xclient.data.l[3] = 0;
      ev.xclient.data.l[4] = 0;

      if (NULL != dpy) {
        XSendEvent(dpy, xwin, False, NoEventMask, &ev);

        XSync(dpy, False);
      }
      else {
        g_print ("No Display handle returned.\n");
      }
   }
}

static void drop_down_menu_plugin_init (DropDownMenuPlugin *ddm_plugin)
{
   GtkWidget *btn, *label, *hbox, *pad;
   HDWM *hdwm;

   hdwm = hd_wm_get_singleton ();
   g_object_ref (ddm_plugin->hdwm);

   btn = gtk_button_new();
   
   int scn_width = 800;
   GdkScreen *screen = gtk_widget_get_screen ((GtkWidget*)ddm_plugin);
   if (screen != NULL) {
      scn_width = gdk_screen_get_width(screen);
   }
   //gtk_widget_set_size_request ((GtkWidget*)ddm_plugin, (scn_width == 1024?313:210), 52);
   gtk_widget_set_size_request ((GtkWidget*)ddm_plugin, (scn_width == 1024?BTN_WIDTH_FOR_1024 : BTN_WIDTH_FOR_800), BTN_HEIGHT);

   //ddm_plugin->imgUp = gtk_image_new_from_file (THEME_DIR "/images/mb_drop_down_menu.png");
   //gtk_button_set_image ((GTK_BUTTON (btn)),(GtkWidget*) ddm_plugin->imgUp);

   label = gtk_label_new (NULL);
   //gtk_label_set_text ((GtkLabel*)label, "HomeBoy");
   //gtk_label_set_markup (GTK_LABEL(label), "<span foreground=\"white\" size=\"medium\">Home</span>");

   //set the font size smaller
   PangoAttribute *pa_size = pango_attr_size_new (14000);
   pa_size->start_index = 0;
   pa_size->end_index = -1;
   PangoAttribute *pa_font = pango_attr_family_new ("Sans");
   pa_font->start_index = 0;
   pa_font->end_index = -1;
   PangoAttribute *pa_color = pango_attr_foreground_new (0xE2E1,0xE2E1,0xE2E1);
   pa_color->start_index = 0;
   pa_color->end_index = -1;
   PangoAttrList *pl = pango_attr_list_new();
   pango_attr_list_insert(pl,pa_size);
   pango_attr_list_insert(pl,pa_font);
   pango_attr_list_insert(pl,pa_color);
   
   gtk_label_set_attributes ((GtkLabel*)label, pl);
   pango_attr_list_unref (pl);

   //gtk_label_set_justify ((GtkLabel*)label, GTK_JUSTIFY_LEFT);
   gtk_misc_set_alignment((GtkMisc*)label, 0.0, 0.5);

   //use hbox containing pad and label to push text to the right
   //so little arrow shows
   hbox = gtk_hbox_new(FALSE,0);
   pad = gtk_label_new(NULL);
   gtk_widget_set_size_request (pad, TEXT_LEFT_MARGIN, 0);
   gtk_box_pack_start  ((GtkBox*)hbox, pad, FALSE, FALSE, 0);
   gtk_container_add (GTK_CONTAINER(hbox), label);

   gtk_container_add (GTK_CONTAINER (btn), hbox); //label);
  
   ddm_plugin->hdwm = hdwm;
   ddm_plugin->btn = btn;
   ddm_plugin->label = label;

   g_signal_connect (btn, "clicked", 
		     G_CALLBACK (on_clicked), (gpointer)ddm_plugin);
   g_signal_connect (hdwm, "active-window-update",  
		     G_CALLBACK (new_window_title), (gpointer)ddm_plugin);
   g_signal_connect (hdwm, "entry_info_stack_changed",  
		     G_CALLBACK (update_window_title), (gpointer)ddm_plugin);

   gtk_widget_show_all (btn);

   //setting name (for theme) doesn't help as Hildon overrides first 3 buttons
   gtk_widget_set_name (ddm_plugin->btn, MARQUEE_DROPDOWN);

   gtk_container_add (GTK_CONTAINER (ddm_plugin), btn);
}


static void drop_down_menu_plugin_class_init (DropDownMenuPluginClass *class)
{
  GObjectClass   *object_class = G_OBJECT_CLASS (class);
  object_class->finalize    = drop_down_menu_finalize;
}

static void drop_down_menu_finalize (GObject *object)
{
   DropDownMenuPlugin *ddm_plugin = DROP_DOWN_MENU_PLUGIN (object);	
   g_object_unref (ddm_plugin->hdwm);
   G_OBJECT_CLASS (drop_down_menu_plugin_parent_class)->finalize (object);
}
