/*
 * Copyright (C) 2007 Intel Corporation
 *
 * Author:  Horace Li <horace.li@intel.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#ifndef NAV_PREV_APP_PLUGIN_H
#define NAV_PREV_APP_PLUGIN_H

#include <glib-object.h>
#include <libhildondesktop/tasknavigator-item.h>
#include <libhildonwm/hd-wm.h>

G_BEGIN_DECLS

typedef struct _NavPrevAppPlugin NavPrevAppPlugin;
typedef struct _NavPrevAppPluginClass NavPrevAppPluginClass;
typedef struct _NavPrevAppPluginPrivate NavPrevAppPluginPrivate;

#define NAV_PREV_APP_TYPE_PLUGIN            (nav_prev_app_plugin_get_type ())
#define NAV_PREV_APP_PLUGIN(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), NAV_PREV_APP_TYPE_PLUGIN, NavPrevAppPlugin))
#define NAV_PREV_APP_PLUGIN_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass),  NAV_PREV_APP_TYPE_PLUGIN, NavPrevAppPluginClass))
#define NAV_PREV_APP_IS_PLUGIN(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NAV_PREV_APP_TYPE_PLUGIN))
#define NAV_PREV_APP_IS_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass),  NAV_PREV_APP_TYPE_PLUGIN))
#define NAV_PREV_APP_PLUGIN_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj),  NAV_PREV_APP_TYPE_PLUGIN, NavPrevAppPluginClass))

struct _NavPrevAppPlugin 
{
   TaskNavigatorItem tnitem;
   HDWM *hdwm;
   GtkWidget *btn;
   NavPrevAppPluginPrivate *priv;
};

struct _NavPrevAppPluginClass 
{
   TaskNavigatorItemClass parent_class;
};

GType  nav_prev_app_plugin_get_type  (void);

G_END_DECLS

#endif //NAV_PREV_APP_PLUGIN_H
