/*
 * Copyright (c) 2001-2003 Shiman Associates Inc. All Rights Reserved.
 * 
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use, copy,
 * modify, merge, publish, distribute, sublicense, and/or sell copies
 * of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 */
/*
 * $Id: solaris.h,v 1.2 2003/06/26 21:09:18 rocko Exp $
 *
 * Copyright (c) 2000, 2001 by Shiman Associates Inc. and Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use, copy,
 * modify, merge, publish, distribute, sublicense, and/or sell copies
 * of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions: The above
 * copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * Except as contained in this notice, the names of the authors or
 * copyright holders shall not be used in advertising or otherwise to
 * promote the sale, use or other dealings in this Software without
 * prior written authorization from the authors or copyright holders,
 * as applicable.
 *
 * All trademarks and registered trademarks mentioned herein are the
 * property of their respective owners. No right, title or interest in
 * or to any trademark, service mark, logo or trade name of the
 * authors or copyright holders or their licensors is granted.
 *
 */

#ifndef _ANX_SOLARIS_H
#define _ANX_SOLARIS_H

#include <sys/audio.h>

#define DEFAULT_RES_STATE_ITO_S 10
#define DEFAULT_RES_STATE 2

#define PLAY_BUFFER_SIZE        32768
#define REC_BUFFER_SIZE         32768

/* this is the recording segment length... need to make adjustable */
/* it MUST be an integer multiple of BPSTC */

#define MAS_ANX_SEGLEN 2304      /* 13.06ms of bytes using 44100hz 2channel 16bit samples. */

/*
 * Choosing DEFAULT_FILL_LINE_US:
 * 1. Don't make it too large because it gets written all at once to
 *    the soundcard.
 * 2. Taking into account the sample size and channels, this time-size
 *    has to be smaller than PLAY_BUFFER_SIZE.
 * 
 */
#define DEFAULT_FILL_LINE_US    30000.0
#define REC_BUFFER_SIZE_MS 50
#define PLAY_BUFFER_SIZE_MS 50
#define DEFAULT_BUFTIME_MS      60

/* if FALSE, don't rebuffer if we underrun */
#define REBUFFER                FALSE

#define ALLOCATED_MIX_CH        16

struct solaris_audio_state
{
    int fd;
    struct audio_info info;
    struct audio_device device;

    struct anx_buffer* recbuf;
    
    /* mixer */
    uint_t solaris_ap_map[ALLOCATED_MIX_CH];
    
    /* stream state information */

};

#endif /* _ANX_SOLARIS_H */
