/*
 * Copyright (c) 2001-2003 Shiman Associates Inc. All Rights Reserved.
 * 
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use, copy,
 * modify, merge, publish, distribute, sublicense, and/or sell copies
 * of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 */
#ifndef _SOURCE_PLAYLIST_H
#define _SOURCE_PLAYLIST_H

#include "mas/mas_dpi.h"
#include "source_internal.h"

enum repeat_mode
{
    REPEAT_NONE = 0,
    REPEAT_1 = 1,
    REPEAT_ALL = 2
};

struct plist
{
    int16     c; /*current*/
    int repmode;
    struct track_info* head;
};

extern struct track_info* get_track( struct plist* pl, int16 pos );
extern int32 append_track( struct plist* pl, struct track_info* tr );
extern int32 delete_track( struct track_info* tr );
extern struct plist* new_plist( void );
extern int32 clear_plist( struct plist* pl );
extern int32 delete_plist( struct plist* pl );
extern struct track_info* advance_track( struct plist* pl );
extern struct track_info* back_track( struct plist* pl );
extern struct track_info* set_track( struct plist* pl, int16 pos );

#endif /* _SOURCE_PLAYLIST_H */
