#! /usr/bin/env python
# -*- coding: utf-8 -*-
# Copyright 2003, Matthias A. Benkard.

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

from core.common import _, path
from wxgui import MainWindow;
import wxgui.common

import gettext;
import logging;
import sys;
import time;
import wx;
from wx import xrc;

log = logging.getLogger("gui")

class GUILogHandler(logging.Handler):
	"""A handler for severe errors that notifies the user via a dialog box."""
	
	def __init__(self, parent_window = None, level = logging.ERROR):
		logging.Handler.__init__(self, level)
		self.parent_window = parent_window
	
	def emit(self, record):
		dialog = gtk.MessageDialog(self.parent_window,
				gtk.DIALOG_MODAL | gtk.DIALOG_DESTROY_WITH_PARENT,
				gtk.MESSAGE_ERROR, gtk.BUTTONS_OK,
				_("Logger '%(name)s' reports an error of "
				  "severity '%(severity)s':\n%(msg)s\n\n"
				  "Exception:\n%(exception)s") % {
					"name": record.name,
					"severity": record.levelname,
					"msg": record.msg % record.args,
					"exception": record.exc_info
				})
		dialog.run()
		dialog.destroy()


class MascymaApp(wx.App):
	def OnInit(self):
		frame = MainWindow(None, -1, _("Mascyma"));
		frame.Show()
		self.SetTopWindow(frame)
		return True


def main():
	handler = GUILogHandler()
	log.addHandler(handler)
	
	try:
		locale = wx.Locale (wx.Locale.GetSystemLanguage(),
				wx.LOCALE_LOAD_DEFAULT | wx.LOCALE_CONV_ENCODING);
		locale.AddCatalogLookupPathPrefix(path["locale"]);
		locale.AddCatalog("mascyma");
	except:
		log.warn(_("Could not set wxWidgets locale."))
	
	wxgui.common.res = xrc.XmlResource(path["xrc"])
	
	wxgui.common.app = MascymaApp()
	wxgui.common.app.MainLoop()


if __name__ == '__main__':
    main()

