/* massXpert - the true massist's program.
   --------------------------------------
   Copyright(C) 2006,2007 Filippo Rusconi

   http://www.filomace.org/massXpert

   This file is part of the massXpert project.

   The massxpert project is the successor to the "GNU polyxmass"
   project that is an official GNU project package(see
   www.gnu.org). The massXpert project is not endorsed by the GNU
   project, although it is released ---in its entirety--- under the
   GNU General Public License. A huge part of the code in massXpert
   is actually a C++ rewrite of code in GNU polyxmass. As such
   massXpert was started at the Centre National de la Recherche
   Scientifique(FRANCE), that granted me the formal authorization to
   publish it under this Free Software License.

   This software is free software; you can redistribute it and/or
   modify it under the terms of the GNU  General Public
   License version 3, as published by the Free Software Foundation.
   

   This software is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this software; if not, write to the

   Free Software Foundation, Inc.,

   51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.
*/


#ifndef PLUGIN_INTERFACES_H
#define PLUGIN_INTERFACES_H


  class QString; 
  class QStringList;

  class SeqToolsPluginInterface
  {
  public:
    virtual ~SeqToolsPluginInterface() {}
  
    virtual QStringList tools() const = 0;
    virtual void toolAtWork(const QString &, QWidget *) = 0;
  };


  Q_DECLARE_INTERFACE(SeqToolsPluginInterface,
		       "org.massxpert.SeqToolsPluginInterface/1.0")
  
    
  class MassListSorterPluginInterface
  {
  public:
    virtual ~MassListSorterPluginInterface() {}
  
    virtual QStringList tools() const = 0;
    virtual void toolAtWork(const QString &, QWidget *) = 0;
  };


  Q_DECLARE_INTERFACE(MassListSorterPluginInterface,
		       "org.massxpert.MassListSorterPluginInterface/1.0")
  
    
  
  class NumeralsLocaleConverterPluginInterface
  {
  public:
    virtual ~NumeralsLocaleConverterPluginInterface() {}
  
    virtual QStringList tools() const = 0;
    virtual void toolAtWork(const QString &, QWidget *) = 0;
  };


  Q_DECLARE_INTERFACE
 (NumeralsLocaleConverterPluginInterface,
   "org.massxpert.NumeralsLocaleConverterPluginInterface/1.0")
  

#endif // PLUGIN_INTERFACES_H
